/*
 * Decompiled with CFR 0.152.
 */
package JCollections;

import JCollections.JHashtableEnumerator;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;

public class JUnsafeTable
extends Dictionary
implements Cloneable,
Serializable {
    Object[] keyVal;
    int size;

    public JUnsafeTable(int initialSize, float loadFactor) {
        initialSize = Math.max(3, initialSize);
        this.keyVal = new Object[initialSize * 2];
    }

    public JUnsafeTable(int initialSize) {
        initialSize = Math.max(3, initialSize);
        this.keyVal = new Object[initialSize * 2];
    }

    public JUnsafeTable() {
        this(3);
    }

    int locateIndex(Object key, boolean doGrow) {
        int hpos;
        if (doGrow && this.size * 3 >= this.keyVal.length) {
            try {
                this.ensureCapacity(this.keyVal.length * 3 / 2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int cnt = 0;
        int pos = hpos = 2 * ((key.hashCode() & Integer.MAX_VALUE) % (this.keyVal.length >> 1));
        while (this.keyVal[pos] != null) {
            if (key.equals(this.keyVal[pos])) break;
            ++cnt;
            pos = (pos + 2) % this.keyVal.length;
        }
        return pos >> 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Enumeration keys() {
        return new JHashtableEnumerator(this, true);
    }

    public Enumeration elements() {
        return new JHashtableEnumerator(this, false);
    }

    public boolean contains(Object value) {
        Enumeration en = this.elements();
        while (en.hasMoreElements()) {
            if (!en.nextElement().equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKeyByIdentity(Object value) {
        Enumeration en = this.elements();
        while (en.hasMoreElements()) {
            if (en.nextElement() != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public Object get(Object key) {
        int pos = this.locateIndex(key, false);
        return this.keyAt(pos) != null ? this.valueAt(pos) : null;
    }

    public Object put(Object key, Object value) {
        int pos = this.locateIndex(key, true);
        if (this.keyAt(pos) == null) {
            ++this.size;
        }
        Object tmp = this.valueAt(pos);
        this.setKeyValue(pos, key, value);
        return tmp;
    }

    public Object remove(Object keyOrg) {
        int pos = this.locateIndex(keyOrg, false);
        if (this.keyAt(pos) == null) {
            return null;
        }
        Object key = keyOrg;
        Object prev = this.valueAt(pos);
        Object item = null;
        this.setKeyValue(pos, null, null);
        --this.size;
        pos = (pos + 1) % this.getCapacity();
        while ((key = this.keyAt(pos)) != null) {
            item = this.valueAt(pos);
            if ((key.hashCode() & Integer.MAX_VALUE) % this.getCapacity() != pos) {
                --this.size;
                this.setKeyValue(pos, null, null);
                this.put(key, item);
            }
            pos = (pos + 1) % this.getCapacity();
        }
        return prev;
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        int n = this.getCapacity() - 1;
        while (n >= 0) {
            this.setKeyValue(n, null, null);
            --n;
        }
    }

    public Object clone() {
        JUnsafeTable res = new JUnsafeTable(this.size);
        res.keyVal = new Object[this.keyVal.length];
        System.arraycopy(this.keyVal, 0, res.keyVal, 0, this.keyVal.length);
        res.size = this.size;
        return res;
    }

    Object keyAt(int i) {
        return this.keyVal[i << 1];
    }

    void ensureCapacity(int newCap) {
        if (this.keyVal.length <= newCap << 1) {
            Object[] old = this.keyVal;
            this.keyVal = new Object[newCap << 1];
            this.size = 0;
            int n = old.length - 2;
            while (n >= 0) {
                if (old[n] != null) {
                    this.put(old[n], old[n + 1]);
                }
                n -= 2;
            }
        }
    }

    Object valueAt(int i) {
        return this.keyVal[(i << 1) + 1];
    }

    void setKeyValue(int i, Object key, Object value) {
        this.keyVal[i << 1] = key;
        this.keyVal[(i << 1) + 1] = value;
    }

    public int getCapacity() {
        return this.keyVal.length >> 1;
    }
}

