/*
 * Decompiled with CFR 0.152.
 */
package JWVFile;

import JWVFile.VVolume;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import netcomputing.tools.Platforms;

public class VFile
extends File {
    static char vsep = (char)47;

    public static void Copy(File from, File to) throws Exception {
        FileInputStream in = new FileInputStream(from);
        int fileLen = (int)from.length();
        int partLen = 1000000;
        FileOutputStream out = new FileOutputStream(to);
        byte[] buf = new byte[partLen];
        int maxCount = 1 + fileLen / partLen;
        int n = 0;
        while (n < maxCount) {
            if (n == maxCount - 1) {
                partLen = fileLen % partLen;
            }
            in.read(buf, 0, partLen);
            out.write(buf, 0, partLen);
            ++n;
        }
        in.close();
        out.close();
    }

    public static String FileToURL(String filePath) {
        filePath = VFile.resolveName(filePath);
        String res = "file:/";
        return res + filePath.replace(File.separatorChar, '/');
    }

    public static String NameWithoutExtension(String resolvedFile) {
        if ((resolvedFile = VFile.NameWithExtension(resolvedFile)).lastIndexOf(46) >= 0) {
            return resolvedFile.substring(0, resolvedFile.lastIndexOf(46));
        }
        return resolvedFile;
    }

    public static String LastDir(String resolvedFile) {
        resolvedFile = VFile.ExtractDir(resolvedFile);
        while (resolvedFile.endsWith(File.separator)) {
            resolvedFile = resolvedFile.substring(0, resolvedFile.length() - 1);
        }
        if (resolvedFile.indexOf(File.separator) >= 0) {
            return resolvedFile.substring(resolvedFile.lastIndexOf(File.separator));
        }
        return resolvedFile;
    }

    public static String RemoveLast(String resolvedFile) {
        while (resolvedFile.endsWith(File.separator)) {
            resolvedFile = resolvedFile.substring(0, resolvedFile.length() - 1);
        }
        int i = resolvedFile.lastIndexOf(File.separator);
        if (i >= 0) {
            return resolvedFile.substring(0, i);
        }
        return resolvedFile;
    }

    public static String ExtractDir(String resolvedFile) {
        resolvedFile = VFile.StripDoubleSeps(resolvedFile, File.separatorChar).toString();
        while (!new File(resolvedFile).isDirectory()) {
            if (resolvedFile.indexOf(File.separator) >= 0) {
                resolvedFile = resolvedFile.substring(0, resolvedFile.lastIndexOf(File.separator));
                continue;
            }
            return "";
        }
        return resolvedFile;
    }

    public static String Extension(String resolvedFile) {
        if (resolvedFile.indexOf(46) < 0) {
            if (resolvedFile.toUpperCase().endsWith("MAKEFILE")) {
                return "makefile";
            }
            return "";
        }
        return resolvedFile.substring(resolvedFile.lastIndexOf(46) + 1);
    }

    public static String NameWithExtension(String resolvedFile) {
        if (resolvedFile.indexOf(File.separator) >= 0) {
            return resolvedFile.substring(resolvedFile.lastIndexOf(File.separator) + 1, resolvedFile.length());
        }
        return resolvedFile;
    }

    public static String GetOSCapitalization(String path) {
        if (Platforms.IsLinux()) {
            return path;
        }
        try {
            path = new File(path).getCanonicalPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    public static boolean ContainsPathDir(String path, String toAdd) {
        if (Platforms.IsWindows()) {
            path = path.toUpperCase();
            toAdd = toAdd.toUpperCase();
        }
        Vector v = NCStringUtilities.SplitSeparatedString(File.pathSeparator, path);
        int n = 0;
        while (n < v.size()) {
            String s = (String)v.elementAt(n);
            while (s.endsWith(File.separator)) {
                s = s.substring(0, s.length() - 1);
            }
            v.setElementAt(s, n);
            ++n;
        }
        while (toAdd.endsWith(File.separator)) {
            toAdd = toAdd.substring(0, toAdd.length() - 1);
        }
        return v.indexOf(toAdd) >= 0;
    }

    public static String[] FilesEnding(String path, final String end) {
        VFile f = new VFile(path);
        if (!f.exists() || !f.isDirectory()) {
            return null;
        }
        return f.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(end);
            }
        });
    }

    public static String StripDoubleEntries(String path) {
        Vector v = NCStringUtilities.SplitSeparatedString(File.pathSeparator, path);
        StringBuffer res = new StringBuffer(path.length());
        int n = 0;
        while (n < v.size()) {
            if (v.indexOf(v.elementAt(n)) == n) {
                res.append(v.elementAt(n).toString());
                res.append(File.pathSeparator);
            }
            ++n;
        }
        return res.toString();
    }

    public static String ReplaceFileInPath(String path, String toReplaceEnding, String file2) {
        Vector v = NCStringUtilities.SplitSeparatedString(File.pathSeparator, path);
        toReplaceEnding = toReplaceEnding.toUpperCase();
        int n = 0;
        while (n < v.size()) {
            if (v.elementAt(n).toString().toUpperCase().endsWith(toReplaceEnding)) {
                v.setElementAt(file2, n);
                break;
            }
            ++n;
        }
        String res = "";
        int n2 = 0;
        while (n2 < v.size()) {
            res = res + v.elementAt(n2).toString();
            if (n2 < v.size() - 1) {
                res = res + File.pathSeparator;
            }
            ++n2;
        }
        return res;
    }

    public static StringBuffer StripDoubleSeps(String s, char separator) {
        StringBuffer result = new StringBuffer(s.length());
        boolean prev = false;
        int n = 0;
        while (n < s.length()) {
            if (s.charAt(n) == separator) {
                if (!prev) {
                    result.append(separator);
                }
                prev = true;
            } else {
                prev = false;
                result.append(s.charAt(n));
            }
            ++n;
        }
        return result;
    }

    public static VFile New(String name) {
        VFile vf = new VFile(name);
        return vf;
    }

    public static VFile New(String path, String name) {
        if (name == null) {
            name = "";
        }
        return VFile.New(path + vsep + name);
    }

    public static VFile New(String volume, String path, String name) {
        if (name == null) {
            name = "";
        }
        return VFile.New(volume + vsep + path + vsep + name);
    }

    public VFile(String dir, String name) {
        super(VFile.resolveName(dir + vsep + name));
    }

    public VFile(String name) {
        super(VFile.resolveName(name));
    }

    public VFile(File f, String name) {
        super(f.getAbsolutePath() + File.separator + VFile.resolveName(name));
    }

    public static boolean RenameFile(String oldName, String newName) {
        File old = new File(oldName);
        File newF = new File(newName);
        if (newF.exists()) {
            return false;
        }
        old.renameTo(newF);
        if (!newF.exists()) {
            System.gc();
            Runtime.getRuntime().runFinalization();
            old.renameTo(newF);
        }
        if (!newF.exists()) {
            Tracer.This.println("RENAMING FAILED:" + oldName + " " + newName);
            return false;
        }
        return true;
    }

    public static void main(String[] arg) throws Exception {
        VFile.Copy(new File("c:\\temp\\rt.jar"), new File("c:\\temp\\xx.zip"));
    }

    public static String ResolveName(String path) {
        return VFile.resolveName(path);
    }

    public static String FindBestMatchFromBack(String dir, Enumeration possibleDirs) {
        dir = VFile.StripDoubleSeps(dir, File.pathSeparatorChar).toString();
        while (dir.endsWith(File.separator)) {
            dir = dir.substring(0, dir.length() - 1);
        }
        String bestMatch = "";
        int bestLength = 0;
        while (possibleDirs.hasMoreElements()) {
            String actdir = (String)possibleDirs.nextElement();
            while (actdir.endsWith(File.separator)) {
                actdir = actdir.substring(0, actdir.length() - 1);
            }
            int i = dir.length() - 1;
            int j = actdir.length() - 1;
            boolean hadSeparator = false;
            while (i >= 0 && j >= 0 && actdir.charAt(j) == dir.charAt(i)) {
                if (dir.charAt(i) == File.separatorChar) {
                    hadSeparator = true;
                }
                --i;
                --j;
            }
            if (!hadSeparator || i <= bestLength) continue;
            bestLength = i;
            bestMatch = actdir;
        }
        return bestMatch;
    }

    public static String resolveName(String path) {
        String vol = path;
        while (vol.startsWith("#")) {
            int end = vol.indexOf(vsep);
            if (end < 0) {
                end = vol.length();
            }
            vol = VVolume.ResolveName(vol.substring(1, end)) + vol.substring(end);
        }
        String realp = vol.replace(vsep, File.separatorChar);
        realp = VFile.StripDoubleSeps(realp, File.separator.charAt(0)).toString();
        return realp;
    }

    public FileOutputStream getFileOutputStream() {
        return (FileOutputStream)this.getOutputStream();
    }

    public FileInputStream getFileInputStream() {
        return (FileInputStream)this.getInputStream();
    }

    public OutputStream getOutputStream() {
        try {
            return new FileOutputStream(this);
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
            return null;
        }
    }

    public InputStream getInputStream() {
        try {
            return new FileInputStream(this);
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
            return null;
        }
    }
}

