/*
 * Decompiled with CFR 0.152.
 */
package Jack;

import Jack.ISymbolTranslator;
import de.netcomputing.util.Tracer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Serializable;

public final class InputObject
implements Serializable {
    public static InputObject NOINPUT = new InputObject(-3, null);
    public static int EOFID = 0xFFFFFFF;
    public static InputObject EOF = new InputObject(EOFID, null);
    InputObject[] cont;
    int i;
    int filePos;
    int line;
    int col;
    boolean copyUp;
    byte[] myString;
    int myStringUsage;

    public void writeTo(DataOutput out) throws Exception {
        if (this.cont == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.cont.length);
            int i = 0;
            while (i < this.cont.length) {
                this.cont[i].writeTo(out);
                ++i;
            }
        }
        out.writeInt(this.i);
        out.writeInt(this.filePos);
        out.writeShort(this.line);
        out.writeShort(this.col);
        if (this.myString == null) {
            out.writeChar(0);
        } else {
            out.writeChar(this.myStringUsage);
            out.write(this.myString, 0, this.myStringUsage);
        }
    }

    public void readFrom(DataInput in) throws Exception {
        int clen = in.readInt();
        if (clen != -1) {
            this.cont = new InputObject[clen];
            int i = 0;
            while (i < this.cont.length) {
                this.cont[i] = new InputObject(0);
                this.cont[i].readFrom(in);
                ++i;
            }
        }
        this.i = in.readInt();
        this.filePos = in.readInt();
        this.line = in.readShort();
        this.col = in.readShort();
        this.myStringUsage = in.readChar();
        if (this.myStringUsage != 0) {
            this.myString = new byte[this.myStringUsage];
            in.readFully(this.myString);
        }
    }

    public InputObject(int id) {
        this(id, -1, -1, -1, null);
    }

    public InputObject(int c, InputObject[] o, boolean _copyUp) {
        this(c, o);
        this.copyUp = _copyUp;
    }

    public InputObject(int id, int pos, int _li, int _col, InputObject[] content) {
        this.reInit(id, pos, _li, _col, content);
    }

    public InputObject(int c, InputObject[] o) {
        this(c, -1, -1, -1, o);
        this.filePos = this.filePos();
        this.line = this.linePosition();
        this.col = this.colPosition();
    }

    public boolean containsPosition(InputObject other) {
        int lp = this.lineStartPosition();
        int olp = other.lineStartPosition();
        int le = this.lineEndPosition();
        int ole = other.lineEndPosition();
        return (lp < olp || lp == olp && this.colStartPosition() <= other.colStartPosition()) && (le > ole || le == ole && this.colEndPosition() >= other.colEndPosition());
    }

    public void reInit(int id, int pos, int _li, int _col, InputObject[] content) {
        this.i = id;
        this.filePos = pos;
        this.line = _li;
        this.col = _col;
        this.cont = content;
        this.copyUp = false;
        this.myStringUsage = 0;
    }

    public byte[] getMyString() {
        return this.myString;
    }

    public InputObject[] getContent() {
        return this.cont;
    }

    public void setContent(InputObject[] o) {
        this.cont = o;
    }

    public String toString() {
        return this.toString(null);
    }

    public int getIntVal() {
        return this.i;
    }

    public void setIntVal(int ii) {
        this.i = ii;
    }

    public int length() {
        int l = 0;
        if (this.cont != null) {
            int n = 0;
            while (n < this.cont.length) {
                l += this.cont[n].length();
                ++n;
            }
        } else if (this.myString != null) {
            l = this.myStringUsage;
        }
        return l;
    }

    public int filePos() {
        if (this.filePos >= 0) {
            return this.filePos;
        }
        if (this.cont == null || this.cont.length < 1) {
            return -1;
        }
        this.filePos = this.cont[0].filePos();
        return this.filePos;
    }

    public int lineStartPosition() {
        if (this.cont == null || this.cont.length < 1) {
            return this.line;
        }
        return this.cont[0].lineStartPosition();
    }

    public int colStartPosition() {
        if (this.cont == null || this.cont.length < 1) {
            return this.col - 1;
        }
        return this.cont[0].colStartPosition();
    }

    public int linePosition() {
        if (this.line >= 0) {
            return this.line;
        }
        if (this.cont == null || this.cont.length < 1) {
            return -1;
        }
        this.line = this.cont[0].linePosition();
        return this.line;
    }

    public int colPosition() {
        if (this.col >= 0) {
            return this.col;
        }
        if (this.cont == null || this.cont.length < 1) {
            return -1;
        }
        this.col = this.cont[0].colPosition();
        return this.col;
    }

    public int lineEndPosition() {
        if (this.cont == null || this.cont.length < 1) {
            return this.line;
        }
        this.line = this.cont[this.cont.length - 1].lineEndPosition();
        return this.line;
    }

    public int colEndPosition() {
        if (this.cont == null || this.cont.length < 1) {
            if (this.myString != null) {
                return this.col + this.myString.length - 1;
            }
            return this.col;
        }
        this.col = this.cont[this.cont.length - 1].colEndPosition();
        return this.col;
    }

    public String toString(String sep) {
        if (this.cont != null) {
            StringBuffer result = new StringBuffer(this.cont.length);
            int n = 0;
            while (n < this.cont.length) {
                result.append(this.cont[n].toString(sep));
                if (sep != null) {
                    result.append(sep);
                }
                ++n;
            }
            return result.toString();
        }
        return this.myString == null ? "" + (char)this.i : new String(this.myString, 0, this.myStringUsage);
    }

    public void printMe(ISymbolTranslator symbolKnower, String distance) {
        Tracer.This.println(distance + symbolKnower.symbolFor(this.i) + "( ");
        if (this.cont != null) {
            int n = 0;
            while (n < this.cont.length) {
                this.cont[n].printMe(symbolKnower, distance + "  ");
                ++n;
            }
        } else {
            Tracer.This.println(distance + "   " + new String(this.myString, 0, this.myStringUsage));
        }
        Tracer.This.println(distance + ")");
    }
}

