/*
 * Decompiled with CFR 0.152.
 */
package Jack;

import JCollections.IntTable;
import Jack.PInputStack;
import Jack.PNonTermSet;
import Jack.PRuleBase;
import Jack.PRuleInfo;
import Jack.PRuleSet;
import Jack.PSymbolNode;
import de.netcomputing.util.Tracer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;

public class PSymbolTree
implements Serializable {
    static final long serialVersionUID = 7162625927330845065L;
    static int NOMATCH = 0;
    static int REPLACED = 1;
    public static int MAXPARSEDEPTH = 5000;
    transient PSymbolNode root = new PSymbolNode(PSymbolNode.ROOT);
    transient PRuleBase sKnower;
    static String empty = "";

    public void storeTo(DataOutput out, IntTable storedToID) {
        try {
            ((ObjectOutput)out).writeObject(this.sKnower);
            out.writeInt(this.hashCode());
            storedToID.put(this.hashCode(), Boolean.TRUE);
            this.root.storeTo(out, storedToID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFrom(DataInput in, IntTable storedToID) {
        try {
            this.sKnower = (PRuleBase)((ObjectInput)in).readObject();
            int hcode = in.readInt();
            storedToID.put(hcode, this);
            this.root = new PSymbolNode();
            this.root.loadFrom(in, storedToID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream oi) throws IOException, ClassNotFoundException {
        oi.defaultReadObject();
        Tracer.This.println("PSymbolTree::readObject");
        IntTable tab = new IntTable(1000);
        this.loadFrom(oi, tab);
    }

    private void writeObject(ObjectOutputStream oo) throws IOException {
        oo.defaultWriteObject();
        Tracer.This.println("PSymbolTree::writeObject");
        IntTable tab = new IntTable(1000);
        this.storeTo(oo, tab);
    }

    public void init(PRuleSet rset, PRuleBase prb) {
        this.sKnower = prb;
        Enumeration e = rset.enum();
        while (e.hasMoreElements()) {
            this.add((PRuleInfo)e.nextElement(), prb);
        }
        this.recursivelyLink(this.root, prb);
    }

    public void parse(PInputStack inputStack, int initialPosition) {
        this.parse(inputStack, initialPosition, 0);
    }

    public void parse(PInputStack inputStack, int initialPosition, int depth) {
        if (++depth > MAXPARSEDEPTH) {
            throw new RuntimeException("Parser Stackoverflow");
        }
        boolean tryagain = true;
        PSymbolNode bestMatch = null;
        PSymbolNode actNode = this.root;
        int position = initialPosition;
        inputStack.ensureReadAHead(initialPosition);
        PSymbolNode sn = actNode.match(inputStack.at(position).getIntVal());
        if (sn == null) {
            return;
        }
        ++position;
        actNode = sn;
        while (true) {
            if (actNode.hasNonTerms()) {
                this.sKnower.fatherNode = actNode;
                actNode.otherTree.parse(inputStack, position, depth);
            }
            if (actNode.isValidRuleEnd()) {
                bestMatch = sn;
            }
            if ((sn = actNode.match(inputStack.at(position).getIntVal())) == null) {
                if (bestMatch == null) {
                    return;
                }
                inputStack.replace(initialPosition, bestMatch.le, bestMatch.id, bestMatch.copyUp, this.sKnower);
                this.sKnower.lastNode = this.sKnower.fatherNode;
                this.sKnower.lastPos = initialPosition + 1;
                this.parse(inputStack, initialPosition, depth);
                return;
            }
            ++position;
            actNode = sn;
        }
    }

    void add(PRuleInfo pri, PRuleBase prb) {
        PSymbolNode sn = this.root;
        int[] intRule = pri.intRule;
        int rIdx = 0;
        while (rIdx < intRule.length) {
            PSymbolNode tmp = (PSymbolNode)sn.connections.fastGet(intRule[rIdx]);
            if (tmp == null) {
                tmp = new PSymbolNode(PSymbolNode.EMPTY);
                sn.connections.put(intRule[rIdx], tmp);
            }
            sn = tmp;
            ++rIdx;
        }
        if (sn.id != PSymbolNode.EMPTY) {
            Tracer.This.println("ambigous Rule while building symboltree " + sn.id);
            Tracer.This.println(prb.symbolFor(sn.id));
            Tracer.This.println(pri.toString(prb));
            return;
        }
        sn.id = pri.target;
        sn.le = intRule.length;
        if (pri.isCopyUp) {
            sn.copyUp = true;
        }
    }

    void recursivelyLink(PSymbolNode actNode, PRuleBase prb) {
        PNonTermSet nts = actNode.computeNTSet(prb);
        if (nts.size() > 0) {
            actNode.otherTree = prb.symTreeFor(nts);
        }
        Object[] e = actNode.connections.elements();
        int n = 0;
        while (n < e.length) {
            this.recursivelyLink((PSymbolNode)e[n], prb);
            ++n;
        }
    }

    public int[] keysAtLastNode() {
        return this.sKnower.lastNode == null ? null : this.sKnower.lastNode.keys();
    }

    public void printKeysAtLastNode() {
        if (this.sKnower.lastNode != null) {
            this.sKnower.lastNode.printKeys(this.sKnower);
        }
    }
}

