/*
 * Decompiled with CFR 0.152.
 */
package Jxe;

import JCollections.JArray;
import Jxe.AttributedTextLine;
import Jxe.EditPanel;
import Jxe.JXEOptions;
import Jxe.TextDocument;
import Jxe.TextView;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.debugger.DebuggerMainPanel;
import de.netcomputing.anyj.jwidgets.Binder;
import de.netcomputing.anyj.jwidgets.IActor;
import de.netcomputing.anyj.jwidgets.IPopupGetter;
import de.netcomputing.anyj.jwidgets.ISelectionProvider;
import de.netcomputing.anyj.jwidgets.JCanvas;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWCursorSwitcher;
import de.netcomputing.anyj.jwidgets.JWMenuBar;
import de.netcomputing.anyj.jwidgets.JWOptions;
import de.netcomputing.anyj.jwidgets.JWScrollable;
import de.netcomputing.util.NCGraphicUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.RepaintManager;
import netcomputing.tools.Platforms;

public class EditCanvas
extends JCanvas
implements TextView,
IActor,
MouseListener,
MouseMotionListener,
JWScrollable,
ISelectionProvider {
    TextDocument doc;
    Font font = new Font(JXEOptions.Monospaced, 0, JXEOptions.FontSize);
    int charW = 0;
    int charH = 0;
    int maxAsc = 0;
    EditPanel par;
    int pixPos = 0;
    int xoff = 0;
    boolean updateLock = false;
    public static int NUM_BUFF_THRESHOLD = 0;
    boolean canSelectWithMouse = true;
    IPopupGetter popUpGetter;
    static final int NONE = 0;
    static final int NORMAL = 1;
    static final int WORD = 2;
    static final int LINE = 3;
    int dragMode = 0;
    long timeStamp = 0L;
    static Image buff;
    static int buffWidth;
    boolean drawLineNos = false;
    Stroke kringels = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{4.0f, 4.0f}, 0.0f);
    public static Color CurrentCursorCol;
    public static Color ReadOnlyCurrentCursorCol;
    int lockUpdateAtLine = Integer.MAX_VALUE;
    boolean bdown;
    MouseEvent _e;
    Dimension dim = new Dimension(0, 0);

    void calcSizeMap(FontMetrics fm) {
    }

    public void setOffsetX(int x) {
        this.xoff = this.charW == 0 ? 0 : x / this.charW;
    }

    public void setOffsetY(int y) {
        this.pixPos = y;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void init() {
        this.doc = new TextDocument();
        this.setFont(this.font);
        this.updateFontMetrics();
        this.getDocument().init(this);
        this.getDocument().addLine("                                                   ");
        this.setBackground(JXEOptions.EditorBG);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (JWOptions.DO_SET_CURSOR_EDITOR) {
            this.addMouseListener(new JWCursorSwitcher(2));
        }
        this.setToolTipText(" ");
    }

    public Binder binder() {
        return this.getDocument().binder;
    }

    public boolean isOpaque() {
        return false;
    }

    public Object[] getDataSelection() {
        String s;
        Object[] res = null;
        String string = s = this.getDocument().hasSelection() ? this.getDocument().getSelectionAsString() : this.getDocument().currentWordAsString();
        if (!this.getDocument().hasSelection() && s.trim().length() == 0) {
            s = null;
        }
        int n = 0;
        if (s != null) {
            res = new Object[4];
            res[n++] = s;
        } else {
            res = new Object[3];
        }
        res[n++] = this.getDocument();
        res[n++] = this.getDocument().getFile();
        res[n++] = this.par;
        return res;
    }

    public int fullSizePixels() {
        this.updateFontMetrics();
        return this.getDocument().size() * this.charH;
    }

    public TextDocument getDocument() {
        return this.doc;
    }

    public void jwPaint(Graphics g) {
        boolean flag = false;
        Dimension d = this.size();
        if (buff == null || this.charH != buff.getHeight(this)) {
            if (buff != null) {
                buff.flush();
            }
            if ((buff = this.createImage(buffWidth, this.charH)) == null) {
                return;
            }
            this.setModified(true);
            Tracer.This.println("~~~~~~~~~~~~~~~createing Image editcanvas");
        }
        if (this.charW == 0 || this.charH == 0) {
            this.updateFontMetrics();
            flag = true;
        }
        int line = this.pixPos / this.charH;
        Rectangle r = g.getClipRect();
        if (r == null) {
            this.paintDoc(g, Math.max(0, line), line + 2 + d.height / this.charH, this.xoff, d.width / this.charW + 1 + this.xoff);
        } else {
            int tmp = Math.max(0, line + r.y / this.charH);
            this.paintDoc(g, tmp, tmp + r.height / this.charH + 3, this.xoff, d.width / this.charW + 1 + this.xoff);
        }
    }

    public void scrollTo(int pixelPos) {
        pixelPos = Math.min(this.charH * this.getDocument().size() - this.getHeight(), pixelPos);
        this.par.scrollYTo(pixelPos);
    }

    void translateG(Graphics g) {
        g.translate(0, this.charH - this.pixPos % this.charH - this.pixPos / this.charH * this.charH - this.charH);
        g.translate(-this.xoff * this.charW, this.charH - 4);
    }

    public int getLineHeight() {
        return this.charH;
    }

    void unTranslateG(Graphics g) {
        g.translate(0, -(this.charH - this.pixPos % this.charH - this.pixPos / this.charH * this.charH - this.charH));
        g.translate(-(-this.xoff * this.charW), -(this.charH - 4));
    }

    public void paintDoc(Graphics g, int starty, int endy, int startx, int endx) {
        Graphics buffg;
        boolean buffer;
        if (g == null) {
            return;
        }
        ((EditPanel)this.getParent()).checkComponentValues();
        boolean inverse = false;
        Dimension d = this.getSize();
        this.xoff = Math.max(this.xoff, 0);
        starty = Math.max(starty, this.pixPos / this.charH);
        endy = Math.min(endy, (this.pixPos + d.height) / this.charH + 2);
        endx = d.width / this.charW + 1 + this.xoff;
        startx = 0;
        this.translateG(g);
        boolean bl = buffer = endy - starty < NUM_BUFF_THRESHOLD;
        if (buffer) {
            buffg = buff.getGraphics();
            buffg.setColor(this.getBackground());
            buffg.clearRect(0, 0, this.charH, buffWidth);
        } else {
            buffg = g;
        }
        Color lineCol = JWColor.For("popup.bg");
        if (this.drawLineNos) {
            lineCol = new Color(lineCol.getRed(), lineCol.getGreen(), lineCol.getBlue(), 128);
        }
        int y = starty;
        while (y < endy && y < this.getDocument().size()) {
            AttributedTextLine s = this.getDocument().lineAt(y);
            if (buffer && (s.size() >= buffWidth / this.charW || this.getDocument().cX() > buffWidth / this.charW)) {
                buffg.dispose();
                buffg = g;
                buffer = false;
                Tracer.This.println("DISPOSE EDITOR BUFF");
            }
            Color oldBG = JXEOptions.EditorBG;
            int tmpY = buffer ? this.maxAsc : y * this.charH;
            boolean bl2 = inverse = y > this.getDocument().selStartLine && y < this.getDocument().selEndLine;
            if (y == this.getDocument().selStartLine && y == this.getDocument().selEndLine) {
                s.drawOn(buffg, tmpY, startx, endx, this.getDocument().selStartX, this.getDocument().selEndX, this.getDocument().styleTable(), this.charW, this.charH, this.maxAsc, this.getDocument(), null, y);
            } else if (y == this.getDocument().selStartLine) {
                s.drawOn(buffg, tmpY, startx, endx, this.getDocument().selStartX, endx, this.getDocument().styleTable(), this.charW, this.charH, this.maxAsc, this.getDocument(), null, y);
            } else if (y == this.getDocument().selEndLine) {
                s.drawOn(buffg, tmpY, startx, endx, startx, this.getDocument().selEndX, this.getDocument().styleTable(), this.charW, this.charH, this.maxAsc, this.getDocument(), null, y);
            } else if (inverse) {
                s.drawOn(buffg, tmpY, startx, endx, startx, endx, this.getDocument().styleTable(), this.charW, this.charH, this.maxAsc, this.getDocument(), null, y);
            } else {
                s.drawOn(buffg, tmpY, startx, endx, -1, -1, this.getDocument().styleTable(), this.charW, this.charH, this.maxAsc, this.getDocument(), null, y);
            }
            if (this.drawLineNos) {
                g.setColor(lineCol);
                int w = this.getWidth();
                int xo = this.charW * this.xoff;
                String li = "" + y;
                int fontW = g.getFontMetrics().stringWidth(li);
                g.fillRect(xo + w - fontW - 10, y * this.charH - this.maxAsc, fontW + 8, this.charH);
                g.setColor(Color.black);
                g.drawString(li, xo + w - fontW - 6, y * this.charH);
            }
            if (buffer) {
                g.drawImage(buff, 0, y * this.charH - this.maxAsc, this);
            }
            if (this.getDocument().cY() == y && !this.getDocument().cursorHidden && !this.getDocument().hasSelection()) {
                this.drawCursor(g, this.getDocument(), y);
            }
            if (this.getDocument().getDrawKringel() && y >= this.getDocument().getKringelStartY() && y < this.getDocument().getKringelEndY()) {
                Graphics2D sw = (Graphics2D)g;
                sw.setColor(Color.red);
                sw.setStroke(this.kringels);
                int shift = 4;
                boolean xoffTmp = false;
                if (y == this.getDocument().getKringelStartY() && this.getDocument().getKringelEndY() == y + 1) {
                    sw.drawLine(this.charW * (0 + s.translateX(Math.max(this.getDocument().getKringelStartX(), s.getFirstChar()))), y * this.charH + 1, this.charW * 0 + s.translateX(Math.min(this.getDocument().getKringelEndX(), s.size())) * this.charW, y * this.charH + 1);
                    sw.drawLine(4 + this.charW * (0 + s.translateX(Math.max(this.getDocument().getKringelStartX(), s.getFirstChar()))), y * this.charH + 2, this.charW * 0 + s.translateX(Math.min(this.getDocument().getKringelEndX(), s.size())) * this.charW, y * this.charH + 2);
                } else if (y == this.getDocument().getKringelStartY()) {
                    sw.drawLine(this.charW * (0 + s.translateX(Math.max(this.getDocument().getKringelStartX(), s.getFirstChar()))), y * this.charH + 1, this.charW * 0 + s.translateX(s.size()) * this.charW, y * this.charH + 1);
                    sw.drawLine(4 + this.charW * (0 + s.translateX(Math.max(this.getDocument().getKringelStartX(), s.getFirstChar()))), y * this.charH + 2, this.charW * 0 + s.translateX(s.size()) * this.charW, y * this.charH + 2);
                } else if (y == this.getDocument().getKringelEndY() - 1) {
                    sw.drawLine(this.charW * (0 + s.translateX(s.getFirstChar())), y * this.charH + 1, this.charW * 0 + s.translateX(Math.min(this.getDocument().getKringelEndX(), s.size())) * this.charW, y * this.charH + 1);
                    sw.drawLine(4 + this.charW * (0 + s.translateX(s.getFirstChar())), y * this.charH + 2, this.charW * 0 + s.translateX(Math.min(this.getDocument().getKringelEndX(), s.size())) * this.charW, y * this.charH + 2);
                } else {
                    sw.drawLine(this.charW * (0 + s.translateX(s.getFirstChar())), y * this.charH + 1, this.charW * 0 + s.translateX(s.size()) * this.charW, y * this.charH + 1);
                    sw.drawLine(4 + this.charW * (0 + s.translateX(s.getFirstChar())), y * this.charH + 2, this.charW * 0 + s.translateX(s.size()) * this.charW, y * this.charH + 2);
                }
            }
            if (JXEOptions.DRAWLINE) {
                g.setColor(Color.lightGray);
                g.drawLine(this.charW * JXEOptions.LINECOL, y * this.charH - this.charH - this.charH, this.charW * JXEOptions.LINECOL, y * this.charH + this.charH + this.charH);
            }
            ++y;
        }
        if (buffer) {
            buffg.dispose();
        }
        if (!EditApp.MenuOpen) {
            Graphics gg = this.par.getGraphics();
            this.par.drawMarkers(gg, true);
            gg.dispose();
        }
    }

    public Point docXYToScreen(int x, int y) {
        AttributedTextLine line = this.getDocument().lineAt(y);
        x = line.translateX(x);
        x = (x - this.xoff) * this.charW;
        y = y * this.charH + this.charH - this.pixPos;
        Point p = this.getLocationOnScreen();
        p.x += x;
        p.y += y;
        return p;
    }

    protected void drawCursor(Graphics g, TextDocument doc, int y) {
        int viewX = !this.getDocument().isVirtualSpace() ? Math.min(this.getDocument().cX(), this.getDocument().lineAt(this.getDocument().cY()).size()) : this.getDocument().cX();
        viewX = this.getDocument().lineAt(this.getDocument().cY()).translateX(viewX);
        if (this.getDocument().isReadOnly()) {
            g.setColor(ReadOnlyCurrentCursorCol);
            g.fillRect(viewX * this.charW, y * this.charH - this.maxAsc, 2, this.charH);
        } else {
            g.setColor(CurrentCursorCol);
            g.fillRect(viewX * this.charW, y * this.charH - this.maxAsc, 2, this.charH);
        }
    }

    public void adjustPosition(int x, int y) {
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        if (this.charH == 0) {
            this.updateFontMetrics();
        }
        int oldxoff = this.xoff;
        Dimension d = this.size();
        if (y < this.getDocument().size() && y >= 0) {
            x = this.getDocument().lineAt(y).translateX(x);
        }
        if (x > this.xoff + d.width / this.charW) {
            this.xoff = Math.max(x - d.width / this.charW / 2, 0);
        }
        if (x < this.xoff) {
            this.xoff = Math.max(x - d.width / this.charW / 2, 0);
        }
        if (y <= this.pixPos / this.charH) {
            if (!Platforms.IsOSX()) {
                Platforms.ensureRepaintFinished(this);
            }
            this.scrollTo(y * this.charH);
            if (this.xoff != oldxoff) {
                oldxoff = this.xoff;
                this.par.scrollXTo(this.xoff * this.charW);
                this.repaint();
            }
        }
        if (y >= this.pixPos / this.charH + d.height / this.charH) {
            if (!Platforms.IsOSX()) {
                Platforms.ensureRepaintFinished(this);
            }
            this.scrollTo(Math.max(y * this.charH - d.height + this.charH, 0));
            if (this.xoff != oldxoff) {
                oldxoff = this.xoff;
                this.par.checkComponentValues();
                this.par.scrollXTo(this.xoff * this.charW);
                this.repaint();
            }
        }
        if (this.xoff != oldxoff) {
            if (!Platforms.IsOSX()) {
                Platforms.ensureRepaintFinished(this);
            }
            this.par.scrollXTo(this.xoff * this.charW);
        }
    }

    void updateFontMetrics() {
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.charW = fm.stringWidth(" ");
        this.charH = fm.getHeight();
        this.maxAsc = fm.getMaxAscent();
        if (this.par != null) {
            this.par.setGrid(this.charW, 1);
            this.par.leftOffset = 2 * this.charW;
            this.par.scrollbarHorz().setLineIncrement(this.charW);
        }
    }

    public void updateView(int starty, int endy, int startx, int endx) {
        this.privateUpdateView(starty, endy, startx, endx, false);
    }

    public void setOffset(int topLine) {
        this.scrollTo(topLine * this.charH);
    }

    public void immediateUpdateView(int starty, int endy, int startx, int endx, boolean onlyBuffer) {
        this.privateUpdateView(starty, endy, startx, endx, onlyBuffer);
    }

    public void setLockUpdateAtLine(int lockUpdateAtLine) {
        this.lockUpdateAtLine = lockUpdateAtLine;
    }

    public int getLockUpdateAtLine() {
        return this.lockUpdateAtLine;
    }

    void privateUpdateViewImmediate(int starty, int endy, int startx, int endx, boolean onlyBuffer) {
        int h;
        this.par.checkComponentValues();
        if (this.updateLock || buff == null) {
            return;
        }
        if (starty > endy) {
            h = starty;
            starty = endy;
            endy = h;
        }
        if (startx > endx) {
            h = startx;
            startx = endx;
            endx = h;
        }
        if (!this.isShowing()) {
            return;
        }
        int fendy = endy = Math.min(this.lockUpdateAtLine, endy);
        int fstarty = starty;
        Graphics buffg = this.getGraphics();
        if (buffg == null) {
            Tracer.This.println("ALERT BUFFG == NULL");
            return;
        }
        Dimension dim = this.getSize();
        buffg.setClip(0, 0, dim.width, dim.height);
        this.paintDoc(buffg, fstarty, fendy, 0, 65525);
        buffg.dispose();
    }

    void privateUpdateView(int starty, int endy, int startx, int endx, boolean onlyBuffer) {
        int h;
        this.par.checkComponentValues();
        if (this.updateLock || buff == null) {
            return;
        }
        if (starty > endy) {
            h = starty;
            starty = endy;
            endy = h;
        }
        if (startx > endx) {
            h = startx;
            startx = endx;
            endx = h;
        }
        if (!this.isShowing()) {
            return;
        }
        endy = Math.min(this.lockUpdateAtLine, endy);
        this.repaint(0, -this.pixPos + (starty - 1) * this.charH - 2, 65525, (endy - starty) * this.charH + this.charH + 4);
    }

    public void repaintAll() {
        this.repaint();
    }

    public int visibleLines() {
        return this.size().height / this.charH;
    }

    public void page(int h) {
        this.scrollTo(Math.min(this.charH * this.getDocument().size() - this.getHeight(), this.pixPos + h * this.charH));
    }

    public void lockUpdate(boolean b) {
        this.updateLock = b;
    }

    public void characterFromXY(int x, int y, Point result) {
        result.x = Math.max(0, Math.max(0, (x -= -this.xoff * this.charW) / this.charW));
        result.y = Math.max(0, ((y -= this.charH - this.pixPos % this.charH - this.pixPos / this.charH * this.charH - 4) + this.maxAsc) / this.charH);
        if (result.y >= 0 && result.y < this.getDocument().size()) {
            result.x = this.getDocument().lineAt(result.y).untranslateX(result.x);
        }
    }

    public void mouseClicked(MouseEvent e) {
        EditApp.SetLastSelectionProvider(this.par);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.dragMode = 0;
        if ((e.getModifiers() & 0x10) != 0) {
            this.bdown = false;
        }
        if (!(!e.isAltDown() && (e.getModifiers() & 0xC) == 0 || this.menu == null && this.popUpGetter == null)) {
            if (this.popUpGetter != null) {
                this.menu = this.popUpGetter.getMenu(this, new JArray(3));
            }
            if (this.menu.getParent() == null) {
                this.add(this.menu);
            }
            this._e = e;
            Rectangle pos = new Rectangle(this._e.getX(), this._e.getY(), this.menu.getPreferredSize().width, this.menu.getPreferredSize().height);
            NCGraphicUtilities.adjustScreenPos(pos, this._e.getComponent());
            this.menu.show(this._e.getComponent(), pos.x, pos.y);
            return;
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public Object actionMenuKey(Object arg, Object sen) {
        if (this.popUpGetter != null) {
            JArray arr = new JArray(3);
            arr.add(this.getDocument().getFile());
            arr.add(this.par);
            arr.add(this.getDocument());
            String s = this.getDocument().getSelectedString();
            if (s != null) {
                arr.add(s);
            }
            this.menu = this.popUpGetter.getMenu(this.par, arr);
        }
        if (this.menu.getParent() == null) {
            this.add(this.menu);
        }
        boolean x = false;
        boolean y = false;
        new Thread(new Runnable(){

            public void run() {
                Rectangle pos = new Rectangle(0, 0, EditCanvas.this.menu.getPreferredSize().width, EditCanvas.this.menu.getPreferredSize().height);
                NCGraphicUtilities.adjustScreenPos(pos, EditCanvas.this);
                if (Platforms.IsLinux()) {
                    EditCanvas.this.menu.show(EditCanvas.this, pos.x, pos.y - 2);
                } else {
                    EditCanvas.this.menu.show(EditCanvas.this, pos.x, pos.y);
                }
            }
        }).start();
        return null;
    }

    public void mousePressed(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0) {
            if (this.bdown) {
                return;
            }
            this.bdown = true;
        }
        JWMenuBar.ResetMenu();
        EditFrame ef = EditFrame.Host().findEditFrame((EditPanel)this.getParent());
        if (ef != null) {
            if (this.getDocument() != null) {
                if (this.drawLineNos || this.getDocument().getHiLightWord() != null && this.getDocument().getHiLightWord().length() > 0) {
                    this.drawLineNos = false;
                    this.repaint();
                }
                this.getDocument().setHiLightWord("");
            }
            ef.windowActivated(null);
        }
        this.requestFocus();
        if ((e.getModifiers() & 0x10) == 0) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        Point pos = new Point(0, 0);
        this.characterFromXY(x, y, pos);
        if ((e.getClickCount() > 1 || e.getX() < 0 || e.isAltDown() || e.isControlDown()) && this.canSelectWithMouse) {
            if (e.getClickCount() > 2 || e.isControlDown() || e.getX() < 0) {
                this.getDocument().moveCursorAbs(0, pos.y);
                this.getDocument().setSelection(0, pos.y, 0, Math.min(pos.y + 1, this.getDocument().size()));
                this.getDocument().setSelectingPoint(0, pos.y);
                this.doc.selectingStartX = 0;
                this.doc.selectingStartY = pos.y;
                this.dragMode = 3;
            } else if (!this.getDocument().hasSelection()) {
                String s = this.getDocument().currentWordAsString();
                char ch = this.getDocument().charAt(this.getDocument().cX(), this.getDocument().cY());
                if (new String("()[]{}").indexOf(ch) >= 0) {
                    if (new String("([{").indexOf(ch) >= 0) {
                        this.getDocument().moveCursor(1, 0);
                    }
                    this.getDocument().markBraces();
                    if (new String("([{").indexOf(ch) >= 0) {
                        this.doc.selectingStartX = Math.max(this.getDocument().selEndX() - 1, 0);
                        this.doc.selectingStartY = this.getDocument().selEndY();
                    } else {
                        this.doc.selectingStartX = this.getDocument().selStartX();
                        this.doc.selectingStartY = this.getDocument().selStartY();
                    }
                    this.dragMode = 2;
                } else {
                    this.getDocument().selectCurrentWord();
                    this.doc.selectingStartX = this.getDocument().cX();
                    this.doc.selectingStartY = this.getDocument().cY();
                    this.dragMode = 2;
                }
            } else {
                this.dragMode = 1;
            }
            this.par.binderMouseClick().notifyTargets(pos);
            e.consume();
            return;
        }
        this.par.binderMouseClick().notifyTargets(pos);
        if (this.canSelectWithMouse) {
            if (e.isShiftDown()) {
                if (!this.getDocument().hasSelection()) {
                    this.doc.selectingStartX = this.getDocument().cX();
                    this.doc.selectingStartY = this.getDocument().cY();
                }
                this.getDocument().setSelection(pos.x, pos.y, this.getDocument().selectingStartX, this.getDocument().selectingStartY);
            } else {
                this.getDocument().unsetSelection();
                this.getDocument().moveCursorAbs(pos.x, pos.y);
                this.doc.selectingStartX = pos.x;
                this.doc.selectingStartY = pos.y;
                this.dragMode = 1;
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.canSelectWithMouse) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (y < 0) {
            this.scrollTo(this.pixPos + y / 3);
        } else if (y > this.size().height) {
            this.scrollTo(this.pixPos + (y - this.size().height) / 3);
        } else if (x > this.size().width) {
            this.par.scrollXTo(this.par.xOff() + 3 * this.charW);
        } else if (x < 0) {
            this.par.scrollXTo(this.par.xOff() - 3 * this.charW);
        }
        Point pos = new Point(0, 0);
        this.characterFromXY(x, y, pos);
        if (pos.x != this.getDocument().selectingStartX || pos.y != this.getDocument().selectingStartY) {
            switch (this.dragMode) {
                case 2: {
                    Point p1 = this.getDocument().getWordAt(pos.x, pos.y);
                    Point p2 = this.getDocument().getWordAt(this.getDocument().selectingStartX, this.getDocument().selectingStartY);
                    if (pos.y > this.getDocument().selectingStartY || pos.y == this.getDocument().selectingStartY && pos.x >= this.getDocument().selectingStartX) {
                        p1.x = p1.y;
                    } else {
                        p2.x = p2.y;
                    }
                    this.getDocument().setSelection(p2.x, this.getDocument().selectingStartY, p1.x, pos.y);
                    this.getDocument().setSelectingStartX(this.getDocument().selectingStartX);
                    this.getDocument().setSelectingStartY(this.getDocument().selectingStartY);
                    this.doc.cX = p1.x;
                    this.doc.cY = pos.y;
                    break;
                }
                case 1: {
                    this.getDocument().setSelection(this.getDocument().selectingStartX, this.getDocument().selectingStartY, pos.x, pos.y);
                    this.doc.cX = pos.x;
                    this.doc.cY = pos.y;
                    break;
                }
                case 3: {
                    if (pos.y < this.getDocument().selectingStartY) {
                        this.getDocument().setSelection(0, pos.y, 0, this.getDocument().selectingStartY + 1);
                    } else {
                        this.getDocument().setSelection(0, this.getDocument().selectingStartY, 0, pos.y + 1);
                    }
                    this.getDocument().setSelectingStartX(this.getDocument().selectingStartX);
                    this.getDocument().setSelectingStartY(this.getDocument().selectingStartY);
                    this.doc.cX = 0;
                    this.doc.cY = pos.y + 1;
                }
            }
        }
        e.consume();
    }

    public void propagateAction(String selector, Object arg, Object sender) {
        ((EditPanel)this.getParent()).propagateAction(selector, arg, sender);
    }

    public Frame getTopFrame() {
        return (Frame)this.getFrame();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public String getToolTipText(MouseEvent event) {
        if (this.getDocument().getFile() == null || !this.getDocument().getFile().getName().endsWith(".java")) {
            return null;
        }
        try {
            String val;
            Point p = new Point();
            this.characterFromXY(event.getX(), event.getY(), p);
            if (this.getDocument().getDrawKringel() && this.getDocument().getKringelText() != null && this.getDocument().isInRange(p.x, p.y, this.doc.getKringelStartX(), this.doc.getKringelStartY(), this.doc.getKringelEndX(), this.doc.getKringelEndY())) {
                return this.getDocument().getKringelText();
            }
            Point np = this.getDocument().getWordAt(p.x, p.y);
            String s = this.getDocument().getPartAsString(p.y, np.x, np.y);
            if (s == null || s.length() == 0) {
                return null;
            }
            if (DebuggerMainPanel.This() != null && (val = DebuggerMainPanel.This().evaluateVar(s)) != null) {
                return val;
            }
            IndexEntry ie = SourceBase.This().getPossibleClassDefFor(s, this.getDocument().getFile().getAbsolutePath());
            if (ie != null) {
                return ie.getDisplayString();
            }
            ie = SourceBase.This().getPossibleDefinitionOf(s, this.getDocument().getFile());
            if (ie != null) {
                return ie.getType() + " " + ie.getName() + " in " + ie.className();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Dimension preferredSize() {
        if (this.getDocument() != null) {
            this.dim.height = this.getDocument().size() * this.charH;
            this.dim.width = (this.getDocument().maxWidth + 3) * this.charW / 60 * 60 + 60;
        } else {
            this.dim.height = 640;
            this.dim.width = 400;
        }
        return this.dim;
    }

    static {
        buffWidth = 2000;
        CurrentCursorCol = new Color(255, 0, 0);
        ReadOnlyCurrentCursorCol = new Color(0, 0, 255);
    }
}

