/*
 * Decompiled with CFR 0.152.
 */
package Jxe.completers;

import Jxe.DocumentStream;
import Jxe.TextDocument;
import Jxe.completers.HtmlCompleter;
import java.io.File;
import java.util.Vector;

public class JSPCompleter
extends HtmlCompleter {
    public JSPCompleter(File config) {
        super(config);
    }

    protected String findIfInTag(TextDocument doc) {
        DocumentStream ds = new DocumentStream(doc, doc.cX(), doc.cY());
        int c = 0;
        int prevC = 0;
        StringBuffer lastTag = new StringBuffer(10);
        while ((c = ds.readBackward()) > 0) {
            if (this.isTagChar((char)c)) {
                lastTag.append((char)c);
            } else {
                if (c == 62) {
                    return null;
                }
                if (c == 60) {
                    if (prevC == 47) {
                        return null;
                    }
                    String tag = lastTag.reverse().toString().trim();
                    if ("%@".equals(tag)) {
                        ds.read();
                        ds.read();
                        ds.read();
                        while (Character.isWhitespace((char)ds.read())) {
                        }
                        ds.readBackward();
                        String directive = "";
                        while (!Character.isWhitespace((char)(c = ds.read()))) {
                            directive = directive + (char)c;
                        }
                        if ("page".equals(directive = directive.toLowerCase()) || "include".equals(directive) || "taglib".equals(directive)) {
                            return tag + directive;
                        }
                    }
                    if (tag.length() > 0) {
                        return tag;
                    }
                }
                lastTag.setLength(0);
            }
            if (c <= 32) continue;
            prevC = c;
        }
        return null;
    }

    protected Vector getAttributesAsVector(String tag) {
        if (tag != null && tag.startsWith("%@")) {
            if ("%@".equals(tag = tag.toLowerCase())) {
                Vector<String> res = new Vector<String>();
                res.add("page");
                res.add("include");
                res.add("taglib");
                return res;
            }
            if (tag.equals("%@page")) {
                Vector<String> res = new Vector<String>();
                res.add("language");
                res.add("extends");
                res.add("import");
                res.add("session");
                res.add("buffer");
                res.add("autoFlush");
                res.add("isThreadSafe");
                res.add("info");
                res.add("errorPage");
                res.add("isErrorPage");
                res.add("contentType");
                res.add("pageEncoding");
                return res;
            }
            if (tag.equals("%@include")) {
                Vector<String> res = new Vector<String>();
                res.add("file");
                res.add("zzzzzzz");
                return res;
            }
            if (tag.equals("%@taglib")) {
                Vector<String> res = new Vector<String>();
                res.add("uri");
                res.add("prefix");
                return res;
            }
            return new Vector(1);
        }
        return super.getAttributesAsVector(tag);
    }

    protected String getHid(String tag) {
        if ("%@".equals(tag)) {
            return "jsp_klammeraffe";
        }
        if ("%@page".equals(tag)) {
            return "jsp_page";
        }
        if ("%@taglib".equals(tag)) {
            return "jsp_taglib";
        }
        if ("%@include".equals(tag)) {
            return "jsp_include";
        }
        if ("%".equals(tag)) {
            return "jsp_builtin";
        }
        return super.getHid(tag);
    }
}

