/*
 * Decompiled with CFR 0.152.
 */
package Jxe.highlighters;

import Jxe.AttributedTextLine;
import Jxe.DocumentStream;
import Jxe.IHighlighter;
import Jxe.ISyntaxHighlighter;
import Jxe.TextDocument;
import de.netcomputing.util.Tracer;
import editapp.SourceBase;

public class JavaHighlighter
implements IHighlighter {
    public static int CLASS = 1;
    public static int METHOD = 2;
    public static int NUMBER = 3;
    public static int KEYWORD = 4;
    public static int COMMENT = 5;
    public static int ID = 6;
    public static int STRING = 7;
    public static int CHAR = 8;
    public static int LINECOMMENT = 9;
    ISyntaxHighlighter ish;
    DocumentStream ds;
    TextDocument doc;
    boolean stopAtFirstComment = false;
    boolean stopAfterFirstComment = false;
    boolean doUpdate = true;
    boolean onlyLines = false;
    boolean ignoreLines = false;
    int startState = 0;
    int minimumY = 0;

    public JavaHighlighter() {
        try {
            this.init(null, SourceBase.This(), 0, 0);
        }
        catch (NoClassDefFoundError e) {
            this.init(null, null, 0, 0);
        }
    }

    public JavaHighlighter(ISyntaxHighlighter _ish) {
        this.init(null, _ish, 0, 0);
    }

    public void highlightAll(TextDocument doc) {
        Tracer.This.println("***** Highligh All");
        if (this.doc != doc) {
            this.setDoc(doc);
        }
        this.ds.setPosition(0, 0);
        this.start();
    }

    public void processChange(TextDocument doc, int y, int yend, int length, boolean insert, boolean update) {
        if (this.doc != doc) {
            this.setDoc(doc);
        }
        this.processChange(y, yend, length, insert, update);
    }

    public void setDoc(TextDocument doc) {
        this.ds = new DocumentStream(doc, 0, 0);
        this.doc = doc;
    }

    public TextDocument getDoc() {
        return this.doc;
    }

    public JavaHighlighter(TextDocument td, ISyntaxHighlighter _ish, int posX, int posY) {
        this.init(td, _ish, posX, posY);
    }

    public void startNewInstance(int x, int y) {
        new JavaHighlighter(this.ds.getDoc(), this.ish, x, y).start();
    }

    public void startNewInstance(int x, int y, int minX, int minY) {
        JavaHighlighter jh = new JavaHighlighter(this.ds.getDoc(), this.ish, x, y);
        jh.minimumY = minY;
        jh.stopAfterFirstComment = true;
        while (jh.ds.posY() < this.ds.getDoc().size() && jh.ds.posY() <= minY) {
            jh.start();
        }
    }

    public void init(TextDocument td, ISyntaxHighlighter _ish, int posX, int posY) {
        this.ds = new DocumentStream(td, posX, posY);
        this.doc = td;
        this.ish = _ish;
    }

    public void computeKlaDepth() {
        this.computeKlaDepth(0, this.doc.size());
    }

    int computeKlaDepth(int startLine, int endLine) {
        DocumentStream ds = new DocumentStream(this.doc, 0, startLine);
        int c = 0;
        char style = '\u0000';
        int d = 0;
        if (ds.posY() > 0) {
            d = this.doc.lineAt((int)(ds.posY() - 1)).kldepth;
        }
        while ((c = ds.read()) > 0) {
            if (ds.posY() < 0) {
                return -1;
            }
            if (ds.posX() == 0) {
                AttributedTextLine li = this.doc.lineAt(ds.posY());
                if (ds.posY() > endLine && li.kldepth == d) break;
                li.kldepth = (short)d;
            }
            if (style == '\u0000') {
                if (c == 123) {
                    ++d;
                } else if (c == 125) {
                    --d;
                }
            }
            style = this.doc.styleAt(ds.posX(), ds.posY());
        }
        return Math.max(ds.posY(), endLine);
    }

    public void processChange(int _ystart, int _yend, int length, boolean insert, boolean update) {
        try {
            char leftStyle = '\u0000';
            int rightStyle = 0;
            int lcx = 0;
            int y = _ystart;
            int yend = _ystart;
            if (y > 0) {
                while (y > 1 && (lcx = this.doc.getLastCharX(y - 1)) < 0) {
                    --y;
                }
                if (lcx >= 0) {
                    leftStyle = this.doc.styleAt(lcx, y - 1);
                    if (lcx > 0 && this.doc.charAt(lcx, y - 1) == '/' && this.doc.charAt(lcx - 1, y - 1) == '*') {
                        leftStyle = '\u0000';
                    }
                }
            } else {
                this.doc.getView().updateView(_ystart, _yend, 0, 1024);
            }
            if ((y = _ystart) < this.doc.size() - 1) {
                while (y < this.doc.size() - 1 && (lcx = this.doc.getFirstCharX(y + 1)) >= this.doc.lineAt(y + 1).size()) {
                    ++y;
                }
                if (lcx >= 0 && y < this.doc.size() - 1) {
                    rightStyle = this.doc.styleAt(lcx, y + 1);
                    if (lcx < this.doc.lineAt(y + 1).size() - 1 && this.doc.charAt(lcx, y + 1) == '/' && this.doc.charAt(lcx + 1, y + 1) == '*') {
                        rightStyle = 0;
                    }
                }
            }
            this.runToEscEnd(_ystart, _yend, leftStyle, rightStyle, update);
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
            this.computeKlaDepth();
            this.doc.getView().updateView(_ystart, _yend, 0, 1024);
        }
    }

    public void runToEscEnd(int line, int lineEnd, int leftStyle, int rightStyle, boolean update) {
        this.ds.docX = 0;
        this.ds.docY = line;
        this.minimumY = lineEnd - 1;
        this.doUpdate = false;
        this.ignoreLines = false;
        this.startState = leftStyle == COMMENT ? COMMENT : 0;
        this.stopAfterFirstComment = false;
        this.stopAtFirstComment = false;
        this.onlyLines = true;
        this.run();
        int lcx = this.doc.getLastCharX(lineEnd - 1);
        int lineEndStyle = lcx != -1 && (lcx > 0 && this.doc.charAt(lcx, lineEnd - 1) == '/' && this.doc.charAt(lcx - 1, lineEnd - 1) == '*' || this.doc.styleAt(lcx, line) != COMMENT) ? 0 : COMMENT;
        if (rightStyle == COMMENT && lineEndStyle != COMMENT) {
            this.startState = 0;
            this.stopAfterFirstComment = true;
            this.stopAtFirstComment = true;
            this.onlyLines = false;
            this.ignoreLines = true;
            this.run();
        }
        if (rightStyle != COMMENT && lineEndStyle == COMMENT) {
            this.startState = leftStyle == COMMENT ? COMMENT : 0;
            this.ds.docX = 0;
            this.ds.docY = line;
            this.stopAfterFirstComment = true;
            this.stopAtFirstComment = false;
            this.onlyLines = false;
            this.ignoreLines = false;
            this.run();
        }
        int klaRep = this.computeKlaDepth(line - 2, this.ds.posY() + 1);
        if (update) {
            this.doc.getView().updateView(line, klaRep, 0, 1024);
        }
    }

    public void start(int x, int y) {
        this.ds.docX = x;
        this.ds.docY = y;
        this.start();
    }

    public void start() {
        this.stopAtFirstComment = false;
        this.stopAfterFirstComment = false;
        this.doUpdate = true;
        this.onlyLines = false;
        this.startState = 0;
        this.minimumY = this.doc.size();
        this.run();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        word = new StringBuffer(50);
        wsLine = this.ds.posY();
        wsCol = this.ds.posX();
        weLine = this.ds.posY();
        weCol = this.ds.posX();
        c = this.ds.read();
        ** GOTO lbl144
        {
            block36: {
                block35: {
                    wsLine = this.ds.posY();
                    wsCol = this.ds.posX();
                    if (c != 47 && this.startState != JavaHighlighter.COMMENT) break block35;
                    if (this.startState == JavaHighlighter.COMMENT) {
                        this.startState = 0;
                        c = 42;
                    } else {
                        c = (char)this.ds.read();
                    }
                    switch (c) {
                        case 42: {
                            if (this.stopAtFirstComment) {
                                return;
                            }
                            prevC = this.ds.read();
                            c = (char)this.ds.read();
                            while (!(c == 65535 || c == 47 && prevC == 42 || this.onlyLines && this.ds.posY() > this.minimumY)) {
                                prevC = c;
                                c = (char)this.ds.read();
                            }
                            if (wsCol > 0) {
                                --wsCol;
                            }
                            weLine = this.ds.posY();
                            weCol = this.ds.posX();
                            this.ds.getDoc().setStyle(JavaHighlighter.COMMENT, wsCol, wsLine, weCol, weLine, false);
                            word.setLength(0);
                            wsCol = weCol;
                            wsLine = weLine;
                            if ((this.stopAfterFirstComment || this.onlyLines) && (this.ignoreLines || weLine > this.minimumY)) {
                                return;
                            }
                            break block36;
                        }
                        case 47: {
                            if (wsCol > 0) {
                                --wsCol;
                            }
                            while (c != 65535 && this.ds.posY() == wsLine) {
                                weLine = this.ds.posY();
                                weCol = this.ds.posX();
                                c = (char)this.ds.read();
                            }
                            this.ds.getDoc().setStyle(JavaHighlighter.LINECOMMENT, wsCol, wsLine, weCol, weLine, false);
                            if (!this.ignoreLines && weLine > this.minimumY) {
                                return;
                            }
                            word.setLength(0);
                            wsCol = weCol;
                            wsLine = weLine;
                            break;
                        }
                        default: {
                            if (wsCol > 0) {
                                --wsCol;
                            }
                            weLine = this.ds.posY();
                            weCol = this.ds.posX();
                            this.ds.getDoc().setStyle(0, wsCol, wsLine, weCol, weLine, false);
                            word.setLength(0);
                            wsCol = weCol;
                            wsLine = weLine;
                            break;
                        }
                    }
                    break block36;
                }
                if (c == 34) {
                    c = (char)this.ds.read();
                    while (c != 65535 && c != 34 && wsLine == this.ds.posY()) {
                        if (c == 92) {
                            c = (char)this.ds.read();
                        }
                        c = (char)this.ds.read();
                    }
                    if (wsCol > 0) {
                        --wsCol;
                    }
                    if (this.ds.posY() > wsLine) {
                        this.ds.readBackward();
                    }
                    weLine = this.ds.posY();
                    weCol = this.ds.posX();
                    this.ds.getDoc().setStyle(JavaHighlighter.STRING, wsCol, wsLine, weCol, weLine, false);
                    if (!this.ignoreLines && weLine > this.minimumY) {
                        return;
                    }
                    word.setLength(0);
                    weLine = this.ds.posY();
                    weCol = this.ds.posX();
                    c = (char)this.ds.read();
                } else if (c == 39) {
                    c = (char)this.ds.read();
                    if (c == 92) {
                        c = (char)this.ds.read();
                    }
                    weLine = this.ds.posY();
                    weCol = this.ds.posX();
                    c = (char)this.ds.read();
                    if (wsCol > 0) {
                        --wsCol;
                    }
                    weLine = this.ds.posY();
                    weCol = this.ds.posX();
                    this.ds.getDoc().setStyle(JavaHighlighter.CHAR, wsCol, wsLine, weCol, weLine, false);
                    word.setLength(0);
                    weLine = this.ds.posY();
                    weCol = this.ds.posX();
                    c = (char)this.ds.read();
                    if (!this.ignoreLines && weLine > this.minimumY) {
                        return;
                    }
                } else {
                    this.ds.readBackward();
                    wsCol = this.ds.posX();
                    wsLine = this.ds.posY();
                    this.ds.read();
                    if (this.ds.posY() < this.ds.getDoc().size()) {
                        this.ds.getDoc().setStyle(0, wsCol, wsLine, this.ds.posX(), this.ds.posY(), c != 32 & false);
                    }
                    if (!this.ignoreLines && weLine > this.minimumY) {
                        return;
                    }
                    wsCol = this.ds.posX();
                    wsLine = this.ds.posY();
                    c = (char)this.ds.read();
                }
            }
            do {
                if (c != 65535 && !Character.isJavaIdentifierPart((char)c) || this.startState == JavaHighlighter.COMMENT) continue block4;
                if (c == 65535) continue;
                while (Character.isJavaIdentifierPart((char)c)) {
                    word.append((char)c);
                    weLine = this.ds.posY();
                    weCol = this.ds.posX();
                    c = (char)this.ds.read();
                }
                while (c <= 32) {
                    c = (char)this.ds.read();
                }
                if (c == 40) {
                    word.append((char)c);
                }
                style = 0;
                if (this.ish != null) {
                    style = this.ish.typeOf(word.toString());
                }
                this.ds.getDoc().setStyle(style, wsCol, wsLine, weCol, weLine, false);
                word.setLength(0);
                wsCol = weCol;
                wsLine = weLine;
                if (this.ignoreLines || weLine <= this.minimumY) continue;
                return;
lbl144:
                // 3 sources

            } while (c != 65535);
        }
        this.computeKlaDepth();
        if (this.doUpdate) {
            this.doc.getView().repaintAll();
        }
        Tracer.This.println("hl end");
    }
}

