/*
 * Decompiled with CFR 0.152.
 */
package Jxe.highlighters;

import Jxe.AttributedTextLine;
import Jxe.IHighlighter;
import Jxe.TextDocument;

public class JplHighlighter
implements IHighlighter {
    public void highlightAll(TextDocument doc) {
        int n = 0;
        while (n < doc.size()) {
            this.setLineStyle(doc, n, n + 10, true);
            n += 10;
        }
    }

    public void processChange(TextDocument doc, int li, int yend, int length, boolean insert, boolean update) {
        li = Math.max(li - 1, 0);
        while (li > 0 && doc.getLastCharX(li) == 0) {
            --li;
        }
        this.setLineStyle(doc, li, yend + 1, update);
    }

    void setLineStyle(TextDocument doc, int li, int yend, boolean update) {
        try {
            AttributedTextLine line = doc.lineAt(li);
            int style = line.histate;
            if (li == 0) {
                style = 7;
            }
            char c = '\u0000';
            char prev = '\u0000';
            int n = 0;
            while (n < line.size()) {
                char pprev = prev;
                prev = c;
                c = line.charAt(n);
                if (prev == '<' && c == '%') {
                    style = 0;
                }
                if (prev == '>' && pprev == '%' || c == '>' && prev == '%') {
                    style = 7;
                }
                line.setStyle(style, n, n + 1);
                ++n;
            }
            if (update) {
                doc.repaintLines(li, li + 1);
            }
            if (li < doc.size() - 1 && (doc.lineAt((int)(li + 1)).histate != style || li < yend)) {
                doc.lineAt((int)(li + 1)).histate = (short)style;
                this.setLineStyle(doc, li + 1, yend, update);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

