/*
 * Decompiled with CFR 0.152.
 */
package Jxe.highlighters;

import Jxe.AttributedTextLine;
import Jxe.IHighlighter;
import Jxe.TextDocument;
import Jxe.highlighters.JavaHighlighter;
import java.util.HashSet;

public class SqlHighlighter
implements IHighlighter {
    public static String[] keywords = new String[]{"ALL", "DESCRIBE", "LEAVE", "SECOND", "ALLOCATE", "DISCONNECT", "LEFT", "SELECT", "ALTER", "DISTINCT", "LIKE", "SESSION_USER", "AND", "DO", "LOCAL", "SET", "ANY", "DROP", "LOCALTIME", "SIGNAL", "ARE", "EACH", "LOCALTIMESTAMP", "SOME", "AS", "ELSE", "LOOP", "SPECIFIC", "AT", "ELSEIF", "MATCH", "SQLEXCEPTION", "AUTHORIZATION", "END", "MINUTE", "SQLSTATE", "BEGIN", "EXCEPT", "MODULE", "SQLWARNING", "BETWEEN", "EXECUTE", "MONTH", "START", "BOTH", "EXISTS", "NATIONAL", "SYSTEM_USER", "BY", "FALSE", "NATURAL", "TABLE", "CALL", "FETCH", "NEW", "THEN", "CASCADED", "FOR", "NOT", "TIMEZONE_HOUR", "CASE", "FOREIGN", "NULL", "TIMEZONE_MINUTE", "CAST", "FROM", "OF", "TO", "CHARACTER", "FULL", "OLD", "TRAILING", "CHECK", "FUNCTION", "ON", "TRANSLATION", "CLOSE", "GET", "ONLY", "TRIGGER", "COLLATE", "GLOBAL", "OPEN", "TRUE", "COLUMN", "GRANT", "OR", "UNION", "COMMIT", "GROUP", "ORDER", "UNIQUE", "CONNECT", "HAVING", "OUT", "UNKNOWN", "CONSTRAINT", "HOLD", "OUTER", "UNTIL", "CORRESPONDING", "HOUR", "OVERLAPS", "UPDATE", "CREATE", "IDENTITY", "PRECISION", "USER", "CROSS", "IF", "PREPARE", "USING", "CURRENT", "IN", "PRIMARY", "VALUE", "CURRENT_DATE", "INDICATOR", "CURRENT_PATH", "WITH", "PROCEDURE", "VALUES", "INNER", "REFERENCES", "VARYING", "CURRENT_TIME", "INOUT", "REFERENCING", "WHEN", "CURRENT_TIMESTAMP", "INSERT", "RELEASE", "WHERE", "CURRENT_USER", "INTERSECT", "REPEAT", "WHILE", "CURSOR", "INTERVAL", "RESIGNAL", "DAY", "INTO", "RETURN", "WITHOUT", "DEALLOCATE", "IS", "REVOKE", "YEAR", "DECLARE", "JOIN", "RIGHT", "DEFAULT", "LARGE", "ROLLBACK", "DELETE", "LEADING", "ROW", "URL", "CLASSPATH", "DRIVER", "PWD"};
    public static HashSet kwMap = new HashSet(keywords.length);

    public void highlightAll(TextDocument doc) {
        int n = 0;
        while (n < doc.size()) {
            this.setLineStyle(doc, n, n, true);
            ++n;
        }
    }

    public void processChange(TextDocument doc, int li, int yend, int length, boolean insert, boolean update) {
        this.setLineStyle(doc, li, yend, update);
    }

    void setLineStyle(TextDocument doc, int li, int yend, boolean update) {
        StringBuffer lastWord = new StringBuffer(20);
        try {
            short style = 0;
            do {
                AttributedTextLine line = doc.lineAt(li);
                line.setStyle(0, 0, line.size());
                if (li > 0) {
                    style = doc.lineAt((int)(li - 1)).histate;
                }
                lastWord.setLength(0);
                if (line.toString().trim().startsWith("//")) {
                    line.setStyle(JavaHighlighter.COMMENT, 0, line.size());
                } else {
                    char c = '\u0000';
                    char prev = '\u0000';
                    int n = 0;
                    while (n < line.size()) {
                        char pprev = prev;
                        prev = c;
                        c = line.charAt(n);
                        if (c <= '@' || n == line.size() - 1) {
                            if (n == line.size() - 1 && c > '@') {
                                lastWord.append(c);
                            }
                            if (kwMap.contains(lastWord.toString())) {
                                line.setStyle(4, n - lastWord.length(), n);
                            } else {
                                line.setStyle(0, n - lastWord.length(), n);
                            }
                            style = 0;
                            lastWord.setLength(0);
                        } else {
                            lastWord.append(c);
                        }
                        ++n;
                    }
                    if (update) {
                        doc.repaintLines(li, li + 1);
                    }
                    if (li > yend) {
                        return;
                    }
                }
                doc.lineAt((int)li).histate = style;
            } while (++li < doc.size());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static {
        int i = 0;
        while (i < keywords.length) {
            kwMap.add(keywords[i]);
            ++i;
        }
    }
}

