/*
 * Decompiled with CFR 0.152.
 */
package JxeExtensions;

import Jxe.DocumentStream;
import Jxe.EditorExtension;
import Jxe.JXEOptions;
import Jxe.KeyboardEvent;
import Jxe.TextDocument;
import Jxe.TextView;
import Jxe.highlighters.JavaHighlighter;
import java.io.File;

public class ExtBeautifyCode
extends EditorExtension {
    public boolean action(TextDocument doc, KeyboardEvent ke) {
        ExtBeautifyCode.Format(doc);
        return true;
    }

    public static void Format(TextDocument doc) {
        int startLine = doc.selStartY();
        int endLine = doc.selEndY();
        if (!doc.hasSelection()) {
            startLine = 0;
            endLine = doc.size() - 1;
        }
        ExtBeautifyCode.Format1(doc, startLine, endLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Format1(TextDocument doc, int startLine, int endLine) {
        TextView oldView = doc.getView();
        try {
            doc.setView(null);
            doc.unsetSelection();
            int actDepth = 0;
            int startDS = Math.max(0, startLine - 1);
            while (startDS >= 0 && doc.lineAt(startDS).toString().trim().length() == 0) {
                --startDS;
            }
            DocumentStream ds = new DocumentStream(doc, 0, startDS);
            while (ds.posY() > 0 && ds.readBackward() != 123) {
            }
            startDS = Math.max(0, ds.posY());
            actDepth = doc.lineAt(startDS).translateX(doc.lineAt(startDS).getFirstChar()) / JXEOptions.INDENT;
            if (ds.posY() == 0) {
                actDepth = 0;
            }
            StringBuffer s = new StringBuffer(200);
            int[] depthArr = new int[doc.size()];
            boolean[] blockCommand = new boolean[doc.size()];
            char[] klauf = new char[doc.size()];
            int switchindent = 0;
            int switchdepth = 0;
            boolean breaked = false;
            int prevLine = 0;
            do {
                s.setLength(0);
                ds.readJavaToken(s, false);
                String tok = s.toString().trim();
                int li = ds.posY();
                if (!tok.startsWith("/*") && !tok.startsWith("//")) {
                    if (tok.equals("break")) {
                        klauf[li] = 123;
                        breaked = true;
                        if (--switchindent < 0) {
                            switchindent = 0;
                        }
                    } else if (tok.equals("}") || tok.equals(")")) {
                        klauf[li] = tok.charAt(0);
                        if (actDepth == switchdepth) {
                            switchindent = 0;
                        }
                        --actDepth;
                    }
                }
                int n = prevLine + 1;
                while (n <= li && n < doc.size()) {
                    depthArr[n] = actDepth + switchindent;
                    ++n;
                }
                if (tok.equals("if") || tok.equals("else") || tok.equals("do") || tok.equals("while") || tok.equals("for") || tok.equals("try")) {
                    blockCommand[li] = true;
                }
                if (tok.equals("switch")) {
                    klauf[li] = 123;
                    switchdepth = switchindent = actDepth + 1;
                    breaked = true;
                } else if (tok.equals("case") || tok.equals("default")) {
                    klauf[li] = 123;
                    if (!breaked) {
                        depthArr[li] = switchdepth;
                    }
                    switchindent = 1;
                    breaked = false;
                } else if (tok.equals("{") || tok.equals("(")) {
                    klauf[li] = tok.charAt(0);
                    ++actDepth;
                }
                prevLine = li;
            } while (s.length() > 0 && ds.posY() < endLine + 2);
            int n = startDS;
            while (n <= endLine) {
                int i;
                if (n >= startLine && n <= endLine && n < doc.size() && doc.styleAt(i = doc.getFirstCharX(n), n) != JavaHighlighter.COMMENT) {
                    doc.delete(n, 0, i);
                    doc.insertTabInternal(n, depthArr[n] * JXEOptions.INDENT);
                }
                ++n;
            }
            int n2 = startDS;
            while (n2 <= endLine) {
                int i;
                if (n2 >= startLine && n2 <= endLine && n2 < doc.size() && n2 > 0 && blockCommand[n2 - 1] && depthArr[n2 - 1] == depthArr[n2] && klauf[n2 - 1] != '{' && klauf[n2] != '{' && doc.styleAt(i = doc.getFirstCharX(n2), n2) != JavaHighlighter.COMMENT) {
                    doc.delete(n2, 0, i);
                    doc.insertTabInternal(n2, (1 + depthArr[n2]) * JXEOptions.INDENT);
                }
                ++n2;
            }
            Object var19_19 = null;
            doc.setView(oldView);
            doc.repaintAll();
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            doc.setView(oldView);
            doc.repaintAll();
            throw throwable;
        }
    }

    public String description() {
        return "insert consequent tabbing";
    }

    public static void main(String[] args) throws Exception {
        TextDocument doc = new TextDocument(new File("d:\\temp\\Test.java"));
        doc.save();
    }
}

