/*
 * Decompiled with CFR 0.152.
 */
package JxeExtensions;

import Jxe.EditorExtension;
import Jxe.KeyboardEvent;
import Jxe.TextDocument;

public class ExtMarkBraces
extends EditorExtension {
    public static ExtMarkBraces This = new ExtMarkBraces();

    public boolean action(TextDocument doc, KeyboardEvent ke) {
        int y;
        int x;
        int rCnt = 0;
        if (doc.hasSelection()) {
            x = doc.selStartX();
            y = doc.selStartY();
        } else {
            x = doc.cX();
            y = doc.cY();
        }
        while (y >= 0 && rCnt >= 0) {
            if (--x < 0) {
                x = --y >= 0 ? doc.lineAt(y).size() : 0;
            }
            if (doc.styleAt(x, y) != '\u0000') continue;
            switch (doc.charAt(x, y)) {
                case '(': 
                case '[': 
                case '{': {
                    --rCnt;
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    ++rCnt;
                }
            }
        }
        int xl = x;
        int yu = Math.max(0, y);
        if (doc.hasSelection()) {
            x = doc.selEndX();
            y = doc.selEndY();
        } else {
            x = doc.cX();
            y = doc.cY();
        }
        rCnt = 0;
        while (y < doc.size() && rCnt >= 0) {
            if (doc.styleAt(x, y) == '\u0000') {
                switch (doc.charAt(x, y)) {
                    case '(': 
                    case '[': 
                    case '{': {
                        ++rCnt;
                        break;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        --rCnt;
                    }
                }
            }
            if (++x < doc.lineAt(y).size()) continue;
            ++y;
            x = 0;
        }
        y = Math.min(doc.size() - 1, y);
        doc.moveCursorAbs(xl, yu);
        doc.setSelection(xl, yu, x, y);
        return false;
    }
}

