/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.PartialBuffer;
import com.stevesoft.pat.RBuffer;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.Replacer;
import com.stevesoft.pat.StringBufferLike;
import com.stevesoft.pat.Transformer;
import com.stevesoft.pat.wrap.StringBufferWrap;
import java.io.IOException;
import java.io.Reader;

public class RegexReader
extends Reader {
    RBuffer rb = new RBuffer(new StringBuffer());
    PartialBuffer wrap;
    boolean moreToRead;
    Reader r;
    Replacer rp;
    int nmax;
    int max_lines;
    char EOLchar;

    public RegexReader(Regex rex, Reader r) {
        this.wrap = new PartialBuffer(this.rb.sb);
        this.moreToRead = true;
        this.nmax = 2048;
        this.max_lines = 2;
        this.EOLchar = (char)10;
        this.r = r;
        this.rp = rex.getReplacer();
    }

    public RegexReader(Transformer tex, Reader r) {
        this.wrap = new PartialBuffer(this.rb.sb);
        this.moreToRead = true;
        this.nmax = 2048;
        this.max_lines = 2;
        this.EOLchar = (char)10;
        this.r = r;
        this.rp = tex.getReplacer();
    }

    public void reset() throws IOException {
        this.r.reset();
        this.rb = new RBuffer(new StringBuffer());
        this.wrap = new PartialBuffer(this.rb.sb);
        this.moreToRead = true;
    }

    /*
     * WARNING - void declaration
     */
    void readData() throws IOException {
        int c;
        int n = 0;
        while ((c = this.r.read()) != -1) {
            void var1_2;
            this.rb.sb.append((char)var1_2);
            if (n++ > this.nmax) break;
        }
        if (c == -1 && n == 0) {
            this.moreToRead = false;
            this.wrap.allowOverRun = false;
        }
    }

    void getMoreData() throws IOException {
        while (this.rb.pos >= this.rb.epos) {
            this.wrap.overRun = false;
            if (this.rb.next != null) {
                this.rb = this.rb.next;
                continue;
            }
            if (this.rb.done) break;
            if (this.rb.epos >= this.rb.sb.length() && this.rb.epos > this.nmax) {
                this.rb.pos = 1;
                this.rb.epos = 1;
                this.rb.sb.setLength(1);
                this.readData();
                continue;
            }
            if (this.rb.epos >= this.rb.sb.length() && this.moreToRead) {
                this.readData();
                continue;
            }
            if (this.rp.getRegex().matchAt(this.wrap, this.rb.epos)) {
                if (this.wrap.overRun) {
                    this.readData();
                    continue;
                }
                StringBufferWrap sbw = new StringBufferWrap();
                StringBufferLike sbl = new StringBufferLike(sbw);
                Regex rex = this.rp.getRegex();
                int npos = rex.matchedTo();
                this.rp.setBuffer(sbl);
                this.rp.setSource(this.wrap);
                this.rp.setPos(npos);
                this.rp.apply(rex, rex.getReplaceRule());
                int opos = this.rb.epos;
                RBuffer rb2 = new RBuffer((StringBuffer)sbw.unwrap());
                rb2.epos = rb2.sb.length();
                RBuffer rb3 = new RBuffer(this.rb.sb);
                this.rb.next = rb2;
                rb2.next = rb3;
                if (npos == opos) {
                    rb3.epos = npos + 1;
                    if (rb3.epos > rb3.sb.length()) {
                        if (this.rb.pos >= this.rb.epos) {
                            this.rb = this.rb.next;
                        }
                        rb3.epos = 0;
                        rb3.pos = 0;
                        rb3.done = true;
                    }
                    rb3.pos = npos;
                    continue;
                }
                rb3.pos = rb3.epos = npos;
                continue;
            }
            if (this.wrap.overRun) {
                this.readData();
                continue;
            }
            if (this.rb.epos >= this.rb.sb.length()) break;
            ++this.rb.epos;
        }
    }

    public int read() throws IOException {
        if (this.rb.pos >= this.rb.epos) {
            this.getMoreData();
            if (this.rb.pos >= this.rb.epos) {
                return -1;
            }
        }
        return this.rb.sb.charAt(this.rb.pos++);
    }

    public int read(char[] buf, int off, int len) throws IOException {
        int c = -1;
        int end = off + len;
        int i = off;
        while (i < end) {
            c = this.read();
            if (c < 0) {
                return i - off;
            }
            buf[i] = (char)c;
            ++i;
        }
        return len;
    }

    public void close() throws IOException {
        this.r.close();
    }

    public boolean markSupported() {
        return false;
    }

    public int getBufferSize() {
        return this.nmax;
    }

    public void setBufferSize(int n) {
        this.nmax = n;
    }

    public int getMaxLines() {
        return this.max_lines;
    }

    public void setMaxLines(int ml) {
        this.max_lines = ml;
    }

    public char getEOLchar() {
        return this.EOLchar;
    }

    public void setEOLchar(char c) {
        this.EOLchar = c;
    }

    public long skip(long d) throws IOException {
        long n = 0L;
        while (n < d && this.read() != -1) {
            ++n;
        }
        return n;
    }
}

