/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat.apps;

import com.stevesoft.pat.apps.ColorLine;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class ColorText
extends Canvas {
    Vector v = new Vector();
    static final int x_margin = 10;
    static final int y_margin = 10;

    public Object clone() {
        ColorText ct = new ColorText();
        ct.v = (Vector)this.v.clone();
        return ct;
    }

    public ColorText() {
        this.setBackground(Color.white);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColorLine(ColorLine ln) {
        ColorText colorText = this;
        synchronized (colorText) {
            this.v.addElement(ln);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ColorText colorText = this;
        synchronized (colorText) {
            this.v = new Vector();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        ColorText colorText = this;
        synchronized (colorText) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (fm == null) {
                return;
            }
            Rectangle r = g.getClipRect();
            int ymin = r.y;
            int ymax = r.y + r.height;
            int imax = (ymax - 10 - fm.getAscent()) / fm.getHeight() + 2;
            int imin = (ymin - 10 - fm.getAscent()) / fm.getHeight() - 2;
            if (imin < 0) {
                imin = 0;
            }
            if (imax > this.v.size()) {
                imax = this.v.size();
            }
            int i = imin;
            while (i < imax) {
                this.drawColorLine(g, fm, (ColorLine)this.v.elementAt(i), i);
                ++i;
            }
            g.setColor(Color.lightGray);
            g.drawRect(1, 1, this.size().width - 2, this.size().height - 2);
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm == null) {
            return new Dimension(0, 0);
        }
        int xs = 0;
        int ys = 0;
        int i = 0;
        while (i < this.v.size()) {
            ColorLine cl = (ColorLine)this.v.elementAt(i);
            Dimension d = cl.getSize(fm);
            ys += d.height;
            xs = xs > d.width ? xs : d.width;
            ++i;
        }
        Dimension d = new Dimension(xs, ys += fm.getAscent());
        return d;
    }

    final void drawColorLine(Graphics g, FontMetrics fm, ColorLine ln, int yi) {
        int x = 10;
        int y = fm.getAscent() + yi * fm.getHeight() + 10;
        int i = 0;
        while (i < ln.v.size()) {
            Object o = ln.v.elementAt(i);
            if (o instanceof Color) {
                g.setColor((Color)o);
            } else {
                g.drawString((String)o, x, y);
                x += fm.stringWidth((String)o);
            }
            ++i;
        }
    }
}

