/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat.apps;

import com.stevesoft.pat.RegSyntax;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.apps.ColorLine;
import com.stevesoft.pat.apps.ColorText;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class TestGroup
extends Panel {
    Label lab;
    static final Color darkgreen = new Color(0, 119, 0);
    static final Color darkblue = new Color(0, 0, 119);
    static final Color darkred = new Color(119, 0, 0);
    public TextField txt;
    public ColorText ctxt;

    public void repaint() {
        this.ctxt.repaint();
    }

    public Object clone() {
        TestGroup t = new TestGroup(this.lab.getText(), this.txt.isEditable());
        t.txt = new TextField();
        t.txt.setText(this.txt.getText());
        t.ctxt = (ColorText)this.ctxt.clone();
        return t;
    }

    public TestGroup(String s, boolean b) {
        this.lab = new Label(s);
        this.lab.setAlignment(0);
        this.txt = new TextField();
        this.txt.setEditable(b);
        this.ctxt = new ColorText();
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gb.setConstraints(this.lab, gc);
        gc.weightx = 1.0;
        gc.gridx = 1;
        gb.setConstraints(this.txt, gc);
        gc.fill = 1;
        gc.weighty = 1.0;
        gc.gridwidth = 2;
        gc.gridx = 0;
        gc.gridy = 1;
        gb.setConstraints(this.ctxt, gc);
        this.add(this.lab);
        this.add(this.txt);
        this.add(this.ctxt);
    }

    public void ShowRes(Regex r) {
        this.ctxt.clear();
        if (r.didMatch()) {
            this.ShowSuccess(r);
        } else {
            this.ShowFail();
        }
    }

    public void ShowFail() {
        ColorLine ln = new ColorLine();
        ln.add(darkred, "Match failed!");
        this.ctxt.addColorLine(ln);
        this.ctxt.repaint();
    }

    public void ShowError(RegSyntax rs) {
        ColorLine ln = new ColorLine();
        ln.add(darkred, "RegSyntax: " + rs.getMessage());
        this.ctxt.addColorLine(ln);
        this.ctxt.repaint();
    }

    public void ShowSuccess(Regex r) {
        ColorLine ln = new ColorLine();
        ln.add(darkgreen, "==>");
        ln.add(Color.black, r.left());
        ln.add(darkgreen, "|");
        ln.add(darkred, r.substring());
        ln.add(darkgreen, "|");
        ln.add(Color.black, r.right());
        ln.add(darkgreen, "<==");
        this.ctxt.addColorLine(ln);
        this.ctxt.addColorLine(new ColorLine());
        if (r.numSubs() > 0) {
            ln = new ColorLine();
            ln.add(darkblue, "Backreferences:");
            this.ctxt.addColorLine(ln);
        }
        int i = 1;
        while (i <= r.numSubs()) {
            ln = new ColorLine();
            ln.add(darkblue, "(" + i + ") : ");
            if (r.left(i) == null) {
                ln.add(darkblue, "[null]");
            } else {
                ln.add(Color.black, r.left(i));
                ln.add(darkgreen, "|");
                ln.add(darkred, r.substring(i));
                ln.add(darkgreen, "|");
                ln.add(Color.black, r.right(i));
            }
            this.ctxt.addColorLine(ln);
            ++i;
        }
        this.ctxt.repaint();
    }
}

