/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import de.netcomputing.anyj.AJBookmarksGUI;
import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.IntValue;
import de.netcomputing.anyj.jwidgets.KeyFilter;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.EditApp;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import jxeplugins.DocumentPosition;
import plugins.bookmarks.BookmarkItem;

public class AJBookmarks
extends NCPanel {
    NCButton pasteBtn;
    NCButton copyBtn;
    NCButton downBtn;
    NCButton upBtn;
    NCButton rigthBtn;
    NCButton leftBtn;
    NCButton remBtn;
    NCButton newFolderBtn;
    NCButton addBtn;
    NCTreeBean lp;
    static AJBookmarks This;
    BookmarkItem clipboard;

    public static AJBookmarks This() {
        return This;
    }

    public AJBookmarks() {
        This = this;
        this.initGui();
    }

    public void requestFocus() {
        this.lp.requestFocus();
    }

    public Vector getBookmarks() {
        return this.lp.getList();
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName.toLowerCase());
    }

    public NCTreeBean getLp() {
        return this.lp;
    }

    public void storeBookmarks(DataOutputStream out) throws IOException {
        this.lp.expandAll();
        out.writeInt(this.lp.listSize());
        int n = 0;
        while (n < this.lp.listSize()) {
            BookmarkItem bi = (BookmarkItem)this.lp.at(n);
            out.writeUTF(bi.name);
            out.writeInt(bi.posX);
            out.writeInt(bi.posY);
            out.writeInt(bi.getDepth());
            String fi = bi.file == null ? "_NULL_" : bi.file.getAbsolutePath();
            out.writeUTF(fi);
            ++n;
        }
    }

    public void readBookmarks(DataInputStream in) throws IOException {
        this.lp.clear();
        int len = in.readInt();
        int n = 0;
        while (n < len) {
            String name = in.readUTF();
            int x = in.readInt();
            int y = in.readInt();
            int depth = in.readInt();
            String fi = in.readUTF();
            File file2 = null;
            file2 = fi.equals("_NULL_") ? null : new File(fi);
            BookmarkItem bi = new BookmarkItem(name, x, y, file2);
            bi.setDepth(depth);
            this.lp.addItem(bi);
            ++n;
        }
    }

    void copy(int index) {
        BookmarkItem bi = (BookmarkItem)this.lp.at(index);
        int selDepth = bi.getDepth();
        if (this.lp.isContentVisible(index)) {
            bi.readContentFromListBox(index + 1, this.lp, selDepth);
        }
        this.clipboard = ((BookmarkItem)this.lp.at(index)).deepCopy();
    }

    public void copyBtn_actionPerformed(ActionEvent var0) {
        if (this.lp.getSelectionIndex() >= 0) {
            this.copy(this.lp.getSelectionIndex());
        }
    }

    public void pasteBtn_actionPerformed(ActionEvent var0) {
        int index = this.lp.getSelectionIndex();
        BookmarkItem toInsert = this.clipboard.deepCopy();
        if (index >= 0) {
            toInsert.setDepth(this.lp.at(index).getDepth());
        } else {
            index = this.lp.listSize();
        }
        this.lp.insertItemRepaintingAt(index, toInsert);
    }

    public Object actionSelChanged(Object arg, Object sen) {
        int index = this.lp.getSelectionIndex();
        if (index < 0 || index >= this.lp.listSize()) {
            return null;
        }
        int selDepth = this.lp.at(index).getDepth();
        if (this.lp.isContentVisible(index) && ((BookmarkItem)this.lp.at(index)).getFile() == null) {
            ((BookmarkItem)this.lp.at(index)).readContentFromListBox(index + 1, this.lp, selDepth);
        }
        this.validateState();
        return null;
    }

    public Object actionPreExpand(Object arg, Object sen) {
        int index;
        if (arg instanceof IntValue && (index = ((IntValue)arg).intValue()) >= 0) {
            BookmarkItem bi = (BookmarkItem)this.lp.at(index);
            int selDepth = bi.getDepth();
            if (this.lp.isContentVisible(index)) {
                bi.readContentFromListBox(index + 1, this.lp, selDepth);
            }
        }
        return null;
    }

    public Object actionDClick(Object arg, Object sen) {
        BookmarkItem bm = (BookmarkItem)this.lp.getSelectedItem();
        if (bm != null && bm.getFile() != null) {
            if (bm.posX == 0 && bm.posY == 0) {
                EditApp.App.openEditorOrShow(bm.file.getAbsolutePath());
            } else {
                EditApp.App.openEditorOrShow(new DocumentPosition(bm.file.getAbsolutePath(), bm.posY, bm.posX, -1));
            }
        }
        return null;
    }

    public void initGui() {
        new AJBookmarksGUI().createGui(this);
        this.validateState();
        this.lp.setPopUpGetter(EditApp.ServReg);
        this.lp.binder().addTarget(this, "actionSelChanged");
        this.lp.binderDoubleClick().addTarget(this, "actionDClick");
        this.lp.binderDoubleClick().addTarget(this, "actionPreExpand");
        this.lp.binderCornerClick().addTarget(this, "actionPreExpand");
        this.lp.addKeyListener(new KeyFilter(37, this, "actionKeyLeft", true, true));
        this.lp.addKeyListener(new KeyFilter(39, this, "actionKeyRight", true, true));
        this.lp.addKeyListener(new KeyFilter(38, this, "actionKeyUp", true, true));
        this.lp.addKeyListener(new KeyFilter(40, this, "actionKeyDown", true, true));
        this.lp.addKeyListener(new KeyFilter(88, this, "actionCut", true, true));
        this.lp.addKeyListener(new KeyFilter(127, this, "actionCut"));
        this.lp.addKeyListener(new KeyFilter(155, this, "actionInsert", true, true));
        this.lp.addKeyListener(new KeyFilter(67, this, "actionCopy", true, true));
        this.lp.addKeyListener(new KeyFilter(86, this, "actionPaste", true, true));
        this.lp.addKeyListener(new KeyFilter(10, this, "actionOpen", true, true));
    }

    public Object actionOpen(Object arg, Object sen) {
        this.actionDClick(arg, sen);
        return null;
    }

    public Object actionPaste(Object arg, Object sen) {
        KeyEvent e = (KeyEvent)arg;
        if (e.isControlDown()) {
            this.pasteBtn_actionPerformed(null);
        }
        return null;
    }

    public Object actionCopy(Object arg, Object sen) {
        KeyEvent e = (KeyEvent)arg;
        if (e.isControlDown()) {
            this.copyBtn_actionPerformed(null);
        } else if (e.isShiftDown()) {
            this.pasteBtn_actionPerformed(null);
        }
        return null;
    }

    public Object actionInsert(Object arg, Object sen) {
        KeyEvent e = (KeyEvent)arg;
        if (!e.isControlDown()) {
            this.addBtn_actionPerformed(null);
        } else {
            this.copyBtn_actionPerformed(null);
        }
        return null;
    }

    public Object actionCut(Object arg, Object sen) {
        KeyEvent e = (KeyEvent)arg;
        if (e.isControlDown() || e.getKeyCode() == 127) {
            this.remBtn_actionPerformed(null);
        }
        return null;
    }

    public Object actionKeyLeft(Object arg, Object sen) {
        KeyEvent e = (KeyEvent)arg;
        if (e.isShiftDown()) {
            this.leftBtn_actionPerformed(null);
        }
        return null;
    }

    public Object actionKeyRight(Object arg, Object sen) {
        KeyEvent e = (KeyEvent)arg;
        if (e.isShiftDown()) {
            this.rigthBtn_actionPerformed(null);
        }
        return null;
    }

    public Object actionKeyUp(Object arg, Object sen) {
        KeyEvent e = (KeyEvent)arg;
        if (e.isShiftDown()) {
            this.upBtn_actionPerformed(null);
        }
        return null;
    }

    public Object actionKeyDown(Object arg, Object sen) {
        KeyEvent e = (KeyEvent)arg;
        if (e.isShiftDown()) {
            this.downBtn_actionPerformed(null);
        }
        return null;
    }

    public void validateState() {
        int idx = this.lp.getSelectionIndex();
        if (idx < 0 || idx >= this.lp.listSize()) {
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
            this.leftBtn.setEnabled(false);
            this.rigthBtn.setEnabled(false);
            this.remBtn.setEnabled(false);
            this.copyBtn.setEnabled(false);
            this.pasteBtn.setEnabled(false);
            return;
        }
        this.remBtn.setEnabled(true);
        this.copyBtn.setEnabled(true);
        this.pasteBtn.setEnabled(true);
        this.upBtn.setEnabled(idx > 0);
        this.downBtn.setEnabled(idx < this.lp.listSize() - 1);
        this.leftBtn.setEnabled(idx == this.lp.listSize() - 1 && this.lp.at(idx).getDepth() > 0 || idx < this.lp.listSize() - 1 && this.lp.at(idx + 1).getDepth() < this.lp.at(idx).getDepth());
        this.rigthBtn.setEnabled(idx > 0 && (this.lp.at(idx - 1).getDepth() > this.lp.at(idx).getDepth() || this.lp.at(idx - 1).getDepth() == this.lp.at(idx).getDepth() && ((BookmarkItem)this.lp.at(idx - 1)).isDir()));
    }

    public void downBtn_actionPerformed(ActionEvent var0) {
        int index = this.lp.getSelectionIndex();
        int len = this.lp.computeChildren(index);
        this.clearParentContent(this.lp.getSelectionIndex());
        BookmarkItem bm = (BookmarkItem)this.lp.getSelectedItem();
        int targetIndex = index;
        if (index < this.lp.listSize() - 1) {
            IListItem it = this.lp.at(index + len);
            int depthDiff = bm.getDepth() - it.getDepth();
            if (this.lp.isContentVisible(index + len)) {
                --depthDiff;
            }
            int n = index;
            while (n < index + len) {
                this.lp.at(n).setDepth(this.lp.at(n).getDepth() - depthDiff);
                ++n;
            }
            this.lp.removeAt(index + len);
            this.lp.insertItemAt(index, it);
            this.lp.setSelectionIndex(index + 1);
            this.lp.repaintStartingAt(index, len + 1);
        }
        this.validateState();
    }

    public void upBtn_actionPerformed(ActionEvent var0) {
        int index = this.lp.getSelectionIndex();
        int len = this.lp.computeChildren(index);
        this.clearParentContent(this.lp.getSelectionIndex());
        BookmarkItem bm = (BookmarkItem)this.lp.getSelectedItem();
        if (index > 0) {
            IListItem it = this.lp.at(index - 1);
            int itDepth = it.getDepth();
            int depthDiff = bm.getDepth() - itDepth;
            int n = index;
            while (n < index + len) {
                this.lp.at(n).setDepth(this.lp.at(n).getDepth() - depthDiff);
                ++n;
            }
            this.lp.removeAt(index - 1);
            this.lp.insertItemAt(index + len - 1, it);
            this.lp.setSelectionIndex(index - 1);
            this.lp.repaintStartingAt(index - 1, len + 1);
        }
        this.validateState();
    }

    void clearParentContent(int index) {
        BookmarkItem bi;
        if (index >= 0 && index < this.lp.listSize() && (bi = (BookmarkItem)this.lp.findParentObject(this.lp.getSelectionIndex(), this.lp.getSelectedItem().getDepth())) != null) {
            bi.clearContent();
        }
    }

    public void rigthBtn_actionPerformed(ActionEvent var0) {
        int index = this.lp.getSelectionIndex();
        if (index > 0 && (this.lp.at(index - 1).getDepth() > this.lp.at(index).getDepth() || this.lp.at(index - 1).getDepth() == this.lp.at(index).getDepth() && ((BookmarkItem)this.lp.at(index - 1)).isDir())) {
            if (((BookmarkItem)this.lp.at(index - 1)).hasContent() && this.lp.at(index - 1).getDepth() == this.lp.at(index).getDepth()) {
                IListItem item = this.lp.getSelectedItem();
                this.lp.expandNodeAt(index - 1);
                this.lp.setSelectionIndex(this.lp.getList().indexOf(item, index));
                this.lp.repaint();
                return;
            }
            int len = this.lp.computeChildren(index);
            if (index >= 0) {
                int n = index;
                while (n < index + len) {
                    this.lp.at(n).setDepth(this.lp.at(n).getDepth() + 1);
                    ++n;
                }
                this.lp.repaint();
            }
            this.clearParentContent(this.lp.getSelectionIndex());
        }
        this.validateState();
    }

    public void leftBtn_actionPerformed(ActionEvent var0) {
        int index = this.lp.getSelectionIndex();
        if (index < 0) {
            return;
        }
        if (index == this.lp.listSize() - 1 || index < this.lp.listSize() - 1 && this.lp.at(index + 1).getDepth() < this.lp.at(index).getDepth()) {
            this.clearParentContent(index);
            int len = this.lp.computeChildren(index);
            if (index >= 0 && this.lp.at(index).getDepth() > 0) {
                int n = index;
                while (n < index + len) {
                    this.lp.at(n).setDepth(this.lp.at(n).getDepth() - 1);
                    ++n;
                }
                this.lp.repaint();
            }
        }
        this.validateState();
    }

    public void remBtn_actionPerformed(ActionEvent var0) {
        int index = this.lp.getSelectionIndex();
        if (index >= 0) {
            this.clearParentContent(this.lp.getSelectionIndex());
            int len = this.lp.computeChildren(index);
            int n = index;
            while (n < index + len) {
                this.lp.removeAt(index);
                ++n;
            }
            this.clearParentContent(this.lp.getSelectionIndex());
            this.lp.repaint();
            this.validateState();
        }
    }

    public void newFolderBtn_actionPerformed(ActionEvent var0) {
        this.addItem(null, 0, 0);
        this.validateState();
    }

    public void addItem(File f, int x, int y) {
        String nam = Confirm.GetText((Window)this.getTopLevelAncestor(), null, "Enter a Name or description", new String[]{}, f == null ? "" : f.getName());
        if (nam == null) {
            return;
        }
        this.addItemQuiet(nam, f, x, y);
    }

    public void addItemQuiet(String nam, File f, int x, int y) {
        int index = this.lp.getSelectionIndex();
        if (f == null) {
            BookmarkItem bi = new BookmarkItem(nam, x, y, f);
            if (index > 0 && index < this.lp.listSize()) {
                bi.setDepth(this.lp.at(index).getDepth());
            }
            if (index < 0 || index >= this.lp.listSize()) {
                this.lp.addItemRepainting(bi);
            } else {
                this.lp.insertItemRepaintingAt(index, bi);
            }
        } else if (f.isDirectory()) {
            String[] files;
            BookmarkItem bi = new BookmarkItem(nam, 0, 0, null);
            if (index > 0 && index < this.lp.listSize()) {
                bi.setDepth(this.lp.at(index).getDepth());
            }
            if ((files = f.list()) != null) {
                Vector<BookmarkItem> v = new Vector<BookmarkItem>(files.length);
                int n = 0;
                while (n < files.length) {
                    File toAdd = new File(f, files[n]);
                    if (!toAdd.isDirectory()) {
                        v.addElement(new BookmarkItem(files[n], 0, 0, toAdd));
                    }
                    ++n;
                }
                bi.setContentVector(v);
            }
            if (index < 0 || index >= this.lp.listSize()) {
                this.lp.addItemRepainting(bi);
                this.lp.expandNodeAt(this.lp.listSize() - 1);
            } else {
                this.lp.insertItemRepaintingAt(index, bi);
                this.lp.expandNodeAt(index);
            }
            this.lp.repaint();
        } else {
            BookmarkItem bi = new BookmarkItem(nam, x, y, f);
            if (index > 0 && index < this.lp.listSize()) {
                bi.setDepth(this.lp.at(index).getDepth());
            }
            if (index < 0 || index >= this.lp.listSize()) {
                this.lp.addItemRepainting(bi);
            } else {
                this.lp.insertItemRepaintingAt(index, bi);
            }
        }
        this.validateState();
    }

    public void addBtn_actionPerformed(ActionEvent var0) {
        File f;
        BookmarkItem item = (BookmarkItem)this.lp.getSelectedItem();
        String pre = null;
        if (item != null && item.getFile() != null) {
            pre = item.getFile().getAbsolutePath();
        }
        if ((f = AJDirSelector.SelectDirModal((JFrame)this.getTopLevelAncestor(), null, "Dir or File", null, pre)) != null) {
            this.addItem(f, 0, 0);
        }
    }

    public static void main(String[] args) {
        JFrame f = ApplicationHelper.Singleton().createFrameOn(new AJBookmarks());
        f.show();
    }
}

