/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JCollections.ISortFunc;
import JCollections.JArray;
import de.netcomputing.anyj.AJClassViewGUI;
import de.netcomputing.anyj.jwidgets.JListPanel;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.BasicBrowserNode;
import editapp.ClassNode;
import editapp.EditApp;
import editapp.FieldNode;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AJClassView
extends NCPanel {
    JLabel classLabel;
    NCTreeBean methodsList;
    NCTreeBean classList;
    JSplitPane splitPane;
    IndexEntry currClazz;
    JCheckBox sortChk;
    File curFile;
    JTextField searchFilter;
    Pattern filterPattern = Pattern.compile(".*");
    Color bg;
    IndexEntry lastSelectedMethod;

    public AJClassView() {
        this.initGui();
    }

    public NCTreeBean getMethodsList() {
        return this.methodsList;
    }

    public void initGui() {
        new AJClassViewGUI().createGui(this);
        this.remove(this.classList);
        JPanel jp = new JPanel(new BorderLayout());
        JPanel tmp = new JPanel(new BorderLayout(3, 1));
        this.sortChk = new JCheckBox("sort");
        this.searchFilter = new JTextField();
        tmp.add("Center", this.searchFilter);
        tmp.add("East", this.sortChk);
        jp.add("North", tmp);
        jp.add("Center", this.methodsList);
        this.remove(this.methodsList);
        this.searchFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                AJClassView.this.updateFilter();
            }

            public void removeUpdate(DocumentEvent e) {
                AJClassView.this.updateFilter();
            }

            public void changedUpdate(DocumentEvent e) {
                AJClassView.this.updateFilter();
            }
        });
        this.searchFilter.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    AJClassView.this.methodsList.binderDoubleClick().notifyTargets(AJClassView.this.methodsList.getSelectionIndex());
                    AJClassView.this.searchFilter.setText("");
                }
                if (ke.getKeyCode() == 27) {
                    AJClassView.this.searchFilter.setText("");
                }
                if (ke.getKeyCode() == 40) {
                    AJClassView.this.methodsList.actionDown(null, null);
                }
                if (ke.getKeyCode() == 38) {
                    AJClassView.this.methodsList.actionUp(null, null);
                }
            }
        });
        EditApp.AdjustSplitPane(this.splitPane);
        this.splitPane.setTopComponent(this.classList);
        this.splitPane.setBottomComponent(jp);
        this.splitPane.setDividerLocation(150);
        this.classList.binder().addTarget(this, "actionClassListSel");
        this.methodsList.binder().addTarget(this, "actionMethodSel");
        this.classList.listCanvas().indent = 2;
        this.methodsList.listCanvas().indent = 2;
        this.classList.binderDoubleClick().addTarget(this, "actionClassDClick");
        this.classList.setPopUpGetter(EditApp.ServReg);
        this.methodsList.setPopUpGetter(EditApp.ServReg);
        this.sortChk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AJClassView.this.updateFilter();
            }
        });
        this.updateFilter();
    }

    void updateFilter() {
        if (this.bg == null) {
            this.bg = Color.white;
        }
        try {
            String s = NCStringUtilities.PrepareRegExp(this.searchFilter.getText());
            this.filterPattern = Pattern.compile(s, 2);
            this.searchFilter.setToolTipText("<html>Use * as wildcard.<br>Current regexp:" + s + "<br>Shortcuts [Alt-2,Up,Down,Enter,Esc]");
            this.actionClassListSel(null, null);
            if (this.methodsList.listSize() > 0) {
                this.methodsList.setSelectionIndex(0);
            } else {
                this.methodsList.setSelectionIndex(-1);
            }
            this.searchFilter.setBackground(this.bg);
        }
        catch (Exception ex) {
            this.searchFilter.setBackground(Color.red);
        }
    }

    public JLabel getLabel() {
        return this.classLabel;
    }

    public JListPanel getMethodList() {
        return this.methodsList;
    }

    public JTextField getSearchFilter() {
        return this.searchFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClazzToShow(File f) {
        block9: {
            block8: {
                block7: {
                    try {
                        try {
                            this.classList.setIgnoreRepaint(true);
                            this.methodsList.setIgnoreRepaint(true);
                            if (!f.getAbsolutePath().endsWith(".java")) {
                                this.classList.clear();
                                this.methodsList.clear();
                                Object var5_2 = null;
                                break block7;
                            }
                            String clazzName = f.getName().substring(0, f.getName().length() - ".java".length());
                            IndexEntry ie = SourceBase.This().getPossibleClassDefFor(clazzName, f.getAbsolutePath());
                            if (ie == null) {
                                this.classList.clear();
                                this.methodsList.clear();
                                break block8;
                            }
                            this.curFile = f;
                            this.setClazzToShow(ie);
                            break block9;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace(Tracer.This);
                            Object var5_5 = null;
                            this.classList.setIgnoreRepaint(false);
                            this.methodsList.setIgnoreRepaint(false);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        this.classList.setIgnoreRepaint(false);
                        this.methodsList.setIgnoreRepaint(false);
                        throw throwable;
                    }
                }
                this.classList.setIgnoreRepaint(false);
                this.methodsList.setIgnoreRepaint(false);
                return;
            }
            Object var5_3 = null;
            this.classList.setIgnoreRepaint(false);
            this.methodsList.setIgnoreRepaint(false);
            return;
        }
        Object var5_4 = null;
        this.classList.setIgnoreRepaint(false);
        this.methodsList.setIgnoreRepaint(false);
    }

    public void showAll(IndexEntry ie) {
        if (this.curFile == null) {
            this.curFile = new File(ie.fileString());
        }
        this.setClazzToShow(ie, true);
    }

    public void setClazzToShow(IndexEntry ie) {
        try {
            this.setClazzToShow(ie, false);
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public void refresh() {
        try {
            this.actionClassListSel(null, null);
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public void setClazzToShow(IndexEntry ie, boolean allFields) {
        if (ie == null) {
            this.currClazz = null;
            this.classList.clear();
            this.methodsList.clear();
            return;
        }
        int i = this.classList.indexOfByString(ie.getDisplayString());
        if (i >= 0) {
            if (i == this.classList.getSelectionIndex()) {
                return;
            }
            this.classList.setSelectionIndex(i);
            this.actionClassListSel(null, null);
            return;
        }
        ArrayList arli = SourceBase.This().deriveLineAndInterfacesFor(ie);
        if (arli == null) {
            return;
        }
        this.currClazz = ie;
        this.classList.clear();
        this.methodsList.clear();
        this.classList.addLine("All Fields");
        boolean isClassSelected = false;
        int n = 0;
        while (n < arli.size()) {
            ClassNode tmp = new ClassNode((IndexEntry)arli.get(n));
            if (n == 0 && !tmp.getEntry().isInterface()) {
                isClassSelected = true;
            }
            this.classList.addItem(tmp);
            if (isClassSelected && tmp.getEntry().isInterface()) {
                tmp.setDepth(8);
            } else {
                tmp.setDepth(0);
            }
            ++n;
        }
        if (allFields) {
            this.classList.setSelectionIndex(0);
        } else {
            this.classList.setSelectionIndex(1);
        }
        this.classList.repaint();
        this.actionClassListSel(null, null);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public Object actionMethodSel(Object arg, Object sen) {
        this.lastSelectedMethod = ((BasicBrowserNode)this.methodsList.getSelectedObject()).getEntry();
        return null;
    }

    public Object actionClassDClick(Object arg, Object sen) {
        BasicBrowserNode it = (BasicBrowserNode)this.classList.getSelectedItem();
        if (it == null) {
            return null;
        }
        IndexEntry ie = it.getEntry();
        if (this.classList.getSelectionIndex() > 0 && this.methodsList.getSelectedItem() != null) {
            FieldNode fi = (FieldNode)this.methodsList.getSelectedItem();
            ie = fi.getEntry();
            EditApp.App.openOrShow(ie);
        } else {
            EditApp.App.openEditorOrShow(ie.getFileString());
        }
        return null;
    }

    public Object actionClassListSel(Object arg, Object sen) {
        this.methodsList.clear();
        if (this.currClazz == null) {
            return null;
        }
        this.classLabel.setText(this.currClazz.realPackage() + "." + this.currClazz.realClassName());
        if ("All Fields".equals(this.classList.getSelectedString())) {
            JArray arr = SourceBase.This().allMethodsAndFieldsOf(this.currClazz.realClassName(), this.currClazz.fileString(), EditApp.App.jol.getModifierFilter());
            if (arr != null) {
                this.methodsList.clear();
                int n = 0;
                while (n < arr.size()) {
                    if (this.filterPattern.matcher(((IndexEntry)arr.at(n)).getName()).matches()) {
                        FieldNode node = new FieldNode((IndexEntry)arr.at(n));
                        this.methodsList.addItem(node);
                        node.setDepth(0);
                    }
                    ++n;
                }
                this.methodsList.repaint();
            }
        } else {
            BasicBrowserNode it = (BasicBrowserNode)this.classList.getSelectedItem();
            if (it != null) {
                IndexEntry ie = it.getEntry();
                JArray arr = SourceBase.This().definitionsInFile(ie.getFileString());
                if (!this.sortChk.isSelected()) {
                    arr.sortBy(new ISortFunc(){

                        public boolean isGreaterOrEqual(Object a, Object b) {
                            return ((IndexEntry)a).getDocumentLine() >= ((IndexEntry)b).getDocumentLine();
                        }
                    });
                } else {
                    arr.sort();
                }
                Vector v = SourceBase.This().applyMethodFilter(ie.realClassName(), arr, EditApp.App.jol.getModifierFilter(), true);
                int selidx = -1;
                int n = 0;
                while (n < v.size()) {
                    if (this.lastSelectedMethod != null && this.lastSelectedMethod.isSameProto((IndexEntry)v.elementAt(n))) {
                        selidx = n;
                    }
                    if (this.filterPattern.matcher(((IndexEntry)v.get(n)).getName()).matches()) {
                        FieldNode node = new FieldNode((IndexEntry)v.get(n));
                        node.setDepth(0);
                        this.methodsList.addItem(node);
                    }
                    ++n;
                }
                if (selidx >= 0) {
                    this.methodsList.setSelectionIndex(selidx);
                }
                this.methodsList.repaint();
            }
        }
        return null;
    }
}

