/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import de.netcomputing.anyj.AJHierarchyAnalysisGUI;
import de.netcomputing.anyj.jwidgets.IValue;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCCheckBox;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTable;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.ClassTableModel;
import editapp.EditApp;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class AJHierarchyAnalysis
extends NCPanel {
    NCButton cancelBtn;
    JLabel classLabel;
    NCCheckBox privateChk;
    NCCheckBox methodsChk;
    NCCheckBox fieldsChk;
    NCTable tableView;
    IndexEntry ieMain;
    ClassTableModel tableModel;
    public static boolean IsOpen;

    public static void Open(IndexEntry ie) {
        JDialog dlg = new JDialog(EditApp.App.getMainWindow(), "Hierarchy Analyzer", false);
        AJHierarchyAnalysis ajem = new AJHierarchyAnalysis();
        dlg.getContentPane().add(ajem);
        dlg.pack();
        dlg.setSize(640, 400);
        ApplicationHelper.Singleton().centerWindow(dlg);
        ajem.init(ie);
        ajem.getRootPane().setDefaultButton(ajem.cancelBtn);
        dlg.setVisible(true);
        IsOpen = true;
        dlg.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent ev) {
                IsOpen = false;
            }
        });
    }

    public AJHierarchyAnalysis() {
        this.initGui();
    }

    public void initGui() {
        new AJHierarchyAnalysisGUI().createGui(this);
        this.tableView.setFlags(NCTable.COLSIZEABLE | NCTable.ROWSELECTABLE);
        this.tableView.binderDoubleCellSelection().addTarget(this, "actionDoubleClick");
    }

    public Object actionDoubleClick(Object arg, Object sen) {
        Point p = (Point)((IValue)arg).value();
        IndexEntry ie = this.tableModel.getIEAt(p.x, p.y);
        if (ie != null) {
            EditApp.App.openOrShow(ie);
        }
        return null;
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void init(IndexEntry clazz) {
        this.ieMain = clazz;
        this.classLabel.setText("Class " + this.ieMain.getPackageName() + "." + this.ieMain.getName());
        this.fillTable();
    }

    public void filterChanged() {
        this.fillTable();
    }

    int getFilter() {
        return (this.privateChk.isPressed() ? 0 : 2) | (this.methodsChk.isPressed() ? 0 : 1024) | (this.fieldsChk.isPressed() ? 0 : 2048) | 0x80;
    }

    void fillTable() {
        SourceBase sb = SourceBase.This();
        IndexEntry[] line = sb.deriveLineFor(this.ieMain);
        this.tableView.clearRowSelections();
        try {
            this.cursorWait();
            boolean mustUpdate = false;
            int n = 0;
            while (n < line.length) {
                if (SourceBase.This().shouldUpdate(new File(line[n].fileString()))) {
                    mustUpdate = true;
                    break;
                }
                ++n;
            }
            if (mustUpdate) {
                int n2 = 0;
                while (n2 < line.length) {
                    SourceBase.This().update(line[n2].fileString());
                    ++n2;
                }
            }
            int filter = this.getFilter();
            this.tableModel = new ClassTableModel(this.ieMain.getFileString(), this.ieMain.getName(), this.getFilter());
            this.tableView.setModel(this.tableModel);
            this.tableView.fitColumnsToView(300);
            this.tableView.setHeaderMinWidth(150);
            this.tableView.repaint();
            this.cursorDefault();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cursorDefault();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AJHierarchyAnalysis.this.tableView.repaint();
            }
        });
    }

    public void fieldsChk_stateChanged(ChangeEvent var0) {
        this.filterChanged();
    }

    public void methodsChk_stateChanged(ChangeEvent var0) {
        this.filterChanged();
    }

    public void privateChk_stateChanged(ChangeEvent var0) {
        this.filterChanged();
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        ((Window)this.getTopLevelAncestor()).dispose();
    }
}

