/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JCollections.JSortedArray;
import de.netcomputing.anyj.AJIndexViewerGUI;
import de.netcomputing.anyj.jwidgets.ISelectionProvider;
import de.netcomputing.anyj.jwidgets.IValue;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.beans.NCHistoryChoice;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.EditApp;
import editapp.IndexEntry;
import editapp.JDocPopupper;
import editapp.SourceBase;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JTextArea;

public class AJIndexViewer
extends NCPanel
implements ISelectionProvider {
    NCHistoryChoice searchFld;
    JTextArea declFld;
    NCButton implBtn;
    NCButton browseFileBtn;
    NCButton browseBtn;
    NCTreeBean listPanel;
    NCButton editBtn;
    JDocPopupper jdocPopper;

    public void initGui() {
        new AJIndexViewerGUI().createGui(this);
        this.initEvents();
    }

    public void requestSearchFldFocus() {
        this.searchFld.requestFocus();
    }

    void initEvents() {
        this.searchFld.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    if (e.isShiftDown() || e.isControlDown()) {
                        AJIndexViewer.this.actionBrowse(null, null);
                    } else {
                        AJIndexViewer.this.actionEdit(null, null);
                    }
                } else if (e.getKeyCode() == 38) {
                    AJIndexViewer.this.searchFld.hidePopup();
                    e.consume();
                } else if (e.getKeyCode() == 40) {
                    AJIndexViewer.this.searchFld.hidePopup();
                    e.consume();
                } else {
                    AJIndexViewer.this.actionSearch(e, this);
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    AJIndexViewer.this.searchFld.hidePopup();
                    e.consume();
                    AJIndexViewer.this.listPanel.actionUp(e, this);
                    AJIndexViewer.this.searchFld.hidePopup();
                } else if (e.getKeyCode() == 40) {
                    AJIndexViewer.this.searchFld.hidePopup();
                    e.consume();
                    AJIndexViewer.this.listPanel.actionDown(e, this);
                    AJIndexViewer.this.searchFld.hidePopup();
                }
            }
        });
        this.searchFld.setText("");
        this.editBtn.addTarget(this, "actionEdit");
        this.browseBtn.addTarget(this, "actionBrowse");
        this.browseFileBtn.addTarget(this, "actionBrowseFile");
        this.implBtn.addTarget(this, "actionAllImplementors");
        this.implBtn.setEnabled(false);
        this.implBtn.setMnemonic('i');
        this.browseBtn.setMnemonic('c');
        this.browseFileBtn.setMnemonic('f');
        this.editBtn.setMnemonic('e');
        this.listPanel.binder().addTarget(this, "actionListSelect");
        this.listPanel.doubleClickBinder().addTarget(this, "actionEdit");
        this.listPanel.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (e.isShiftDown() || e.isControlDown()) {
                        AJIndexViewer.this.actionBrowse(null, null);
                    } else {
                        AJIndexViewer.this.actionEdit(null, null);
                    }
                }
            }
        });
        this.listPanel.setPopUpGetter(EditApp.ServReg);
    }

    public Object actionEdit(Object arg, Object sender) {
        IndexEntry ie = (IndexEntry)this.listPanel.getSelectedObject();
        if (ie != null) {
            EditApp.App.openOrShow(ie);
        }
        return null;
    }

    public Object actionAllImplementors(Object arg, Object sender) {
        IndexEntry ie = (IndexEntry)this.listPanel.getSelectedObject();
        if (ie != null) {
            EditApp.App.openImplementorPanel(ie.realClassName());
        }
        return null;
    }

    public Object actionBrowse(Object arg, Object sender) {
        IndexEntry ie = (IndexEntry)this.listPanel.getSelectedObject();
        if (ie != null) {
            EditApp.App.browse(ie);
        }
        return null;
    }

    public Object actionBrowseFile(Object arg, Object sender) {
        IndexEntry ie = (IndexEntry)this.listPanel.getSelectedObject();
        if (ie != null) {
            EditApp.App.browse(new File(ie.getFileString()));
        }
        return null;
    }

    public Object actionSearch(Object arg, Object sender) {
        JSortedArray index = SourceBase.This().filteredIndex();
        int i = index.indexOf(this.searchFld.getText());
        this.listPanel.setSelectionIndex(i);
        this.listPanel.binder().notifyTargets(this);
        return null;
    }

    public Object actionListSelect(Object arg, Object sender) {
        IndexEntry ie = (IndexEntry)this.listPanel.getSelectedObject();
        this.implBtn.setEnabled(ie.isInterface());
        if (ie == null) {
            return null;
        }
        this.declFld.setText(ie.fileString() + "\n" + ie.declString());
        this.getPopper().startJDoc(ie, this.listPanel);
        return null;
    }

    public Object menuPopup_allMethodImplementors(Object arg, Object sender) {
        return null;
    }

    public Object menuPopup_allInterfaceImplementors(Object arg, Object sender) {
        IndexEntry ie = (IndexEntry)this.listPanel.getSelectedObject();
        if (ie != null) {
            EditApp.App.openImplementorPanel(ie.realClassName());
        }
        return null;
    }

    public Object menuPopup_subclass(Object arg, Object sender) {
        return null;
    }

    public void updateFromSBase() {
        this.setIndex(SourceBase.This().filteredIndexAsVector());
    }

    public void setIndex(Vector v) {
        try {
            this.listPanel.setList(v, this.listPanel.getOffset(), this.listPanel.getSelectionIndex());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.listPanel.repaint();
    }

    JDocPopupper getPopper() {
        if (this.jdocPopper == null) {
            this.jdocPopper = new JDocPopupper((Frame)this.getFrame());
            this.jdocPopper.init();
        }
        return this.jdocPopper;
    }

    public NCHistoryChoice getSearchField() {
        return this.searchFld;
    }

    public Object[] getDataSelection() {
        return this.listPanel.getDataSelection();
    }

    public void pastFirstPaint() {
        this.searchFld.requestFocus();
    }

    public Object actionApplication(Object arg, Object sender) {
        if (arg instanceof IValue && ((IValue)arg).stringValue().equals("rebuildIndex")) {
            this.updateFromSBase();
        }
        return null;
    }

    public void setSearchField(String s) {
        if (s == null || s.trim().length() == 0) {
            this.searchFld.selectAll();
        } else {
            this.searchFld.setText(s);
            this.searchFld.selectAll();
        }
        this.actionSearch(null, null);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }
}

