/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import Jxe.TextDocument;
import de.netcomputing.anyj.AJCompileAndBuild;
import de.netcomputing.anyj.AJIntroduceLocalGUI;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCEditor;
import de.netcomputing.anyj.parsing.IntroduceLocal;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.EditApp;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AJIntroduceLocal
extends NCPanel {
    JTextField nameTxt;
    NCButton upBtn;
    NCButton downBtn;
    JCheckBox replaceChk;
    JTextField typeTxt;
    NCButton applyBtn;
    NCButton cancelBtn;
    NCEditor editor;
    TextDocument doc;
    IntroduceLocal il;

    public static void DoIntroduceLocal(TextDocument doc) {
        JDialog dlg = new JDialog(EditApp.App.getMainWindow(), "Introduce Local Variable", true);
        AJIntroduceLocal ajem = new AJIntroduceLocal(doc);
        try {
            ajem.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Confirm.MsgException(ex);
            return;
        }
        dlg.getContentPane().add(ajem);
        dlg.pack();
        EditFrame ef = EditFrame.Host().getCurrentEditFrame();
        if (ef != null) {
            Dimension siz = ef.editPanel.getSize();
            dlg.setSize(siz.width, siz.height);
        } else {
            dlg.setSize(640, 400);
        }
        ApplicationHelper.Singleton().centerWindow(dlg);
        ajem.getRootPane().setDefaultButton(ajem.applyBtn);
        dlg.setVisible(true);
    }

    public AJIntroduceLocal(TextDocument doc) {
        this.doc = doc;
        this.initGui();
    }

    public void init() {
        try {
            DocumentListener tl = new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    AJIntroduceLocal.this.updatePreview();
                }

                public void removeUpdate(DocumentEvent e) {
                    AJIntroduceLocal.this.updatePreview();
                }

                public void changedUpdate(DocumentEvent e) {
                    AJIntroduceLocal.this.updatePreview();
                }
            };
            this.il = new IntroduceLocal(this.doc);
            this.il.parseAndInit(AJCompileAndBuild.This.getDebugSourcePath());
            this.nameTxt.setText(this.il.getVarName());
            String tp = this.il.getType();
            int i = tp.lastIndexOf(46);
            if (i >= 0) {
                tp = tp.substring(i + 1);
            }
            this.typeTxt.setText(tp);
            this.updatePreview();
            this.nameTxt.getDocument().addDocumentListener(tl);
            this.typeTxt.getDocument().addDocumentListener(tl);
            this.nameTxt.requestFocus();
            this.nameTxt.selectAll();
            this.editor.getDocument().setReadOnly(true);
            this.upBtn.setMnemonic('U');
            this.downBtn.setMnemonic('D');
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void initGui() {
        new AJIntroduceLocalGUI().createGui(this);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void updatePreview() {
        this.il.setType(this.typeTxt.getText());
        this.il.setVarName(this.nameTxt.getText());
        TextDocument dc = this.il.getPreview(this.replaceChk.isSelected(), true);
        this.editor.setDocument(dc);
        this.editor.getDocument().setReadOnly(true);
        this.doc.highlightAll();
        this.doc.centerPosition();
        this.editor.repaint();
        this.upBtn.setEnabled(this.il.canScopeUp());
        this.downBtn.setEnabled(this.il.canScopeDown());
    }

    public void replaceChk_itemStateChanged(ItemEvent var0) {
        this.updatePreview();
    }

    public void upBtn_actionPerformed(ActionEvent var0) {
        this.il.scopeUp();
        this.updatePreview();
    }

    public void downBtn_actionPerformed(ActionEvent var0) {
        this.il.scopeDown();
        this.updatePreview();
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        ((JDialog)this.getTopLevelAncestor()).dispose();
    }

    public void applyBtn_actionPerformed(ActionEvent var0) {
        this.il.doInsert(this.replaceChk.isSelected());
        ((JDialog)this.getTopLevelAncestor()).dispose();
    }
}

