/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JCollections.DirIterator;
import JWVFile.VFile;
import de.netcomputing.anyj.AJCompileAndBuild;
import de.netcomputing.anyj.AJPackReplaceResult;
import de.netcomputing.anyj.AJRenamePackageGUI;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCFileUtilities;
import editapp.EditApp;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JTextField;

public class AJRenamePackage
extends NCPanel {
    JCheckBox viewRep;
    JTextField newNameTxt;
    JTextField nameTxt;
    NCButton cancelBtn;
    NCButton applyBtn;

    public static void Open(String pack) {
        JDialog dlg = new JDialog(EditApp.App.getMainWindow(), "Rename Package", true);
        AJRenamePackage ajem = new AJRenamePackage();
        ajem.nameTxt.setText(pack);
        dlg.getContentPane().add(ajem);
        dlg.pack();
        EditFrame ef = EditFrame.Host().getCurrentEditFrame();
        dlg.pack();
        ApplicationHelper.Singleton().centerWindow(dlg);
        ajem.getRootPane().setDefaultButton(ajem.applyBtn);
        dlg.setDefaultCloseOperation(2);
        dlg.setVisible(true);
    }

    public AJRenamePackage() {
        this.initGui();
    }

    public void initGui() {
        new AJRenamePackageGUI().createGui(this);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        ((Window)this.getTopLevelAncestor()).dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void applyBtn_actionPerformed(ActionEvent var0) {
        block7: {
            block6: {
                try {
                    try {
                        this.cursorWait();
                        if (this.nameTxt.getText().trim().length() == 0 || this.newNameTxt.getText().trim().length() == 0) {
                            new Thread(){

                                public void run() {
                                    Confirm.ModalMsg("Error", "Old or New package name can not be empty");
                                }
                            }.start();
                            Object var4_2 = null;
                            break block6;
                        }
                        this.replacePack(this.nameTxt.getText(), this.newNameTxt.getText());
                        break block7;
                    }
                    catch (Exception ex) {
                        Confirm.MsgException(ex);
                        Object var4_4 = null;
                        this.cursorDefault();
                        ((Window)this.getTopLevelAncestor()).dispose();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.cursorDefault();
                    ((Window)this.getTopLevelAncestor()).dispose();
                    throw throwable;
                }
            }
            this.cursorDefault();
            ((Window)this.getTopLevelAncestor()).dispose();
            return;
        }
        Object var4_3 = null;
        this.cursorDefault();
        ((Window)this.getTopLevelAncestor()).dispose();
    }

    public void replacePack(String oldP, String newP) {
        Vector sp = NCFileUtilities.GetPathAsVector(AJCompileAndBuild.This.getSourcePathAndCompute());
        String oldPackFile = oldP.replace('.', File.separatorChar);
        String newPackFile = newP.replace('.', File.separatorChar);
        File sourcePathPreRename = new File(AJCompileAndBuild.This.getSourcePathAndCompute());
        HashMap<String, EditFrame> openedFiles = new HashMap<String, EditFrame>();
        Vector frames = EditFrame.Host().getOpenEditFrames();
        HashSet<File> toDelete = new HashSet<File>();
        int i = 0;
        while (i < frames.size()) {
            EditFrame ef = (EditFrame)frames.get(i);
            openedFiles.put(ef.getDocument().getFile().getAbsolutePath(), ef);
            ++i;
        }
        HashMap<File, File> toRename = new HashMap<File, File>();
        int i2 = 0;
        while (i2 < sp.size()) {
            File f = new File(sp.get(i2) + File.separator + oldPackFile);
            if (f.exists()) {
                toDelete.add(f);
                Vector v = DirIterator.DirContent(f, "", true);
                File newF = new File(sp.get(i2) + File.separator + newPackFile);
                int ii = 0;
                while (ii < v.size()) {
                    File fi = (File)v.get(ii);
                    if (fi.getAbsolutePath().startsWith(f.getAbsolutePath() + File.separator)) {
                        if (!fi.isDirectory()) {
                            String fiString = fi.getAbsolutePath();
                            File targetF = new File(newF + fiString.substring(f.getAbsolutePath().length()));
                            targetF.getParentFile().mkdirs();
                            toRename.put(fi, targetF);
                            if (openedFiles.containsKey(fiString)) {
                                ((EditFrame)openedFiles.get(fiString)).getDocument().setFile(targetF);
                            }
                        } else {
                            toDelete.add(fi);
                        }
                    }
                    ++ii;
                }
            }
            ++i2;
        }
        Iterator renIt = toRename.keySet().iterator();
        while (renIt.hasNext()) {
            File fi = (File)renIt.next();
            File targetF = (File)toRename.get(fi);
            try {
                VFile.Copy(fi, targetF);
                toDelete.add(fi);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Confirm.ModalMsg(EditApp.App.getMainWindow(), "Failed to copy", new String[]{"Could not rename:", fi.getAbsolutePath(), "to", targetF.getAbsolutePath(), "Please check for OS-locks on ", "this directory"});
                Confirm.MsgException(ex);
                return;
            }
        }
        boolean deletedOne = true;
        while (deletedOne) {
            deletedOne = false;
            Iterator it = toDelete.iterator();
            while (it.hasNext()) {
                File tmp = (File)it.next();
                if (!tmp.delete() && tmp.exists()) continue;
                deletedOne = true;
                it.remove();
            }
        }
        final AJPackReplaceResult ajfp = new AJPackReplaceResult();
        EditApp.App.openNewFindPanel(ajfp, sourcePathPreRename, oldP, "Rename Package '" + oldP + "'");
        ajfp.replaceTxt.setText(newP);
        ajfp.setRunAfterSearch(new Runnable(){

            public void run() {
                if (!AJRenamePackage.this.viewRep.isSelected()) {
                    ajfp.replaceAll();
                }
                EditApp.App.updateDirTree();
                EditApp.App.updateSourceBase();
            }
        });
        ajfp.actionProcess(null, null);
    }
}

