/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JCollections.JArray;
import JCollections.JUnsafeTable;
import JWVFile.VFile;
import Jxe.KeyboardEvent;
import de.netcomputing.anyj.AJServiceOptionsGUI;
import de.netcomputing.anyj.application.XMLProjectDescription;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCCheckBox;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTextField;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.application.services.INCService;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import de.netcomputing.util.xml.Node;
import de.netcomputing.util.xml.XmlReader;
import editapp.EditApp;
import editapp.ServiceRegistry;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netcomputing.tools.PropWriter;

public class AJServiceOptions
extends NCPanel
implements KeyListener {
    public static AJServiceOptions This;
    JUnsafeTable loadedOptions = new JUnsafeTable(60);
    NCButton forteBtn;
    NCButton jbuilderBtn;
    NCButton defaultBtn;
    JPanel servLabel;
    NCTextField abbrevTxt;
    NCButton jwBtn;
    NCButton cancelBtn;
    NCTextField txtFld;
    NCCheckBox oneKeyBox;
    NCCheckBox noEditorBox;
    NCCheckBox noListBox;
    NCTreeBean listPanel;
    INCService prevSel;
    KeyboardEvent lastKE;

    public void initGui() {
        new AJServiceOptionsGUI().createGui(this);
        this.init();
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void init() {
        this.setName("hidservices");
        if (This != null) {
            throw new RuntimeException("Second instance of Singleton !");
        }
        This = this;
        this.listPanel.clear();
        this.listPanel.addTarget(this, "actionListSel");
        this.listPanel.binderIconClick().addTarget(this, "actionListSel");
        this.txtFld.setText("select a service");
        this.txtFld.setEditable(false);
        this.txtFld.addKeyListener(this);
        this.txtFld.setName("dontcatchEvents");
        this.abbrevTxt.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                AJServiceOptions.this.enableApplyButtons(true);
            }

            public void removeUpdate(DocumentEvent e) {
                AJServiceOptions.this.enableApplyButtons(true);
            }

            public void changedUpdate(DocumentEvent e) {
                AJServiceOptions.this.enableApplyButtons(true);
            }
        });
        this.enableApplyButtons(false);
        this.jwBtn.addTarget(this, "actionApply");
        this.oneKeyBox.addTarget(this, "actionApplyEnabled");
        this.noListBox.addTarget(this, "actionApplyEnabled");
        this.noEditorBox.addTarget(this, "actionApplyEnabled");
        EditApp.App.binderApplication().addTarget(this, "actionApplication");
        this.freeMem();
        this.validateButtons();
    }

    void enableApplyButtons(boolean b) {
        this.jwBtn.setEnabled(b);
        this.cancelBtn.setEnabled(b);
    }

    public void store(PropWriter pw) {
        try {
            DataOutputStream dos = pw.createStream("serviceoptions");
            this.storeInternal(dos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(PropWriter pw) {
        try {
            DataInputStream dis = pw.getStream("serviceoptions");
            this.loadInternal(dis);
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
        }
    }

    public void selectItem(final INCService name) {
        this.listPanel.setSelectedObject(name);
        this.listPanel.binder().notifyTargets(this.listPanel.getSelectionIndex());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AJServiceOptions.this.listPanel.setSelectedObject(name);
                AJServiceOptions.this.listPanel.binder().notifyTargets(AJServiceOptions.this.listPanel.getSelectionIndex());
            }
        });
    }

    public void storeInternal(DataOutputStream o) throws Exception {
        ArrayList arr = EditApp.ServReg.getServices();
        ObjectOutputStream oo = new ObjectOutputStream(o);
        oo.writeInt(arr.size());
        int n = 0;
        while (n < arr.size()) {
            INCService serv = (INCService)arr.get(n);
            oo.writeUTF(serv.getCategory() + serv.getMenuName());
            oo.writeInt(serv.getUsage());
            oo.writeObject(serv.getShortcut());
            oo.writeBoolean(serv.getShowInList());
            oo.writeBoolean(serv.getShowInEditor());
            oo.writeBoolean(serv.getOneKey());
            ++n;
        }
        try {
            int n2 = 0;
            while (n2 < arr.size()) {
                INCService serv = (INCService)arr.get(n2);
                oo.writeUTF(serv.getCategory() + serv.getMenuName());
                oo.writeUTF(serv.getAbbrev());
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        oo.close();
    }

    public Object actionApplyEnabled(Object a, Object s) {
        this.enableApplyButtons(true);
        this.jwBtn.setDefaultCapable(true);
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.jwBtn);
        }
        return null;
    }

    public Object actionApply(Object a, Object s) {
        this.apply(this.prevSel);
        this.listPanel.repaint();
        return null;
    }

    public Object actionApplication(Object a, Object s) {
        if (a.toString().equals("servicesChanged")) {
            this.postInit();
        }
        return null;
    }

    public void loadInternal(DataInputStream o) throws Exception {
        ArrayList arr = EditApp.ServReg.getServices();
        ObjectInputStream oi = new ObjectInputStream(o);
        int len = oi.readInt();
        int n = 0;
        while (n < len) {
            String key = oi.readUTF();
            int usage = oi.readInt();
            KeyboardEvent ke = (KeyboardEvent)oi.readObject();
            Boolean list = new Boolean(oi.readBoolean());
            Boolean editor = new Boolean(oi.readBoolean());
            Boolean oneKey = new Boolean(oi.readBoolean());
            this.loadedOptions.put(key, new Object[]{ke, new Integer(usage), list, editor, oneKey, null});
            ++n;
        }
        try {
            int n2 = 0;
            while (n2 < len) {
                String key = oi.readUTF();
                String abbr = oi.readUTF();
                ((Object[])this.loadedOptions.get((Object)key))[5] = abbr;
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        oi.close();
        ((ServiceRegistry)EditApp.App.getServReg()).updateAbbrevMap();
    }

    public void apply(INCService serv) {
        if (serv != null) {
            String[] s;
            JArray coll = null;
            if (this.oneKeyBox.isPressed()) {
                coll = EditApp.ServReg.findCollisionServicesForShortCut(null, this.lastKE);
            }
            if (coll == null) {
                coll = new JArray(1);
            }
            int n = 0;
            while (n < coll.size()) {
                s = (String[])coll.at(n);
                if (s.getCategory().equals(serv.getCategory()) && s.getMenuName().equals(serv.getMenuName())) {
                    coll.remAt(n);
                    --n;
                }
                ++n;
            }
            if (coll.size() > 0) {
                s = new String[coll.size()];
                int n2 = 0;
                while (n2 < s.length) {
                    s[n2] = ((INCService)coll.at(n2)).getCategory() + " " + ((INCService)coll.at(n2)).getMenuName();
                    ++n2;
                }
                Confirm.ModalMsg((Window)this.getFrame(), "Shortcut Collision", s);
            } else {
                ArrayList v = EditApp.ServReg.getServices();
                int n3 = 0;
                while (n3 < v.size()) {
                    INCService s2 = (INCService)v.get(n3);
                    if (s2.getCategory().equals(serv.getCategory()) && s2.getMenuName().equals(serv.getMenuName())) {
                        s2.setShortcut(this.lastKE);
                        s2.setAbbrev(this.abbrevTxt.getText().trim());
                        s2.setShowInList(this.noListBox.isPressed());
                        s2.setShowInEditor(this.noEditorBox.isPressed());
                        s2.setOneKey(this.oneKeyBox.isPressed() && this.lastKE.key != 0);
                    }
                    ++n3;
                }
                this.removeServiceFromLoadedOptions(serv);
                this.enableApplyButtons(false);
            }
            ((ServiceRegistry)EditApp.App.getServReg()).updateAbbrevMap();
        }
    }

    public void removeServiceFromLoadedOptions(INCService serv) {
        this.loadedOptions.remove(serv.getCategory() + serv.getMenuName());
    }

    public Object actionListSel(Object arg, Object sen) {
        if (!(this.listPanel.getSelectedObject() instanceof INCService)) {
            JWidgetsUtil.EnableAllComponents(this.servLabel, false);
            this.txtFld.setText("select a service");
            this.noListBox.setPressed(false);
            this.noEditorBox.setPressed(false);
            this.oneKeyBox.setPressed(false);
            this.lastKE = null;
            this.abbrevTxt.setText("");
        } else {
            JWidgetsUtil.EnableAllComponents(this.servLabel, true);
            INCService serv = (INCService)this.listPanel.getSelectedObject();
            ((TitledBorder)this.servLabel.getBorder()).setTitle(serv.getCategory() + " - " + serv.getMenuName());
            this.servLabel.repaint();
            if (serv != null) {
                this.txtFld.setText("" + serv.getShortcut());
                this.lastKE = serv.getShortcut();
                this.noListBox.setPressed(serv.getShowInList());
                this.noEditorBox.setPressed(serv.getShowInEditor());
                this.oneKeyBox.setPressed(serv.getOneKey());
                this.abbrevTxt.setText(serv.getAbbrev());
            } else {
                this.txtFld.setText("select a service");
                this.noListBox.setPressed(false);
                this.noEditorBox.setPressed(false);
                this.oneKeyBox.setPressed(false);
                this.lastKE = null;
                this.abbrevTxt.setText("");
            }
            this.prevSel = serv;
            this.enableApplyButtons(false);
        }
        this.validateButtons();
        return null;
    }

    public void postInit() {
        ArrayList arr0 = EditApp.ServReg.getServices();
        JArray arr = new JArray(arr0.size());
        int i = 0;
        while (i < arr0.size()) {
            arr.add(arr0.get(i));
            ++i;
        }
        JArray.QuickSort(arr, JArray.UpperCaseStringSortFunc());
        this.listPanel.clear();
        JUnsafeTable tab = new JUnsafeTable(37);
        JUnsafeTable catToTree = new JUnsafeTable(91);
        int n = 0;
        while (n < arr.size()) {
            INCService serv = (INCService)arr.at(n);
            String cat = serv.getCategory();
            if (catToTree.get(cat) == null) {
                ListItem it = new ListItem(cat.trim().length() == 0 ? "Cut/Copy" : cat, NCApplication.GetImage("/images/folder8.gif")){

                    public Image getOpenImage() {
                        return NCApplication.GetImage("/images/folder8o.gif");
                    }
                };
                catToTree.put(cat, it);
                this.listPanel.addItem(it);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < arr.size()) {
            INCService serv = (INCService)arr.at(n2);
            String hash = serv.getCategory() + serv.getMenuName();
            if (tab.get(hash) == null) {
                tab.put(hash, Boolean.TRUE);
                ListItem it = (ListItem)catToTree.get(serv.getCategory());
                it.addItem(new ListItem(serv){

                    public String getDisplayString() {
                        return ((INCService)this.wrappedObject()).getMenuName() + (((INCService)this.wrappedObject()).getOneKey() ? " (" + ((INCService)this.wrappedObject()).getShortCutString() + ")" : "") + (((INCService)this.wrappedObject()).getAbbrev().length() > 0 ? " [" + ((INCService)this.wrappedObject()).getAbbrev() + "]" : "");
                    }

                    public Image getImage() {
                        return NCApplication.GetImage("/images/menus/" + ((INCService)this.wrappedObject()).getMenuName() + ".gif");
                    }
                });
            }
            ++n2;
        }
        this.listPanel.repaint();
        int n3 = 0;
        while (n3 < arr.size()) {
            INCService serv = (INCService)arr.at(n3);
            Object[] obj = (Object[])this.loadedOptions.get(serv.getCategory() + serv.getMenuName());
            if (obj != null) {
                serv.setUsage((Integer)obj[1]);
                serv.setShortcut((KeyboardEvent)obj[0]);
                serv.setShowInList((Boolean)obj[2]);
                serv.setShowInEditor((Boolean)obj[3]);
                serv.setOneKey((Boolean)obj[4]);
                try {
                    serv.setAbbrev(obj[5].toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
            ++n3;
        }
        this.listPanel.expandAll();
    }

    public void keyPressed(KeyEvent evt) {
        this.keyReleased(evt);
    }

    public void keyReleased(KeyEvent evt) {
        if (evt.getKeyCode() != 16 && evt.getKeyCode() != 18 && evt.getKeyCode() != 157 && evt.getKeyCode() != 17) {
            this.lastKE = new KeyboardEvent(evt);
            this.txtFld.setText(KeyEvent.getKeyModifiersText(evt.getModifiers()) + " " + KeyEvent.getKeyText(evt.getKeyCode()));
            if (this.listPanel.getSelectionIndex() >= 0) {
                this.enableApplyButtons(true);
            }
            evt.consume();
        }
    }

    public void keyTyped(KeyEvent evt) {
        this.keyReleased(evt);
    }

    public void validateButtons() {
        this.txtFld.setEnabled(this.oneKeyBox.isSelected());
        if (!this.oneKeyBox.isSelected()) {
            this.lastKE = new KeyboardEvent(false, false, false, false, 0);
            this.txtFld.setText("none");
        }
    }

    public void forteBtn_actionPerformed(ActionEvent var0) {
        try {
            this.defaultBtn_actionPerformed(var0);
            Node node = (Node)new XmlReader().read(new FileInputStream(VFile.ResolveName("#staticdata/frtealike.ajpr")));
            XMLProjectDescription dex = new XMLProjectDescription(node, VFile.ResolveName("#staticdata/frtealike.ajpr"));
            dex.applyConfig();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Confirm.MsgException(ex);
        }
    }

    public void jbuilderBtn_actionPerformed(ActionEvent var0) {
        try {
            this.defaultBtn_actionPerformed(var0);
            Node node = (Node)new XmlReader().read(new FileInputStream(VFile.ResolveName("#staticdata/jblderalike.ajpr")));
            XMLProjectDescription dex = new XMLProjectDescription(node, VFile.ResolveName("#staticdata/jblderalike.ajpr"));
            dex.applyConfig();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Confirm.MsgException(ex);
        }
    }

    public void oneKeyBox_actionPerformed(ActionEvent var0) {
        this.validateButtons();
    }

    public void jwBtn_actionPerformed(ActionEvent var0) {
        this.actionApply(null, null);
    }

    public void defaultBtn_actionPerformed(ActionEvent var0) {
        try {
            Node node = (Node)new XmlReader().read(new FileInputStream(VFile.ResolveName("#staticdata/default_shortcuts.ajpr")));
            XMLProjectDescription dex = new XMLProjectDescription(node, VFile.ResolveName("#staticdata/default_shortcuts.ajpr"));
            dex.applyConfig();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Confirm.MsgException(ex);
        }
    }

    public void oneKeyBox_itemStateChanged(ItemEvent var0) {
        this.validateButtons();
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        this.actionListSel(null, null);
        this.enableApplyButtons(false);
    }

    public void numPanel_actionPerformed(ActionEvent var0) {
        this.actionApplyEnabled(null, null);
    }
}

