/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import de.netcomputing.anyj.ZipExtractorGUI;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.propertystore.beans.PropertyFileSel;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ZipExtractor
extends JPanel {
    PropertyFileSel outDir;
    JProgressBar progressBar;
    JButton extractBtn;
    PropertyFileSel zipDir;
    boolean autoClose = true;
    boolean error = false;
    int fullCount = 0;

    public static boolean OpenExtractorModal(Window main, String in, String out, boolean autoExtract) {
        ZipExtractor zp = new ZipExtractor();
        JDialog dg = ApplicationHelper.Singleton().createDialogOn(main, zp, true);
        zp.outDir.setText(out);
        zp.zipDir.setText(in);
        dg.pack();
        ApplicationHelper.Singleton().centerWindow(dg);
        if (autoExtract) {
            zp.extractBtn_actionPerformed(null);
        }
        dg.setVisible(true);
        return zp.error;
    }

    public ZipExtractor() {
        this.initGui();
    }

    public void initGui() {
        new ZipExtractorGUI().createGui(this);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    void extractFile(ZipFile zf, File target) throws IOException {
        this.fullCount = 0;
        this.progressBar.setString("counting entries..");
        Enumeration<? extends ZipEntry> en = zf.entries();
        while (en.hasMoreElements()) {
            ++this.fullCount;
            en.nextElement();
            if (this.fullCount % 100 != 0) continue;
            this.progressBar.setString("counting entries.." + this.fullCount);
        }
        this.progressBar.setMaximum(this.fullCount);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
        this.progressBar.setString("unpacking");
        this.fullCount = 0;
        en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            this.copyInputStream(zf, ze, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void copyInputStream(ZipFile zf, ZipEntry ze, File base) throws IOException {
        this.progressBar.setValue(this.fullCount++);
        String s = ze.getName();
        int i = s.lastIndexOf(47);
        if (i >= 0) {
            s = s.substring(i);
        }
        this.progressBar.setString(s);
        OutputStream out = null;
        try {
            if (!ze.getName().endsWith("/")) {
                String target = base.getAbsolutePath() + File.separator + ze.getName().replace('/', File.separatorChar);
                BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze), 20000);
                File tr = new File(target).getParentFile();
                boolean res = tr.mkdirs();
                Tracer.This.println("mkdirs:" + tr.getAbsolutePath() + " zename:" + ze.getName() + " res:" + res);
                out = new BufferedOutputStream(new FileOutputStream(target), 20000);
                int c = 0;
                boolean count = false;
                while ((c = ((InputStream)in).read()) >= 0) {
                    out.write(c);
                }
            }
            Object var14_13 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public void extractBtn_actionPerformed(ActionEvent var0) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block6: {
                    try {
                        try {
                            ZipExtractor.this.extractBtn.setEnabled(false);
                            ZipExtractor.this.outDir.setEnabled(false);
                            ZipExtractor.this.zipDir.setEnabled(false);
                            File out = new File(ZipExtractor.this.outDir.getText().trim());
                            ZipFile zf = new ZipFile(ZipExtractor.this.zipDir.getText().trim());
                            out.mkdirs();
                            if (!out.exists()) {
                                throw new RuntimeException("failed to create directory:" + ZipExtractor.this.outDir.getText());
                            }
                            ZipExtractor.this.extractFile(zf, out);
                            zf.close();
                            ZipExtractor.this.error = false;
                        }
                        catch (Throwable ex) {
                            ZipExtractor.this.error = true;
                            Confirm.MsgException(ex);
                            ex.printStackTrace();
                            Object var4_5 = null;
                            ZipExtractor.this.extractBtn.setEnabled(true);
                            ZipExtractor.this.outDir.setEnabled(true);
                            ZipExtractor.this.zipDir.setEnabled(true);
                            break block6;
                        }
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        ZipExtractor.this.extractBtn.setEnabled(true);
                        ZipExtractor.this.outDir.setEnabled(true);
                        ZipExtractor.this.zipDir.setEnabled(true);
                        throw throwable;
                    }
                    ZipExtractor.this.extractBtn.setEnabled(true);
                    ZipExtractor.this.outDir.setEnabled(true);
                    ZipExtractor.this.zipDir.setEnabled(true);
                }
                if (ZipExtractor.this.autoClose) {
                    ((Window)ZipExtractor.this.getTopLevelAncestor()).dispose();
                }
            }
        }.start();
    }

    public static void main(String[] args) {
        ZipExtractor.OpenExtractorModal(new Frame(), "C:\\jdks\\jdk1.3.1rc2\\src.jar", "C:\\jdks\\jdk1.3.1rc2\\", true);
    }
}

