/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.application;

import de.netcomputing.anyj.application.CardPanelEditorHost;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.debugger.DebuggerMainPanel;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.swingx.DockingComponentInfo;
import de.netcomputing.swingx.DockingComponentWrapper;
import de.netcomputing.swingx.DockingContainer;
import de.netcomputing.swingx.DockingDesktop;
import de.netcomputing.swingx.DockingDesktopListener;
import de.netcomputing.swingx.DockingWindowTitleBar;
import de.netcomputing.swingx.IDockingContainer;
import de.netcomputing.swingx.NCButtonTabbedPane;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import netcomputing.tools.PropWriter;

public class DockingEditorHost
extends CardPanelEditorHost
implements DockingDesktopListener {
    DockingDesktop dDesktop;
    static String defaultLayout = "0,0:-210,|m1050,output:|m203,agent:-742,|721,editors:|329,trees:";
    JMenuItem debugItem;
    JMenuItem browseItem;
    JMenuItem editItem;
    JMenuItem runItem;
    JMenuItem guiItem;
    JMenuItem configMngItem;
    JMenuItem doAutoSwitchItem;
    JMenuItem doAutoSaveItem;
    JMenuItem saveItem;
    JMenuItem[] configItems;
    String currentConfig = "Edit";
    HashMap configs = new HashMap();
    ButtonGroup cfgGroup = new ButtonGroup();
    ArrayList toRunAfterInit;
    ArrayList toRunAfterInit1 = new ArrayList();
    HashMap compileConf = null;

    public DockingEditorHost() {
        this.dDesktop = this.createDesktop();
        this.configs.put("Edit", defaultLayout);
        this.configs.put("Debug", "0,0:-219,|1050,output:|m203,agent:-121,|815,Current:|235,Breakpoints:-355,|715,editors:|m329,trees:|335,Threads:");
        this.configs.put("Run", "0,0:-458,|1050,output:|m203,agent:-284,|721,editors:|329,trees:");
    }

    JPopupMenu createAJStartMenu() {
        final Image im = this.getMenuImage();
        JPopupMenu popMenu = new JPopupMenu(){

            public Insets getInsets() {
                return new Insets(2, im.getWidth(this), 2, 2);
            }

            public void paint(Graphics g) {
                super.paint(g);
                int imh = im.getHeight(this);
                g.drawImage(im, 0, this.getHeight() - imh, this);
                g.setColor(Color.black);
                g.drawRect(0, 0, im.getWidth(this) - 1, this.getHeight() - 1);
            }
        };
        JMenuItem resetItem = new JMenuItem("Reset Layout");
        resetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DockingEditorHost.this.menuReset();
            }
        });
        this.saveItem = new JMenuItem("Save Configuration");
        this.saveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DockingEditorHost.this.menuSaveConfig();
            }
        });
        this.debugItem = new JCheckBoxMenuItem("Debug");
        this.debugItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DockingEditorHost.this.setConfigByMenu("Debug");
            }
        });
        this.browseItem = new JCheckBoxMenuItem("Browse");
        this.browseItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DockingEditorHost.this.setConfigByMenu("Browse");
            }
        });
        this.editItem = new JCheckBoxMenuItem("Edit");
        this.editItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DockingEditorHost.this.setConfigByMenu("Edit");
            }
        });
        this.runItem = new JCheckBoxMenuItem("Run");
        this.runItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DockingEditorHost.this.setConfigByMenu("Run");
            }
        });
        this.configMngItem = new JCheckBoxMenuItem("Checkin/Checkout");
        this.configMngItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DockingEditorHost.this.setConfigByMenu("Checkin/Checkout");
            }
        });
        this.guiItem = new JCheckBoxMenuItem("GUI Editing");
        this.guiItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DockingEditorHost.this.setConfigByMenu("GUI Editing");
            }
        });
        this.doAutoSwitchItem = new JCheckBoxMenuItem("Automatically Switch View");
        this.doAutoSaveItem = new JCheckBoxMenuItem("Automatically Save Configuration");
        this.doAutoSaveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DockingEditorHost.this.saveItem.setEnabled(!DockingEditorHost.this.doAutoSaveItem.isSelected());
            }
        });
        popMenu.add(this.guiItem);
        popMenu.add(this.configMngItem);
        popMenu.add(this.runItem);
        popMenu.add(this.debugItem);
        popMenu.add(this.browseItem);
        popMenu.add(this.editItem);
        popMenu.addSeparator();
        popMenu.add(this.saveItem);
        popMenu.add(this.doAutoSaveItem);
        popMenu.add(this.doAutoSwitchItem);
        popMenu.add(resetItem);
        this.cfgGroup.add(this.guiItem);
        this.cfgGroup.add(this.configMngItem);
        this.cfgGroup.add(this.runItem);
        this.cfgGroup.add(this.debugItem);
        this.cfgGroup.add(this.browseItem);
        this.cfgGroup.add(this.editItem);
        this.configItems = new JMenuItem[]{this.editItem, this.browseItem, this.debugItem, this.runItem, this.configMngItem, this.guiItem};
        int i = 0;
        while (i < this.configItems.length) {
            this.configItems[i].setAccelerator(KeyStroke.getKeyStroke(49 + i, 2));
            ++i;
        }
        this.doAutoSaveItem.setSelected(false);
        this.doAutoSwitchItem.setSelected(false);
        return popMenu;
    }

    public void menuReset() {
        this.flyInAll();
        this.dDesktop.clear();
        this.dDesktop.setLayoutConfiguration(defaultLayout, null);
    }

    public boolean getIsAutoSwitchEnabled() {
        return this.doAutoSwitchItem.isSelected();
    }

    public boolean getIsAutoSaveEnabled() {
        return this.doAutoSaveItem.isSelected();
    }

    public void menuSaveConfig() {
        System.out.println("SAVING CONFIG:" + this.currentConfig + " " + this.dDesktop.getLayoutConfiguration(null));
        this.configs.put(this.currentConfig, this.dDesktop.getLayoutConfiguration(null));
    }

    public void notifyViewSwitch(String name) {
        if (this.getIsAutoSwitchEnabled() && this.configs.get(name) != null) {
            this.setConfig(name);
        }
    }

    public void setConfig(int number) {
        this.setConfig(this.configItems[number].getLabel());
    }

    void setConfigByMenu(String s) {
        this.setConfig(s);
    }

    public void setConfig(final String s) {
        try {
            RepaintManager.currentManager(this).paintDirtyRegions();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DockingEditorHost.this.internalSetConfig(s);
                DockingEditorHost.this.internalSetConfig(s);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void internalSetConfig(String s) {
        NCButtonTabbedPane ncbtPane;
        block16: {
            block15: {
                ncbtPane = null;
                try {
                    if (this.getIsAutoSaveEnabled() && !s.equals(this.currentConfig)) {
                        this.menuSaveConfig();
                    }
                    ncbtPane = EditApp.App.jol.getCardPanel();
                    ncbtPane.setIgnoreRepaint(true);
                    String jolSel = "Files";
                    try {
                        jolSel = ncbtPane.getTitleAt(ncbtPane.getSelectedIndex());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(Tracer.This);
                    }
                    NCButtonTabbedPane dbgPane = DebuggerMainPanel.This().getTabbedPane();
                    String dbgSel = "Current";
                    try {
                        int idx = dbgPane.getSelectedIndex();
                        if (idx < 0) {
                            idx = 0;
                        }
                        dbgSel = dbgPane.getTitleAt(0);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(Tracer.This);
                    }
                    this.currentConfig = s;
                    String conf = (String)this.configs.get(s);
                    if (conf == null) {
                        this.configs.put(s, defaultLayout);
                        this.setConfig(s);
                        Object var9_11 = null;
                        break block15;
                    }
                    this.flyInAll();
                    this.dDesktop.clear();
                    this.toRunAfterInit = this.dDesktop.setLayoutConfiguration(conf, null);
                    int i = 0;
                    while (true) {
                        if (i >= this.configItems.length) {
                            DockingContainer.disableLayoutRecalling = true;
                            ncbtPane.setSelectedTab(jolSel);
                            dbgPane.setSelectedTab(dbgSel);
                            break block16;
                        }
                        if (this.configItems[i].getLabel().equals(this.currentConfig)) {
                            this.configItems[i].setSelected(true);
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    ncbtPane.setIgnoreRepaint(false);
                    DockingContainer.disableLayoutRecalling = false;
                    throw throwable;
                }
            }
            ncbtPane.setIgnoreRepaint(false);
            DockingContainer.disableLayoutRecalling = false;
            return;
        }
        Object var9_12 = null;
        ncbtPane.setIgnoreRepaint(false);
        DockingContainer.disableLayoutRecalling = false;
        this.getTopLevelAncestor().invalidate();
        this.getTopLevelAncestor().repaint();
        try {
            RepaintManager.currentManager(this).paintDirtyRegions();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (EditFrame.Host().getCurrentEditFrame() != null) {
            EditFrame.Host().getCurrentEditFrame().editPanel.requestFocus();
        }
    }

    public DockingDesktop createDesktop() {
        DockingDesktop res = new DockingDesktop(){

            public JPopupMenu createStartMenu() {
                return DockingEditorHost.this.createAJStartMenu();
            }

            protected String getStartMenuTitle() {
                return "Configurations";
            }

            protected void prepareForSave(DockingComponentWrapper dcWrapper, Object userContext) {
                if (dcWrapper.getContentPanel() == DockingEditorHost.this.trees) {
                    dcWrapper.setSaveId("trees");
                } else if (dcWrapper.getContentPanel() == DockingEditorHost.this.editors) {
                    dcWrapper.setSaveId("editors");
                } else if (dcWrapper.getContentPanel() == DockingEditorHost.this.agent) {
                    dcWrapper.setSaveId("agent");
                } else if (dcWrapper.getContentPanel() == DockingEditorHost.this.output) {
                    dcWrapper.setSaveId("output");
                } else if (dcWrapper.getTitleBar() != null) {
                    if (!"Empty Panel".equals(dcWrapper.getTitleBar().getTitle())) {
                        dcWrapper.setSaveId(dcWrapper.getTitleBar().getTitle());
                    } else {
                        dcWrapper.setSaveId(null);
                    }
                }
            }

            protected JComponent createFromSaveId(String saveId, Object aHashTable, DockingComponentInfo info) {
                if ("trees".equals(saveId)) {
                    info.setCanClose(false);
                    info.setTitle("Project Views");
                    return DockingEditorHost.this.trees;
                }
                if ("editors".equals(saveId)) {
                    info.setCanClose(false);
                    info.setTitle("Editors");
                    return DockingEditorHost.this.editors;
                }
                if ("output".equals(saveId)) {
                    info.setCanClose(false);
                    info.setTitle("Output Windows");
                    return DockingEditorHost.this.output;
                }
                if ("agent".equals(saveId)) {
                    info.setCanClose(false);
                    info.setTitle("Help Agent");
                    return DockingEditorHost.this.agent;
                }
                NCButtonTabbedPane ncbtPane = EditApp.App.jol.getCardPanel();
                int i = ncbtPane.indexOf(saveId);
                if (i >= 0) {
                    DockingComponentWrapper dcWrapper = ncbtPane.flyOut(i, DockingEditorHost.this.dDesktop);
                    return dcWrapper;
                }
                NCButtonTabbedPane dbgPane = DebuggerMainPanel.This().getTabbedPane();
                i = dbgPane.indexOf(saveId);
                if (i >= 0) {
                    DockingComponentWrapper dcWrapper = dbgPane.flyOut(i, this);
                    return dcWrapper;
                }
                return null;
            }

            protected void initDCWrapper(IDockingContainer parent, DockingComponentWrapper dcWrapper) {
                super.initDCWrapper(parent, dcWrapper);
            }
        };
        DockingWindowTitleBar.secondarySelColor = SystemColor.inactiveCaption;
        res.setIsVert(false);
        res.setSuperBar(EditApp.App.jol.getCollBar());
        res.init();
        res.addDockingDesktopListener(this);
        return res;
    }

    public void flyInAll() {
        NCButtonTabbedPane ncbtPane = EditApp.App.jol.getCardPanel();
        ncbtPane.flyInAll(this.dDesktop);
        NCButtonTabbedPane dbgPane = DebuggerMainPanel.This().getTabbedPane();
        dbgPane.flyInAll(this.dDesktop);
    }

    public DockingDesktop getDesktop() {
        return this.dDesktop;
    }

    protected Image getMenuImage() {
        String email = ("" + EditApp.App.getWorkspaceProperty("License.Email")).toString().toLowerCase();
        String key = ("" + EditApp.App.getWorkspaceProperty("License.Key")).toLowerCase();
        if (key.endsWith("pe")) {
            return NCApplication.GetImage("/de/netcomputing/swingx/images/menugold.gif");
        }
        if (!email.equals("unknown")) {
            return NCApplication.GetImage("/de/netcomputing/swingx/images/menureg.gif");
        }
        return NCApplication.GetImage("/de/netcomputing/swingx/images/menudef.gif");
    }

    public void splitContainer(IDockingContainer parent, DockingComponentWrapper dcWrapper) {
    }

    public boolean canCloseComponent(DockingComponentWrapper dcWrapper) {
        return true;
    }

    public void componentClosed(DockingComponentWrapper dcWrapper) {
    }

    public void componentMinimized(DockingComponentWrapper dcWrapper) {
    }

    public void componentDeMinimized(DockingComponentWrapper dcWrapper) {
    }

    public void selectionChanged(DockingComponentWrapper dcOldWrapperPrimary, DockingComponentWrapper dcOldWrapperSecondary) {
    }

    public void componentCreated(DockingComponentWrapper dcWrapper) {
    }

    public void componentMoved(DockingComponentWrapper dcWrapper) {
    }

    public void storeGlobalProperty(PropWriter pw) throws IOException {
        if (this.getIsAutoSaveEnabled()) {
            this.menuSaveConfig();
        }
        DataOutputStream out = pw.createStream("DockingHostLastLayout");
        out.writeUTF(this.currentConfig);
        ObjectOutputStream oos = new ObjectOutputStream(pw.createStream("DockingHostLayoutCache"));
        oos.writeObject(DockingContainer.layoutCache);
        oos.close();
        oos = new ObjectOutputStream(pw.createStream("DockingHostLayoutMap"));
        oos.writeObject(this.configs);
        oos.close();
        out = pw.createStream("DockingHostMisc");
        out.writeBoolean(this.doAutoSaveItem.isSelected());
        out.writeBoolean(this.doAutoSwitchItem.isSelected());
    }

    public void storeProperty(PropWriter pw) throws IOException {
    }

    public void loadProperty(PropWriter pw) throws IOException {
    }

    public void loadGlobalProperty(final PropWriter pw) throws IOException {
        ObjectInputStream ois;
        this.dDesktop.setIgnoreRepaint(true);
        try {
            this.flyInAll();
            this.dDesktop.clear();
            DataInputStream in = pw.getStream("DockingHostLastLayout");
            this.currentConfig = in.readUTF();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            this.currentConfig = "Edit";
        }
        try {
            ois = new ObjectInputStream(pw.getStream("DockingHostLayoutCache"));
            DockingContainer.layoutCache = (HashMap)ois.readObject();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        try {
            ois = new ObjectInputStream(pw.getStream("DockingHostLayoutMap"));
            this.configs = (HashMap)ois.readObject();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            this.dDesktop.setLayoutConfiguration(defaultLayout, null);
        }
        try {
            this.setConfig(this.currentConfig);
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            this.setConfig("Edit");
        }
        this.toRunAfterInit1.add(new Runnable(){

            public void run() {
                try {
                    DataInputStream in = pw.getStream("DockingHostMisc");
                    DockingEditorHost.this.doAutoSaveItem.setSelected(in.readBoolean());
                    DockingEditorHost.this.doAutoSwitchItem.setSelected(in.readBoolean());
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                    DockingEditorHost.this.setConfig("Edit");
                    DockingEditorHost.this.doAutoSaveItem.setSelected(true);
                    DockingEditorHost.this.doAutoSwitchItem.setSelected(false);
                }
                DockingEditorHost.this.saveItem.setEnabled(!DockingEditorHost.this.doAutoSaveItem.isSelected());
            }
        });
    }

    public void notifyInitComplete() {
        int i;
        this.dDesktop.getCollapsedPanelBar().setStartMenu(this.dDesktop.createStartMenu());
        if (this.toRunAfterInit != null && this.toRunAfterInit.size() > 0) {
            i = 0;
            while (i < this.toRunAfterInit.size()) {
                try {
                    ((Runnable)this.toRunAfterInit.get(i)).run();
                }
                catch (RuntimeException ex) {
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
                ++i;
            }
            this.toRunAfterInit.clear();
        }
        i = 0;
        while (i < this.toRunAfterInit1.size()) {
            try {
                ((Runnable)this.toRunAfterInit1.get(i)).run();
            }
            catch (RuntimeException ex) {
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.configItems.length) {
            if (this.configItems[i2].getLabel().equals(this.currentConfig)) {
                this.configItems[i2].setSelected(true);
            }
            ++i2;
        }
        DebuggerMainPanel.This().getTabbedPane().setSelectedIndex(0);
        DebuggerMainPanel.This().getTabbedPane().invalidate();
        if (this.toRunAfterInit != null) {
            this.toRunAfterInit.clear();
        }
        if (this.toRunAfterInit1 != null) {
            this.toRunAfterInit1.clear();
        }
        this.dDesktop.invalidate();
        this.dDesktop.validate();
        this.dDesktop.repaint();
    }

    public void notifyTopComponentAdded() {
        this.dDesktop.setLayoutConfiguration(defaultLayout, null);
        EditApp.App.jol.getCardPanel().setCpBar(this.dDesktop.getCollapsedPanelBar());
    }

    public JComponent layoutSplitPanes(JComponent trees, JComponent helpAgent, JComponent output, JComponent editors) {
        this.output = output;
        this.editors = editors;
        this.trees = trees;
        this.agent = helpAgent;
        return this.dDesktop;
    }

    public void toggleCompilePanel() {
        System.out.println("COMPILEPANELVISIBLE:" + this.isCompilePanelVisible());
        this.showCompilePanel(!this.isCompilePanelVisible());
    }

    boolean isCompilePanelVisible() {
        DockingComponentWrapper cont = DockingContainer.findDockingWrapper(this.output);
        return cont == null || !this.dDesktop.getCollapsedPanelBar().isCollapsed(cont);
    }

    public void showCompilePanel(boolean b) {
        if (this.isCompilePanelVisible() == b) {
            return;
        }
        if (!b) {
            this.compileConf = this.dDesktop.getCenterDock().saveLayout();
            DockingContainer cont = DockingContainer.findDockingContainer(this.output);
            if (cont != null) {
                int i = 0;
                while (i < cont.getDockedComponentCount()) {
                    if (cont.getDockedComponent(i).isVisible() && cont.getDockedComponent(i).getTitleBar() != null) {
                        this.dDesktop.setMinimized(cont.getDockedComponent(i), true);
                    }
                    ++i;
                }
            } else {
                this.dDesktop.setMinimized(this.output, !b);
            }
        } else {
            DockingContainer cont = DockingContainer.findDockingContainer(this.output);
            if (cont != null) {
                int i = 0;
                while (i < cont.getDockedComponentCount()) {
                    if (!cont.getDockedComponent(i).isVisible() && cont.getDockedComponent(i).getTitleBar() != null) {
                        this.dDesktop.setMinimized(cont.getDockedComponent(i), false);
                    }
                    ++i;
                }
            } else {
                this.dDesktop.setMinimized(this.output, !b);
            }
            if (this.compileConf != null) {
                this.dDesktop.getCenterDock().loadLayout(this.compileConf);
            }
        }
    }

    public void toggleTreePanel() {
        this.showTreePanel(!this.isTreeShowing());
    }

    public boolean isTreeShowing() {
        DockingComponentWrapper cont = DockingContainer.findDockingWrapper(this.trees);
        return cont == null || !this.dDesktop.getCollapsedPanelBar().isCollapsed(cont);
    }

    public void showTreePanel(boolean b) {
        if (this.isTreeShowing() == b) {
            return;
        }
        this.dDesktop.setMinimized(this.trees, !b);
    }

    public void toggleHelpAgent() {
        this.showHelpAgent(!this.isAgentShowing());
    }

    boolean isAgentShowing() {
        DockingComponentWrapper cont = DockingContainer.findDockingWrapper(this.agent);
        return cont == null || !this.dDesktop.getCollapsedPanelBar().isCollapsed(cont);
    }

    public void showHelpAgent(boolean b) {
        if (this.isAgentShowing() == b) {
            return;
        }
        this.dDesktop.setMinimized(this.agent, !b);
    }
}

