/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.debugger;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.connect.Connector;
import de.netcomputing.anyj.debugger.DebuggerConnectGUI;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.runtime.ApplicationHelper;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class DebuggerConnect
extends JPanel {
    NCButton applyBtn;
    JTable table;
    JComboBox connectors;
    JTextArea description;
    NCButton cancelBtn;
    List conList;
    DefaultTableModel tmodel;
    String mainClass = "mc";
    String vmCline = "vmc";
    String args = "args";
    String javaHome = "home";
    public static HashMap defVals = new HashMap();
    Connector result;
    Map resultMap;
    Vector modelShadow = new Vector();

    public DebuggerConnect() {
        this.initGui();
        this.tmodel = new DefaultTableModel(new Object[]{"KEY", "VALUE"}, 10);
        this.table.setModel(this.tmodel);
        this.table.getColumn("VALUE").setCellEditor(null);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DebuggerConnect.this.tableSelChanged();
            }
        });
    }

    public Connector getResult() {
        return this.result;
    }

    public void tableSelChanged() {
        int i = this.table.getSelectedRow();
        if (i >= 0) {
            Object sel = this.modelShadow.get(i);
            this.description.setText(((Connector.Argument)sel).description());
            if (sel instanceof Connector.SelectedArgument) {
                List val = ((Connector.SelectedArgument)sel).choices();
                String des = this.description.getText() + " \nPossible Values: ";
                int n = 0;
                while (n < val.size()) {
                    des = des + val.get(n) + ", ";
                    ++n;
                }
                this.description.setText(des);
            } else if (sel instanceof Connector.BooleanArgument) {
                String des = this.description.getText() + " \nPossible Values: true, false";
                this.description.setText(des);
            }
        }
    }

    public void initGui() {
        new DebuggerConnectGUI().createGui(this);
    }

    public void setConnectors(List l) {
        this.conList = l;
        int n = 0;
        while (n < l.size()) {
            this.connectors.addItem(((Connector)l.get(n)).name());
            ++n;
        }
    }

    public void setStartUpData(String mainClass, String vmCline, String args, String javaHome) {
        this.mainClass = mainClass;
        this.vmCline = vmCline;
        this.args = args;
        this.javaHome = javaHome;
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        this.result = null;
        this.getTopLevelAncestor().hide();
        ((Window)this.getTopLevelAncestor()).dispose();
    }

    public boolean applyValue(Connector con, Connector.Argument arg, String val) {
        if (arg instanceof Connector.StringArgument) {
            arg.setValue(val);
        } else if (arg instanceof Connector.BooleanArgument) {
            arg.setValue(val);
        } else if (arg instanceof Connector.StringArgument) {
            arg.setValue(val);
        } else if (arg instanceof Connector.IntegerArgument) {
            arg.setValue(val);
        } else if (arg instanceof Connector.SelectedArgument) {
            arg.setValue(val);
        } else {
            arg.setValue(val);
        }
        return true;
    }

    public void applyBtn_actionPerformed(ActionEvent var0) {
        int i = this.connectors.getSelectedIndex();
        Connector con = (Connector)this.conList.get(i);
        Map argMap = con.defaultArguments();
        int n = 0;
        while (n < this.tmodel.getRowCount()) {
            String key = (String)this.tmodel.getValueAt(n, 0);
            System.out.println(key + "=" + this.tmodel.getValueAt(n, 1));
            Connector.Argument arg = (Connector.Argument)argMap.get(key);
            this.applyValue(con, arg, (String)this.tmodel.getValueAt(n, 1));
            defVals.put(key, (String)this.tmodel.getValueAt(n, 1));
            ++n;
        }
        this.result = con;
        this.resultMap = argMap;
        this.getTopLevelAncestor().setVisible(false);
        ((Window)this.getTopLevelAncestor()).dispose();
    }

    public Map getResultMap() {
        return this.resultMap;
    }

    public void connectors_itemStateChanged(ItemEvent var0) {
        int i = this.connectors.getSelectedIndex();
        if (i >= 0) {
            this.description.setText(((Connector)this.conList.get(i)).description());
            this.fillTable((Connector)this.conList.get(i));
        }
    }

    void fillTable(Connector connector) {
        this.tmodel.setRowCount(0);
        this.modelShadow.setSize(0);
        Map map = connector.defaultArguments();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object keyObj = it.next();
            String key = keyObj.toString();
            String defVal = ((Connector.Argument)map.get(keyObj)).value().toString();
            if ("home".equals(key)) {
                defVal = this.javaHome;
            } else if ("options".equals(key)) {
                defVal = this.vmCline;
            } else if ("main".equals(key)) {
                defVal = this.mainClass + " " + this.args;
            } else if (!"vmexec".equals(key) && defVals.get(key) != null) {
                defVal = (String)defVals.get(key);
            }
            this.tmodel.addRow(new Object[]{key, defVal});
            this.modelShadow.add((Connector.Argument)map.get(keyObj));
        }
        this.tmodel.fireTableDataChanged();
    }

    public static void main(String[] args) {
        JDialog conDiag = new JDialog();
        DebuggerConnect con = new DebuggerConnect();
        conDiag.getContentPane().add(con);
        con.setConnectors(Bootstrap.virtualMachineManager().allConnectors());
        conDiag.pack();
        conDiag.show();
    }
}

