/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.debugger;

import com.sun.jdi.LocalVariable;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import de.netcomputing.anyj.debugger.DebuggerItem;

public class LocalVarItem
extends DebuggerItem {
    LocalVariable var;
    StackFrame frame;
    Value cachedValue;
    String cachedDisplay;

    public LocalVarItem(LocalVariable ref, StackFrame where) {
        this.var = ref;
        this.frame = where;
    }

    protected Value getValue() {
        if (this.cachedValue == null) {
            try {
                this.cachedValue = this.frame.getValue(this.var);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return this.cachedValue;
    }

    public String getDisplayString() {
        try {
            if (this.cachedDisplay == null) {
                this.cachedDisplay = this.createDisplayString();
            }
            return this.cachedDisplay;
        }
        catch (Throwable ex) {
            return "invalid";
        }
    }

    public String createDisplayString() {
        try {
            return this.var.name() + " (" + this.var.type().name() + ") = " + this.frame.getValue(this.var);
        }
        catch (Exception ex) {
            try {
                return this.var.name() + " (" + this.var.typeName() + ") = " + this.frame.getValue(this.var);
            }
            catch (Exception ex1) {
                return "Exc:" + ex1.getClass().getName() + " " + ex1.getMessage();
            }
        }
    }

    public String getVarName() {
        return this.var.name();
    }
}

