/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.debugger.communication;

import Jxe.DocumentStream;
import de.netcomputing.anyj.jwidgets.BasicListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.Tracer;
import java.awt.Image;
import java.io.File;
import jxeplugins.IJEBreakPoint;

public class BreakPoint
extends BasicListItem
implements IJEBreakPoint {
    String clazz;
    String file;
    int line;
    boolean enabled = true;
    String jspFile;
    public static Image enabIm;
    public static Image disabIm;

    public BreakPoint(int li, File f) {
        if (f.getName().endsWith(".java")) {
            String clazz = DocumentStream.ScanPackage(f) + "." + f.getName().substring(0, f.getName().length() - ".java".length());
            if (clazz.startsWith(".")) {
                clazz = clazz.substring(1);
            }
            this.init(clazz, f.getAbsolutePath(), li);
        } else {
            this.clazz = "JSP";
            this.init("JSP", f.getAbsolutePath(), li);
        }
    }

    void init(String cl, String _file, int li) {
        this.clazz = cl;
        if (this.clazz != null) {
            this.clazz = this.clazz.trim();
        }
        this.line = li;
        this.file = _file;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getLine() {
        return this.line;
    }

    public String getFile() {
        return this.file;
    }

    public String getClazz() {
        return this.clazz;
    }

    public int hashCode() {
        return this.file.hashCode() ^ this.line;
    }

    public boolean equals(Object o) {
        if (o instanceof BreakPoint) {
            return this.clazz.equals(((BreakPoint)o).getClazz()) && this.getLine() == ((BreakPoint)o).getLine();
        }
        return false;
    }

    public String toString() {
        return "" + this.clazz + "," + this.line + ", " + this.file;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public void setFile(String fpath) {
        this.file = fpath;
    }

    public String getDisplayString() {
        return this.toString();
    }

    public String getRelaticeJSPFile() {
        try {
            if (this.jspFile == null) {
                String s = this.getFile();
                File f = new File(s);
                while (!f.getParentFile().getName().equals("webapps")) {
                    f = f.getParentFile();
                }
                this.jspFile = s.substring(f.getAbsolutePath().length());
                Tracer.This.println("JSPRELFILE:" + this.jspFile);
            }
            return this.jspFile;
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            return null;
        }
    }

    public Image getImage() {
        if (enabIm == null) {
            enabIm = NCApplication.GetImage("/images/flagred.gif");
        }
        if (disabIm == null) {
            disabIm = NCApplication.GetImage("/de/netcomputing/anyj/images/flaggray.gif");
        }
        if (this.getEnabled()) {
            return enabIm;
        }
        return disabIm;
    }
}

