/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.filenodes;

import de.netcomputing.anyj.filenodes.BasicFileNode;
import de.netcomputing.anyj.filenodes.FileType;
import de.netcomputing.anyj.filenodes.IDocPos;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.Tracer;
import de.netcomputing.util.xml.Node;
import de.netcomputing.util.xml.XMLIterator;
import java.awt.Image;

public class XmlFileNode
extends BasicFileNode
implements IDocPos {
    Node root;
    String display = null;

    public XmlFileNode(Node root, FileType type, String fi) {
        super(type, fi);
        this.root = root;
    }

    public String getDisplayString() {
        if (this.display == null) {
            try {
                this.display = this.root.getName();
                XMLIterator it = this.root.getAttributeNames();
                while (it.hasMoreElements()) {
                    String att = (String)it.nextElement();
                    this.display = this.display + " " + att + "=" + this.root.getField(att, "\"\"");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
                this.display = "Parse Error";
            }
        }
        return this.display;
    }

    public Image getImage() {
        return NCApplication.GetImage("/images/filetypes/xml.gif");
    }

    public boolean hasContent() {
        if (this.root == null) {
            return false;
        }
        return this.root.getSubnodeCount() > 0;
    }

    public IListItem[] contents() {
        try {
            int max = this.root.getSubnodeCount();
            IListItem[] il = new IListItem[max];
            int n = 0;
            while (n < max) {
                il[n] = new XmlFileNode((Node)this.root.getSubnode(n), this.type, this.file);
                ++n;
            }
            return il;
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            return new IListItem[0];
        }
    }

    public String getPath() {
        return this.file;
    }

    public int getLine() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getLine();
    }

    public int getCol() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getCol();
    }
}

