/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.Tracer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ArrayTool {
    static int RADIX = 24;
    public static String INTEGER = "Integer".intern();
    public static String NULL = "null".intern();
    public static String ARRAY = "Array".intern();
    public static String BOOLEAN = "Boolean".intern();
    public static String COLOR = "Color".intern();
    public static String FONT = "Font".intern();
    public static String RECTANGLE = "Rectangle".intern();
    public static String DIMENSION = "Dimension".intern();
    public static String STRING = "String".intern();
    static /* synthetic */ Class class$java$lang$Object;

    public static void ArrayPrinter(Object o, int depth) {
        if (o instanceof Object[]) {
            int n = 0;
            while (n < ((Object[])o).length) {
                ArrayTool.ArrayPrinter(((Object[])o)[n], depth + 1);
                ++n;
            }
        } else {
            int n = 0;
            while (n < depth) {
                Tracer.This.print(" ");
                ++n;
            }
        }
    }

    static Object Compress(Object o, Hashtable ctab, int[] codeBase) {
        if (o instanceof Object[]) {
            int n = 0;
            while (n < ((Object[])o).length) {
                ((Object[])o)[n] = ArrayTool.Compress(((Object[])o)[n], ctab, codeBase);
                ++n;
            }
            return o;
        }
        if (ctab.containsKey(o)) {
            return ctab.get(o);
        }
        ctab.put(o, new Integer(codeBase[0]));
        codeBase[0] = codeBase[0] + 1;
        return ctab.get(o);
    }

    public static Object[] EncodeArray(Object o) {
        Object[] result = null;
        if (o == null) {
            Object[] sa = new Object[]{"null"};
            result = sa;
        } else if (o instanceof Object[]) {
            Object[] sa = new Object[((Object[])o).length + 1];
            sa[0] = "Array";
            int n = 1;
            while (n < sa.length) {
                sa[n] = ArrayTool.EncodeArray(((Object[])o)[n - 1]);
                ++n;
            }
            result = sa;
        } else if (o instanceof Boolean) {
            Object[] sa = new Object[]{"Boolean", o.toString()};
            result = sa;
        } else if (o instanceof Dimension) {
            Object[] sa = new Object[]{"Dimension", Integer.toString(((Dimension)o).width), Integer.toString(((Dimension)o).height)};
            result = sa;
        } else if (o instanceof Rectangle) {
            Object[] sa = new Object[]{"Rectangle", Integer.toString(((Rectangle)o).x), Integer.toString(((Rectangle)o).y), Integer.toString(((Rectangle)o).width), Integer.toString(((Rectangle)o).height)};
            result = sa;
        } else if (o instanceof Font) {
            Object[] sa = new Object[]{"Font", ((Font)o).getName(), Integer.toString(((Font)o).getStyle()), Integer.toString(((Font)o).getSize())};
            result = sa;
        } else if (o instanceof Color) {
            Object[] sa = new Object[]{"Color", Integer.toString(((Color)o).getRed()), Integer.toString(((Color)o).getGreen()), Integer.toString(((Color)o).getBlue())};
            result = sa;
        } else if (o instanceof Integer) {
            Object[] sa = new Object[]{"Integer", ((Integer)o).toString()};
            result = sa;
        } else if (o instanceof String) {
            Object[] sa = new Object[]{"String", (String)o};
            result = sa;
        }
        return result;
    }

    public static Object DecodeArray(Object[] obj) {
        Object result = null;
        String type = ((String)obj[0]).intern();
        if (type == ARRAY) {
            Object[] res = new Object[obj.length - 1];
            int n = 1;
            while (n < obj.length) {
                res[n - 1] = ArrayTool.DecodeArray((Object[])obj[n]);
                ++n;
            }
            result = res;
        } else if (type == NULL) {
            result = null;
        } else if (type == DIMENSION) {
            result = new Dimension(Integer.parseInt((String)obj[1]), Integer.parseInt((String)obj[2]));
        } else if (type == RECTANGLE) {
            result = new Rectangle(Integer.parseInt((String)obj[1]), Integer.parseInt((String)obj[2]), Integer.parseInt((String)obj[3]), Integer.parseInt((String)obj[4]));
        } else if (type == FONT) {
            result = new Font((String)obj[1], Integer.parseInt((String)obj[2]), Integer.parseInt((String)obj[3]));
        } else if (type == COLOR) {
            result = new Color(Integer.parseInt((String)obj[1]), Integer.parseInt((String)obj[2]), Integer.parseInt((String)obj[3]));
        } else if (type == BOOLEAN) {
            result = new Boolean(((String)obj[1]).equals("true"));
        } else if (type == STRING) {
            result = (String)obj[1];
        } else if (type == INTEGER) {
            result = new Integer(Integer.parseInt((String)obj[1]));
        }
        return result;
    }

    public static Object[] LoadFromString(String data) {
        Object[] result = null;
        try {
            StringBufferInputStream inp = new StringBufferInputStream(data);
            DataInputStream dis = new DataInputStream(inp);
            String[] table = ArrayTool.LoadHTab(dis);
            result = ArrayTool.LoadArray(dis, table);
            dis.close();
            inp.close();
        }
        catch (IOException e) {
            e.printStackTrace(Tracer.This);
        }
        return result;
    }

    public static Object[] LoadArrayFromFile(String fileName) {
        Object[] result = null;
        try {
            File inputFile = new File(fileName);
            FileInputStream inp = new FileInputStream(inputFile);
            DataInputStream dis = new DataInputStream(new BufferedInputStream(inp, 5000));
            String[] table = ArrayTool.LoadHTab(dis);
            result = ArrayTool.LoadArray(dis, table);
            dis.close();
            inp.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(Tracer.This);
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
        }
        return result;
    }

    public static Object[] LoadArrayFromAbsolutePath(String fileName) {
        Object[] result = null;
        try {
            File InputFile = new File(fileName);
            FileInputStream inp = new FileInputStream(InputFile);
            DataInputStream dis = new DataInputStream(inp);
            if (JWidgetsUtil.DEBUG) {
                Tracer.This.println("loading Array from " + fileName + " input:" + inp + " dis:" + dis);
            }
            String[] table = ArrayTool.LoadHTab(dis);
            result = ArrayTool.LoadArray(dis, table);
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace(Tracer.This);
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
        }
        return result;
    }

    public static Object[] LoadArray(File file2) {
        try {
            DataInputStream dis = null;
            Tracer.This.println("JIB LOCATION resource:" + file2.getPath().replace(File.separatorChar, '/'));
            Tracer.This.println("   0:/jibs/" + file2.getName().toLowerCase());
            InputStream in = (class$java$lang$Object == null ? (class$java$lang$Object = ArrayTool.class$("java.lang.Object")) : class$java$lang$Object).getResourceAsStream("/jibs/" + file2.getName().toLowerCase());
            if (in == null) {
                in = (class$java$lang$Object == null ? (class$java$lang$Object = ArrayTool.class$("java.lang.Object")) : class$java$lang$Object).getResourceAsStream("/" + file2.getPath().replace(File.separatorChar, '/'));
            }
            if (in != null) {
                dis = new DataInputStream(in);
            }
            if (dis == null) {
                dis = !file2.exists() ? new DataInputStream((class$java$lang$Object == null ? (class$java$lang$Object = ArrayTool.class$("java.lang.Object")) : class$java$lang$Object).getResourceAsStream(file2.getName())) : new DataInputStream(new FileInputStream(file2));
            }
            String[] table = ArrayTool.LoadHTab(dis);
            Object[] result = ArrayTool.LoadArray(dis, table);
            dis.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
            return null;
        }
    }

    public static Object[] LoadArray(String fileName) {
        Object[] result = null;
        Object url = null;
        String orgFile = fileName;
        try {
            if (NCApplication.GetDocumentBase() != null) {
                fileName = NCApplication.GetDocumentBase().getFile() + "/" + fileName;
                fileName = fileName.substring(1);
            }
            DataInputStream dis = null;
            Tracer.This.println("JIB LOCATION resource:" + fileName.replace(File.separatorChar, '/'));
            String fi0 = fileName.toLowerCase();
            int i = fi0.lastIndexOf(47);
            if (i >= 0) {
                fi0 = fi0.substring(i + 1);
            }
            if ((i = fi0.lastIndexOf(92)) >= 0) {
                fi0 = fi0.substring(i + 1);
            }
            Tracer.This.println("  1:/jibs/" + fi0);
            InputStream inp = fi0.endsWith(".gif") ? (class$java$lang$Object == null ? (class$java$lang$Object = ArrayTool.class$("java.lang.Object")) : class$java$lang$Object).getResourceAsStream("/images/" + fi0) : (class$java$lang$Object == null ? (class$java$lang$Object = ArrayTool.class$("java.lang.Object")) : class$java$lang$Object).getResourceAsStream("/jibs/" + fi0);
            if (inp == null) {
                inp = (class$java$lang$Object == null ? (class$java$lang$Object = ArrayTool.class$("java.lang.Object")) : class$java$lang$Object).getResourceAsStream("/" + fileName.replace(File.separatorChar, '/'));
            }
            if (inp == null) {
                fileName.replace('/', '\\');
                if (new File(fileName).exists()) {
                    inp = new FileInputStream(fileName);
                }
            }
            dis = new DataInputStream(inp);
            if (JWidgetsUtil.DEBUG) {
                Tracer.This.println("loading Array from " + url + " fname " + fileName + " input:" + inp + " dis:" + dis);
            }
            String[] table = ArrayTool.LoadHTab(dis);
            result = ArrayTool.LoadArray(dis, table);
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace(Tracer.This);
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
        }
        return result;
    }

    static Object[] LoadArray(DataInputStream dis, String[] table) {
        Vector<Object> inner = new Vector<Object>();
        try {
            StringBuffer s = new StringBuffer(10);
            block7: while (true) {
                char c = (char)dis.readByte();
                switch (c) {
                    case '{': {
                        Object[] o = ArrayTool.LoadArray(dis, table);
                        if (o == null) continue block7;
                        inner.addElement(o);
                        continue block7;
                    }
                    case '}': {
                        Object[] result = new Object[inner.size()];
                        int n = 0;
                        while (n < result.length) {
                            result[n] = inner.elementAt(n);
                            ++n;
                        }
                        return result;
                    }
                }
                int idx = 0;
                s.setLength(0);
                do {
                    s.append(c);
                } while ((c = (char)dis.readByte()) != '~');
                int n = s.length() - 1;
                while (n >= 0) {
                    idx = idx * RADIX + (s.charAt(n) - 65);
                    --n;
                }
                if (s.length() == 0) continue;
                inner.addElement(table[idx]);
            }
        }
        catch (EOFException eof) {
            return (Object[])inner.elementAt(0);
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
            return null;
        }
    }

    static void SaveHTab(Hashtable ht, DataOutputStream fos) throws IOException {
        Enumeration en = ht.keys();
        Object[] arr = new Object[ht.size()];
        while (en.hasMoreElements()) {
            String s = (String)en.nextElement();
            arr[((Integer)ht.get((Object)s)).intValue()] = s;
        }
        int n = 0;
        while (n < arr.length) {
            fos.writeBytes(arr[n] + "~");
            ++n;
        }
        fos.writeBytes("~");
    }

    /*
     * WARNING - void declaration
     */
    static String[] LoadHTab(DataInputStream dis) {
        Vector<String> v = new Vector<String>(50);
        try {
            StringBuffer s = new StringBuffer(100);
            while (true) {
                char c;
                if ((c = (char)dis.readByte()) != '~') {
                    void var3_4;
                    s.append((char)var3_4);
                    continue;
                }
                if (s.length() != 0) {
                    v.addElement(s.toString());
                    s.setLength(0);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
        }
        String[] result = new String[v.size()];
        int n = 0;
        while (n < result.length) {
            result[n] = (String)v.elementAt(n);
            ++n;
        }
        return result;
    }

    public static void StoreArray(Object[] obj, String fileName) {
        try {
            File outputFile = new File(fileName);
            FileOutputStream fils = new FileOutputStream(outputFile);
            DataOutputStream fos = new DataOutputStream(fils);
            Hashtable ht = new Hashtable(30);
            int[] code = new int[]{0};
            ArrayTool.Compress(obj, ht, code);
            ArrayTool.SaveHTab(ht, fos);
            ArrayTool.StoreArray((Object)obj, fos);
            fos.close();
            fils.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(Tracer.This);
        }
        catch (IOException e) {
            e.printStackTrace(Tracer.This);
        }
    }

    static void StoreArray(Object o, DataOutputStream fos) {
        try {
            if (o instanceof Object[]) {
                fos.writeBytes("{");
                int n = 0;
                while (n < ((Object[])o).length) {
                    ArrayTool.StoreArray(((Object[])o)[n], fos);
                    ++n;
                }
                fos.writeBytes("}");
            } else {
                int value = (Integer)o;
                StringBuffer s = new StringBuffer();
                do {
                    s.append((char)(65 + value % RADIX));
                } while ((value /= RADIX) > 0);
                fos.writeBytes(s.toString() + "~");
            }
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
        }
    }

    public static Object[] DeepArrayCopy(Object[] o) {
        Object[] result = new Object[o.length];
        int n = 0;
        while (n < o.length) {
            result[n] = o[n] instanceof Object[] ? ArrayTool.DeepArrayCopy((Object[])o[n]) : o[n];
            ++n;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

