/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.NCPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

class ButtonChoice
extends NCPanel {
    Vector objects = new Vector();
    int selection;
    int buttonHeight;
    int buttonWidth;
    Image buffer;

    public ButtonChoice() {
        this.addMouseListener(new me());
        this.addMouseMotionListener(new me());
    }

    Object selectedObject() {
        if (this.selection >= 0) {
            return this.objects.elementAt(this.selection);
        }
        return null;
    }

    public void removeAll() {
        this.objects = new Vector();
    }

    void clearSelection() {
        this.selection = -1;
    }

    String getSelectionLabelAt(int n) {
        return this.objects.elementAt(n).toString();
    }

    int computeMaxWidth() {
        int max = this.buttonWidth;
        int n = 0;
        while (n < this.objects.size()) {
            max = Math.max(this.getFontMetrics(this.getFont()).stringWidth(this.objects.elementAt(n).toString()), max);
            ++n;
        }
        return max + 12;
    }

    public void setSelection(int n) {
        if (n >= this.objects.size()) {
            return;
        }
        int oldsel = Math.max(0, this.selection);
        this.selection = n = Math.max(0, n);
        this.paintBuffer(Math.min(n, oldsel), Math.max(n, oldsel) + 1);
    }

    public void adjustScreenPos() {
        if (this.selection == -1) {
            return;
        }
        Point p = this.getLocationOnScreen();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int curr = p.y + this.buttonHeight * this.selection;
        if (curr + this.buttonHeight > d.height) {
            this.getParent().setLocation(p.x, p.y + d.height - curr - this.buttonHeight);
        } else if (curr < 0) {
            this.getParent().setLocation(p.x, p.y - curr);
        }
    }

    public void build(int max) {
        if (this.getFont() == null) {
            return;
        }
        this.buttonWidth = max;
        this.buttonWidth = this.computeMaxWidth();
        this.buttonHeight = this.getFontMetrics(this.getFont()).getHeight() + 4;
    }

    public void paintBuffer(int start, int end) {
        Dimension d = this.preferredSize();
        if (this.buffer == null || this.buffer.getWidth(this) != d.width || this.buffer.getHeight(this) != d.height) {
            if (this.buffer != null) {
                this.buffer.flush();
            }
            this.buffer = this.createImage(d.width, d.height);
            start = 0;
            end = this.objects.size();
        }
        if (this.buffer == null) {
            return;
        }
        Graphics bg = this.buffer.getGraphics();
        d = new Dimension(this.buttonWidth, this.buttonHeight);
        --d.width;
        --d.height;
        bg.translate(0, this.buttonHeight * start);
        int n = start;
        while (n < end) {
            bg.setColor(this.getBackground());
            bg.fillRect(0, 0, this.buttonWidth, this.buttonHeight);
            bg.setColor(JWColor.For("label.text"));
            int th = bg.getFontMetrics().getMaxAscent() - 2;
            bg.drawString(this.objects.elementAt(n).toString(), 6, (this.buttonHeight - th) / 2 + th);
            if (n != this.selection) {
                bg.setColor(JWColor.For("background.++"));
                bg.drawLine(0, 0, d.width, 0);
                bg.drawLine(0, 0, 0, d.height);
                bg.setColor(JWColor.For("background"));
                bg.drawLine(1, d.height - 1, d.width - 1, d.height - 1);
                bg.drawLine(d.width - 1, d.height - 1, d.width - 1, 1);
                bg.setColor(Color.black);
                bg.drawLine(0, d.height, d.width, d.height);
                bg.drawLine(d.width, d.height, d.width, 0);
            } else {
                bg.setColor(Color.black);
                bg.drawLine(0, 0, d.width, 0);
                bg.drawLine(0, 0, 0, d.height);
                bg.setColor(JWColor.For("background"));
                bg.drawLine(1, 1, d.width - 1, 1);
                bg.drawLine(1, 1, 1, d.height - 1);
                bg.setColor(JWColor.For("background.++"));
                bg.drawLine(0, d.height, d.width, d.height);
                bg.drawLine(d.width, d.height, d.width, 0);
            }
            bg.translate(0, this.buttonHeight);
            ++n;
        }
        ++d.width;
        ++d.height;
        bg.dispose();
    }

    public void jwPaint(Graphics g) {
        if (this.buffer == null || this.buffer.getWidth(this) != this.buttonWidth) {
            this.paintBuffer(0, this.objects.size());
        }
        g.drawImage(this.buffer, 0, 0, this);
    }

    public Dimension preferredSize() {
        if (this.buttonWidth == 0 || this.buttonHeight == 0) {
            this.buttonWidth = this.computeMaxWidth();
            this.buttonHeight = this.getFontMetrics(this.getFont()).getHeight() + 4;
        }
        return new Dimension(this.buttonWidth, this.buttonHeight * this.objects.size());
    }

    class me
    extends MouseAdapter
    implements MouseMotionListener {
        me() {
        }

        public void mousePressed(MouseEvent e) {
            ButtonChoice.this.setSelection(e.getY() / ButtonChoice.this.buttonHeight);
            ButtonChoice.this.repaint();
            e.consume();
        }

        public void mouseReleased(MouseEvent e) {
            ButtonChoice.this.binder().notifyTargets(ButtonChoice.this.selection);
            e.consume();
        }

        public void mouseDragged(MouseEvent e) {
            this.mousePressed(e);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

