/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import JCollections.JSet;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;

public class DirDiffResult {
    public static final int DIFF = 68;
    public static final int ADDED = 43;
    public static final int REMOVED = 45;
    public static final int NONE = 32;
    String diffRoot;
    String diffBRoot;
    JSet added;
    JSet removed;
    JSet diffs;
    FilenameFilter filter;
    JSet dirsWithChanges;

    public DirDiffResult(String diffRoot, String diffBRoot, JSet added, JSet removed, JSet diffs, FilenameFilter filter) {
        this.diffRoot = diffRoot;
        this.diffBRoot = diffBRoot;
        this.added = added;
        this.removed = removed;
        this.diffs = diffs;
        this.filter = filter;
    }

    public JSet getDirsWithChanges() {
        if (this.dirsWithChanges == null) {
            File f;
            String nettoFile;
            this.dirsWithChanges = new JSet(100);
            Enumeration en = this.added.enumerate();
            while (en.hasMoreElements()) {
                nettoFile = (String)en.nextElement();
                f = new File(this.diffRoot + File.separator + nettoFile);
                while ((f = f.getParentFile()) != null) {
                    this.dirsWithChanges.add(f.getAbsolutePath());
                }
            }
            en = this.diffs.enumerate();
            while (en.hasMoreElements()) {
                nettoFile = (String)en.nextElement();
                f = new File(this.diffRoot + File.separator + nettoFile);
                while ((f = f.getParentFile()) != null) {
                    this.dirsWithChanges.add(f.getAbsolutePath());
                }
            }
            en = this.removed.enumerate();
            while (en.hasMoreElements()) {
                nettoFile = (String)en.nextElement();
                f = new File(this.diffRoot + File.separator + nettoFile);
                while ((f = f.getParentFile()) != null) {
                    this.dirsWithChanges.add(f.getAbsolutePath());
                }
            }
        }
        return this.dirsWithChanges;
    }

    public String getDiffBRoot() {
        return this.diffBRoot;
    }

    public boolean hasChange(String nettoDir) {
        return this.getDirsWithChanges().contains(this.diffRoot + nettoDir) || this.getDirsWithChanges().contains(this.diffBRoot + nettoDir);
    }

    public void setFilter(FilenameFilter filter) {
        this.filter = filter;
    }

    public FilenameFilter getFilter() {
        return this.filter;
    }

    public void setDiffRoot(String diffRoot) {
        this.diffRoot = diffRoot;
    }

    public String getDiffRoot() {
        return this.diffRoot;
    }

    public JSet getRemoved() {
        return this.removed;
    }

    public JSet getDiffs() {
        return this.diffs;
    }

    public JSet getAdded() {
        return this.added;
    }

    public int getDiffType(String netto) {
        if (this.diffs.contains(netto)) {
            return 68;
        }
        if (this.added.contains(netto)) {
            return 43;
        }
        if (this.removed.contains(netto)) {
            return 45;
        }
        return 32;
    }
}

