/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.Binder;
import de.netcomputing.anyj.jwidgets.IValue;
import de.netcomputing.anyj.jwidgets.IVisual;
import de.netcomputing.anyj.jwidgets.ImageVisual;
import de.netcomputing.anyj.jwidgets.JCanvas;
import de.netcomputing.anyj.jwidgets.JEvent;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWMenuBar;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import netcomputing.tools.Platforms;

public class GenericButton
extends JCanvas
implements IValue,
MouseListener,
MouseMotionListener {
    public static int INACTIVE = 0;
    public static int ACTIVE = 1;
    public static int GRAY = 2;
    public static int HIGHLIGHT = 3;
    public IVisual[] stateVisual = new IVisual[4];
    int currImg = INACTIVE;
    boolean pressed = false;
    boolean isPush = true;
    boolean isHighlighting = true;
    Binder binderButtonUp;
    Binder binderButtonDown;
    Dimension dim = new Dimension();

    public GenericButton() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void initVisuals() {
        if (this.stateVisual[INACTIVE] instanceof ImageVisual) {
            if (this.stateVisual[GRAY] == null) {
                this.stateVisual[GenericButton.GRAY] = ((ImageVisual)this.stateVisual[INACTIVE]).getClonedVisual("grayed");
            }
            if (this.stateVisual[HIGHLIGHT] == null) {
                this.stateVisual[GenericButton.HIGHLIGHT] = ((ImageVisual)this.stateVisual[INACTIVE]).getClonedVisual("highlighted");
            }
            if (this.stateVisual[ACTIVE] == null) {
                this.stateVisual[GenericButton.ACTIVE] = ((ImageVisual)this.stateVisual[INACTIVE]).getClonedVisual("pressed");
            }
        } else {
            if (this.stateVisual[GRAY] == null) {
                this.stateVisual[GenericButton.GRAY] = this.stateVisual[INACTIVE].clone("grayed");
            }
            if (this.stateVisual[HIGHLIGHT] == null) {
                this.stateVisual[GenericButton.HIGHLIGHT] = this.stateVisual[INACTIVE].clone("highlighted");
            }
            if (this.stateVisual[ACTIVE] == null) {
                this.stateVisual[GenericButton.ACTIVE] = this.stateVisual[INACTIVE].clone("pressed");
            }
        }
    }

    public boolean prefersDoubleBuffering() {
        return true;
    }

    public void resetVisuals() {
        this.stateVisual[GenericButton.ACTIVE] = null;
        this.stateVisual[GenericButton.HIGHLIGHT] = null;
        this.stateVisual[GenericButton.GRAY] = null;
        this.stateVisual[GenericButton.INACTIVE] = null;
    }

    public void init() {
        super.init();
        this.initVisuals();
        this.setLayout(null);
        this.setBackground(JWColor.For("background"));
    }

    public Binder binderButtonUp() {
        if (this.binderButtonUp == null) {
            this.binderButtonUp = new Binder(this);
        }
        return this.binderButtonUp;
    }

    public Binder binderButtonDown() {
        if (this.binderButtonDown == null) {
            this.binderButtonDown = new Binder(this);
        }
        return this.binderButtonDown;
    }

    public int intValue() {
        return this.pressed ? 1 : 0;
    }

    public double doubleValue() {
        return this.pressed ? 1.0 : 0.0;
    }

    public String stringValue() {
        return this.pressed ? "pressed" : "released";
    }

    public Object value() {
        return new Boolean(this.pressed);
    }

    public void setPressed(boolean b) {
        if (!this.isPush) {
            this.pressed = b;
            this.changeState();
        }
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isPushButton() {
        return this.isPush;
    }

    public void isPushButton(boolean b) {
        this.isPush = b;
    }

    public void disable() {
        this.changeState(GRAY);
        super.disable();
    }

    public void enable() {
        if (this.currImg == GRAY) {
            this.currImg = this.pressed ? ACTIVE : INACTIVE;
            this.repaint();
            super.enable();
        }
    }

    public void setEnabled(boolean b) {
        this.enable(b);
    }

    public void enable(boolean b) {
        if (b) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void enabled() {
        this.enable(true);
    }

    public void enableHighlighting(boolean b) {
        this.isHighlighting = b;
        if (!b) {
            this.changeState(this.pressed ? ACTIVE : INACTIVE);
        }
    }

    public void jwPaint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        this.stateVisual[this.currImg].paint(g, d.width, d.height);
    }

    public Dimension preferredSize() {
        int w = 0;
        int h = 0;
        int n = 0;
        while (n < 4) {
            if (this.stateVisual[n] != null) {
                Dimension tmp = this.stateVisual[n].preferredSize();
                w = Math.max(w, tmp.width);
                h = Math.max(h, tmp.height);
            }
            ++n;
        }
        this.dim.width = Math.max(w, this.size().width);
        this.dim.height = Math.max(h, this.size().height);
        return this.dim;
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x > this.preferredSize().width || y > this.preferredSize().height || x < 0 || y < 0) {
            this.mouseExited(e);
            return;
        }
        if (this.isPush) {
            this.mousePressed(e);
            return;
        }
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (!this.pressed && x < this.preferredSize().width && y < this.preferredSize().height) {
            this.changeState(HIGHLIGHT);
        } else {
            this.changeState();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Container cont;
        JWMenuBar.ResetMenu();
        if (Platforms.IsLinux() && (cont = this.getFrame()) instanceof Frame) {
            ((Window)cont).toFront();
        }
        int x = e.getX();
        int y = e.getY();
        this.binderButtonDown().notifyTargets(e);
        if (x > this.preferredSize().width || y > this.preferredSize().height) {
            return;
        }
        this.pressed = !this.isPush ? !this.pressed : true;
        this.changeState();
        if (e.getID() != 506) {
            this.notifyClients(e.getClickCount());
        }
    }

    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x < this.preferredSize().width && y < this.preferredSize().height) {
            if (this.isPush && this.pressed) {
                this.pressed = false;
                this.notifyClients(e.getClickCount());
                this.changeState(INACTIVE);
            }
            this.binderButtonUp().notifyTargets(e);
            return;
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.isPush) {
            this.pressed = false;
        }
        this.changeState();
    }

    void changeState() {
        this.changeState(this.pressed ? ACTIVE : INACTIVE);
    }

    void changeState(int state) {
        if (!this.isHighlighting && state == HIGHLIGHT) {
            return;
        }
        if (state != this.currImg && this.currImg != GRAY) {
            this.currImg = state;
            this.repaint();
            if (Platforms.IsLinux() && !Platforms.IsSolaris()) {
                Toolkit.getDefaultToolkit().sync();
            }
        }
    }

    void notifyClients(int clickCount) {
        JEvent e = new JEvent(this, "selection");
        e.clickCount = clickCount;
        this.getParent().handleEvent(e);
        if (!this.pressed || !this.isPush) {
            this.binder().notifyTargets(1);
        }
    }
}

