/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import JCollections.ISortFunc;
import JCollections.JArray;
import JCollections.JSet;
import de.netcomputing.anyj.jwidgets.BasicListItem;
import de.netcomputing.anyj.jwidgets.Binder;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.IListPanelDragDelegate;
import de.netcomputing.anyj.jwidgets.IPopupGetter;
import de.netcomputing.anyj.jwidgets.ISelectionProvider;
import de.netcomputing.anyj.jwidgets.IValue;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWScrollPane;
import de.netcomputing.anyj.jwidgets.KeyFilter;
import de.netcomputing.anyj.jwidgets.ListCanvas;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCTableView;
import de.netcomputing.anyj.jwidgets.TimeStampListItem;
import de.netcomputing.util.Tracer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import netcomputing.tools.INCExtendedPrintout;
import netcomputing.tools.Platforms;

public class JListPanel
extends JWScrollPane
implements ISelectionProvider,
INCExtendedPrintout {
    public static Font ListFont = new JList().getFont();
    public static boolean AnimateTree = true;
    ListCanvas listCanvas;
    IPopupGetter popUpGetter;
    SortController sctrl;
    JButton expandAllBtn;
    public boolean expandOnDoubleClick = false;
    boolean showExpandAllBtn;
    boolean direction = false;
    Binder binderDoubleClick;
    Binder binderIconClick;
    Binder binderCornerClick;
    boolean tree = true;
    boolean selectOnIconClick = true;
    boolean useBlit = false;

    public ListCanvas listCanvas() {
        return this.listCanvas;
    }

    public void setEnabled(boolean b) {
        this.listCanvas.setEnabled(b);
        this.setToolTipText("");
    }

    public void setPopUpGetter(IPopupGetter popUpGetter) {
        this.popUpGetter = popUpGetter;
    }

    public IPopupGetter getPopUpGetter() {
        return this.popUpGetter;
    }

    public boolean isOpaque() {
        return false;
    }

    public void init() {
        this.setLayout(null);
        this.listCanvas = new ListCanvas();
        this.add(this.listCanvas);
        this.listCanvas.init();
        this.listCanvas.binderLowLevel().addTarget(this, "actionList");
        this.listCanvas.addKeyListener(new KeyFilter(33, this, "actionPageUp"));
        this.listCanvas.addKeyListener(new KeyFilter(34, this, "actionPageDown"));
        this.listCanvas.addKeyListener(new KeyFilter(36, this, "actionHome"));
        this.listCanvas.addKeyListener(new KeyFilter(35, this, "actionEnd"));
        this.listCanvas.addKeyListener(new KeyFilter(38, this, "actionUp"));
        this.listCanvas.addKeyListener(new KeyFilter(40, this, "actionDown"));
        this.listCanvas.addKeyListener(new KeyFilter(10, this, "actionEnterNode"));
        this.listCanvas.addKeyListener(new KeyFilter(37, this, "actionLeftNode"));
        this.listCanvas.addKeyListener(new KeyFilter(39, this, "actionRightNode"));
        this.sctrl = new SortController();
        this.listCanvas.addKeyListener(this.sctrl);
        super.init();
        this.spv.setLineIncrement(this.listCanvas.dy);
        this.sph.setLineIncrement(4);
        this.listCanvas.setBackground(JWColor.For("listpanel.background"));
        this.listCanvas.setForeground(JWColor.For("listpanel.foreground"));
        this.listCanvas.setFont(ListFont);
        this.expandAllBtn = new JButton();
        Image img = NCApplication.GetImage("/de/netcomputing/anyj/images/expandall.gif");
        if (img != null) {
            this.expandAllBtn.setIcon(new ImageIcon(img));
        }
        this.expandAllBtn.setBorderPainted(false);
        this.expandAllBtn.setDefaultCapable(false);
        this.expandAllBtn.setFocusPainted(false);
        this.expandAllBtn.setVisible(this.showExpandAllBtn);
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.listCanvas().setDragEnabled(dragEnabled);
    }

    public boolean getDragEnabled() {
        return this.listCanvas().getDragEnabled();
    }

    public void setDrawIndent(boolean b) {
        this.listCanvas.drawIndent = b;
    }

    public boolean getDrawIndent() {
        return this.listCanvas.drawIndent;
    }

    public void setBackground(Color c) {
        this.listCanvas.setBackground(c);
        super.setBackground(c);
    }

    public void setFont(Font f) {
        this.listCanvas.setFont(f);
        super.setFont(f);
    }

    public void setInitialSearchText(String s) {
        this.sctrl.prefix = s;
    }

    public Object actionItemUp(Object arg, Object sen) {
        int i = this.getSelectionIndex();
        if (i > 0) {
            IListItem item = this.at(i);
            this.removeAt(i);
            this.insertItemAt(i - 1, item);
            this.setSelectionIndex(i - 1);
            this.repaintStartingAt(i - 1, this.listSize());
        }
        return null;
    }

    public static ISortFunc StringSortFunc() {
        return new ISortFunc(){

            public boolean isGreaterOrEqual(Object a, Object b) {
                return ((BasicListItem)a).getDisplayString().compareTo(((BasicListItem)b).getDisplayString()) >= 0;
            }
        };
    }

    public static ISortFunc StringSortFuncInverse() {
        return new ISortFunc(){

            public boolean isGreaterOrEqual(Object a, Object b) {
                return ((BasicListItem)a).getDisplayString().compareTo(((BasicListItem)b).getDisplayString()) <= 0;
            }
        };
    }

    public boolean getDrawLines() {
        return this.listCanvas().doDrawLines;
    }

    public void setDrawLines(boolean b) {
        this.listCanvas().doDrawLines = b;
    }

    public int indexOfByString(String toSearch) {
        return this.indexOfByString(toSearch, 0);
    }

    public int indexOfByString(String toSearch, int start) {
        int n = start;
        while (n < this.getList().size()) {
            IListItem o = this.at(n);
            if (o instanceof BasicListItem && ((BasicListItem)o).getDisplayString().equals(toSearch) || this.at(n).toString().equals(toSearch)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void sortByString() {
        this.sortByString(this.direction);
    }

    public void setSelectPath(String[] s) {
        this.setSelectionIndex(0);
        int i = 0;
        int n = 0;
        while (n < s.length && i < this.listSize()) {
            int oldI = i;
            i = this.findStringIgnoreCase(s[n].toString(), this.getSelectionIndex());
            if (i >= 0 && i < this.listSize()) {
                this.setSelectionIndex(i);
                this.expandNodeAt(i);
            } else {
                i = oldI;
            }
            ++n;
        }
    }

    public void sortByString(boolean direction) {
        if (direction) {
            JArray.QuickSort(new JArray(this.getList()), JListPanel.StringSortFunc());
        } else {
            JArray.QuickSort(new JArray(this.getList()), JListPanel.StringSortFuncInverse());
        }
        this.setSelectionIndex(-1);
        this.repaint();
    }

    public Object actionItemDown(Object arg, Object sen) {
        int i = this.getSelectionIndex();
        if (i >= 0 && i < this.listSize() - 1) {
            IListItem item = this.at(i);
            this.removeAt(i);
            this.insertItemAt(i + 1, item);
            this.setSelectionIndex(i + 1);
            this.repaintStartingAt(i, this.listSize());
        }
        return null;
    }

    public Object[] getDataSelection() {
        Object o = this.getSelectedObject();
        if (o == null) {
            return null;
        }
        return new Object[]{o, this.getSelectedItem()};
    }

    public void addKeyListener(KeyListener kl) {
        this.listCanvas.addKeyListener(kl);
    }

    public void addKeyListenerPrevious(KeyListener kl) {
        super.addKeyListener(kl);
    }

    public Binder binderDoubleClick() {
        if (this.binderDoubleClick == null) {
            this.binderDoubleClick = new Binder(this);
        }
        return this.binderDoubleClick;
    }

    public Binder binderIconClick() {
        if (this.binderIconClick == null) {
            this.binderIconClick = new Binder(this);
        }
        return this.binderIconClick;
    }

    public Binder binderCornerClick() {
        if (this.binderCornerClick == null) {
            this.binderCornerClick = new Binder(this);
        }
        return this.binderCornerClick;
    }

    public JPopupMenu getMenu() {
        if (this.popUpGetter == null) {
            return this.listCanvas.menu;
        }
        return this.popUpGetter.getMenu(this, this.getSelectedItem());
    }

    public void add(PopupMenu pm) {
        this.listCanvas.add(pm);
    }

    public void setFitOnFirstPaint(boolean b) {
        this.listCanvas.fitOnFirstPaint = b;
    }

    public void remove(MenuComponent pm) {
        this.listCanvas.remove(pm);
    }

    public boolean getTree() {
        return this.tree;
    }

    public void setTree(boolean b) {
        this.tree = b;
        this.listCanvas.setTree(b);
    }

    public void initIndent(int n) {
        this.listCanvas.indent = n;
    }

    public void addItem(IListItem t) {
        this.listCanvas.addItem(t);
    }

    public void insertItemAt(int i, IListItem t) {
        this.listCanvas.addItemAt(i, t);
    }

    public void insertItemRepaintingAt(int i, IListItem t) {
        this.listCanvas.addItemAt(i, t);
        this.listCanvas.repaintStartingAt(i);
    }

    public void addItemRepainting(IListItem t) {
        this.enableDoubleBuff(false);
        this.listCanvas.addItem(t);
        this.listCanvas.repaintStartingAt(this.listCanvas.listSize() - 1);
        this.enableDoubleBuff(true);
    }

    public void removeItem(IListItem t) {
        this.listCanvas.removeItem(t);
    }

    public void removeItemRepainting(IListItem t) {
        int i = this.listCanvas.indexOf(t);
        if (i >= 0 && i < this.listCanvas.listSize()) {
            this.listCanvas.removeItem(t);
            this.repaint();
            this.binder().notifyTargets(this.listCanvas);
        }
    }

    public void requestFocus() {
        this.listCanvas().requestFocus();
    }

    public void clear() {
        this.removeAllItems();
        this.setSelectionIndex(-1);
        this.scrollXTo(0);
        this.scrollYTo(0);
        this.repaint();
    }

    public void scrollYTo(int sel) {
        sel = Math.min(this.listCanvas().dy * this.listSize() - this.getHeight() + 16, sel);
        this.scrollbarVert().setSelection(sel);
    }

    public void removeAllItems() {
        this.listCanvas.theList.setSize(20);
        this.listCanvas.theList.trimToSize();
        this.listCanvas.theList.clear();
    }

    public void removeAt(int idx) {
        this.listCanvas.removeAt(idx);
    }

    public void replaceRepaintingAt(int idx, IListItem il) {
        this.listCanvas.getList().setElementAt(il, idx);
        this.listCanvas.repaintStartingAt(idx);
        this.binder().notifyTargets(this.listCanvas);
    }

    public void removeRepaintingAt(int idx) {
        this.listCanvas.removeAt(idx);
        this.listCanvas.repaintStartingAt(idx);
        this.binder().notifyTargets(this.listCanvas);
    }

    public void removeRepaintingTreeNodeAt(int idx) {
        int depth = this.at(idx).getDepth();
        this.listCanvas.removeAt(idx);
        while (idx < this.listSize() && this.at(idx).getDepth() > depth) {
            this.listCanvas.removeAt(idx);
        }
        this.listCanvas.repaintStartingAt(idx);
        this.binder().notifyTargets(this.listCanvas);
        if (this.listSize() == 0) {
            this.repaint();
        }
    }

    public void remSelection() {
        if (this.getSelectionIndex() >= 0) {
            this.remWithSelectionAt(this.getSelectionIndex());
        }
    }

    public void remWithSelectionAt(int idx) {
        this.listCanvas.removeAt(idx);
        if (idx >= this.listSize()) {
            --idx;
        }
        if (idx >= 0) {
            this.setSelectionIndex(idx);
        }
        this.repaint();
        this.binder().notifyTargets(this.listCanvas);
    }

    public IListItem at(int idx) {
        return this.listCanvas.at(idx);
    }

    public String stringAt(int idx) {
        return ((BasicListItem)this.listCanvas.at(idx)).getDisplayString();
    }

    public int lastIndexOf(IListItem itn) {
        return this.listCanvas.lastIndexOf(itn);
    }

    public void setList(Vector list, double newOffset, int newSelection) {
        this.listCanvas.setList(list, newOffset, newSelection);
        this.scrollXTo(0);
        this.scrollYTo(0);
        this.setSelectionIndex(newSelection);
    }

    public Vector getList() {
        return this.listCanvas.getList();
    }

    public int listSize() {
        return this.listCanvas.listSize();
    }

    public Enumeration elements() {
        return this.listCanvas.elements();
    }

    public int getSelectionIndex() {
        return this.listCanvas.intValue();
    }

    public int getOffset() {
        return this.listCanvas.getOffset();
    }

    public IListItem getSelectedItem() {
        return this.listCanvas.getSelectedItem();
    }

    public String getSelectedString() {
        if (this.getSelectedItem() != null) {
            return ((BasicListItem)this.getSelectedItem()).getDisplayString();
        }
        return null;
    }

    public void expandNode(IListItem t) {
        this.listCanvas.expandNode(t);
    }

    public void expandAll() {
        int n = 0;
        while (n < this.listSize()) {
            this.listCanvas.expandNodeAt(n);
            ++n;
        }
    }

    public void expandAll(IListItem ilItem) {
        int i = this.getList().indexOf(ilItem);
        if (i >= 0 && ilItem.hasContent()) {
            this.expandNodeAt(i);
            int n = i + 1;
            while (n < this.listSize() && this.at(n).getDepth() > ilItem.getDepth()) {
                this.listCanvas.expandNodeAt(n);
                ++n;
            }
        }
    }

    public void expandNodeAt(int i) {
        this.listCanvas.expandNodeAt(i);
    }

    public void collapseNodeAt(int i) {
        this.listCanvas.collapseNodeAt(i);
    }

    public void collapseNode(IListItem t) {
        this.listCanvas.collapseNode(t);
    }

    public boolean isContentVisible(int i) {
        return this.listCanvas.isContentVisible(i);
    }

    public Object getSelectedObject() {
        IListItem item = this.getSelectedItem();
        if (item instanceof BasicListItem) {
            return ((BasicListItem)item).wrappedObject();
        }
        return item;
    }

    public void setSelectionIndexMoveToTop(int i) {
        int d;
        this.listCanvas.setSelectionIndex(i);
        this.scrollYTo(i * this.listCanvas.dy);
        if (i < this.listSize() && i >= 0 && (d = this.at(i).getDepth() - 1) >= 0) {
            this.scrollXTo(d * this.listCanvas.indent);
        }
    }

    public void setDragDelegate(IListPanelDragDelegate dragDelegate) {
        this.listCanvas().setDragDelegate(dragDelegate);
    }

    public IListPanelDragDelegate getDragDelegate() {
        return this.listCanvas().getDragDelegate();
    }

    public void setSelectionIndex(int i) {
        this.listCanvas.setSelectionIndex(i);
        if (i <= this.yOff() / this.listCanvas.dy) {
            this.scrollYTo(i * this.listCanvas.dy);
        } else {
            int tmp = (this.yOff() + this.listCanvas.getSize().height) / this.listCanvas.dy;
            if (i >= tmp) {
                this.scrollYTo(i * this.listCanvas.dy - this.listCanvas.getSize().height + this.listCanvas.dy);
            }
        }
    }

    public void setSelectedString(String s) {
        int index = this.findString(s);
        if (index >= 0) {
            this.setSelectionIndexMoveToTop(index);
        }
    }

    public int findString(String s) {
        int index = 0;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            IListItem i = (IListItem)e.nextElement();
            if (i instanceof BasicListItem && ((BasicListItem)i).getDisplayString().equals(s)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int findString(String s, int index0) {
        int index = 0;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            IListItem i = (IListItem)e.nextElement();
            if (index >= index0 && i instanceof BasicListItem && ((BasicListItem)i).getDisplayString().equals(s)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int findStringIgnoreCaseStarting(String s, int index0) {
        int index = 0;
        Enumeration e = this.elements();
        s = s.toUpperCase();
        while (e.hasMoreElements()) {
            IListItem i = (IListItem)e.nextElement();
            if (index >= index0 && i instanceof BasicListItem && ((BasicListItem)i).getDisplayString().toUpperCase().startsWith(s)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int findStringIgnoreCase(String s, int index0) {
        int index = 0;
        Enumeration e = this.elements();
        s = s.toUpperCase();
        while (e.hasMoreElements()) {
            IListItem i = (IListItem)e.nextElement();
            if (index >= index0 && i instanceof BasicListItem && ((BasicListItem)i).getDisplayString().toUpperCase().equals(s)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int findStringIgnoreCase(String s) {
        int index = 0;
        Enumeration e = this.elements();
        s = s.toUpperCase();
        while (e.hasMoreElements()) {
            IListItem i = (IListItem)e.nextElement();
            if (i instanceof BasicListItem && ((BasicListItem)i).getDisplayString().toUpperCase().equals(s)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void lockUpdate(boolean b) {
        this.listCanvas.lockUpdate(b);
    }

    public void setSelectedObject(Object s) {
        int index = 0;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            IListItem i = (IListItem)e.nextElement();
            if (i instanceof BasicListItem && (((BasicListItem)i).wrappedObject() == null && s == null || ((BasicListItem)i).wrappedObject() != null && ((BasicListItem)i).wrappedObject().equals(s))) {
                this.setSelectionIndexMoveToTop(index);
                return;
            }
            ++index;
        }
    }

    public void setSelectedItem(IListItem s) {
        int index = this.listCanvas().getList().indexOf(s);
        if (index >= 0) {
            this.setSelectionIndex(index);
        }
    }

    public Binder doubleClickBinder() {
        if (this.binderDoubleClick == null) {
            this.binderDoubleClick = new Binder(this);
        }
        return this.binderDoubleClick;
    }

    public void addOrSelectLine(String text) {
        if (this.findString(text) >= 0) {
            this.setSelectedString(text);
        } else {
            this.addLine(text);
        }
    }

    public void printLine(String text) {
        this.addLine(text);
    }

    public void setWrapLines(boolean wrapLines) {
    }

    public void printLine(Image im, String text) {
        this.addLine(im, text);
    }

    public void processTerminated(int i) {
    }

    public void addLineWithTimeStamp(Object text) {
        int newOffset;
        TimeStampListItem item = new TimeStampListItem(text, 0);
        item.setDepth(0);
        this.enableDoubleBuff(false);
        this.addItemRepainting(item);
        int n = newOffset = this.listSize() < this.listCanvas.getVisibleRange() ? 0 : this.listSize() - this.listCanvas.getVisibleRange() + 1;
        if (newOffset != this.listCanvas.offY) {
            this.scrollYTo(newOffset * this.listCanvas.dy);
        }
        this.enableDoubleBuff(true);
    }

    public void addLineWithTimeStamp(Image im, Object text, boolean linkStyle) {
        TimeStampListItem item = new TimeStampListItem(text, im);
        item.setLinkStyle(linkStyle);
        item.setDepth(0);
        this.enableDoubleBuff(false);
        this.addItemRepainting(item);
        int newOffset = this.listSize() < this.listCanvas.getVisibleRange() ? 0 : this.listSize() - this.listCanvas.getVisibleRange() + 1;
        this.scrollYTo(newOffset * this.listCanvas.dy);
        this.enableDoubleBuff(true);
    }

    public void addLine(Object text) {
        int newOffset;
        ListItem item = new ListItem(text, 0);
        item.setDepth(0);
        this.enableDoubleBuff(false);
        this.addItemRepainting(item);
        int n = newOffset = this.listSize() < this.listCanvas.getVisibleRange() ? 0 : this.listSize() - this.listCanvas.getVisibleRange() + 1;
        if (newOffset != this.listCanvas.offY) {
            this.scrollYTo(newOffset * this.listCanvas.dy);
        }
        this.enableDoubleBuff(true);
    }

    public void addLine(Image im, Object text) {
        ListItem item = new ListItem(text, im);
        item.setDepth(0);
        this.enableDoubleBuff(false);
        this.addItemRepainting(item);
        int newOffset = this.listSize() < this.listCanvas.getVisibleRange() ? 0 : this.listSize() - this.listCanvas.getVisibleRange() + 1;
        this.scrollYTo(newOffset * this.listCanvas.dy);
        this.enableDoubleBuff(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void switchNodeAt(int i) {
        if (!this.tree) {
            return;
        }
        if (this.listCanvas.isContentVisible(i)) {
            int howMuch = this.listCanvas.collapseNodeAt(i);
            int yOld = this.yOff();
            int numAnim = 7;
            if (howMuch < 3) {
                numAnim = 4;
            }
            int y = this.listCanvas.dy * i + this.listCanvas.dy;
            int step = howMuch * this.listCanvas.dy / numAnim;
            if (AnimateTree && step > 0 && i < this.listSize() - 1 && y > this.listCanvas.offY && y + howMuch * this.listCanvas.dy < this.listCanvas.getHeight() + this.listCanvas.offY) {
                try {
                    Graphics g = this.listCanvas().getGraphics();
                    int n = 0;
                    while (n < numAnim) {
                        Thread.sleep(15L);
                        g.copyArea(0, y - this.listCanvas.offY + step, 4000, this.listCanvas.getHeight() - (y - this.listCanvas.offY) - step, 0, -step);
                        if (Platforms.IsLinux()) {
                            Toolkit.getDefaultToolkit().sync();
                        }
                        ++n;
                    }
                    g.dispose();
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
            if (this.listCanvas.getSelectionIndex() > i && this.listCanvas.getSelectionIndex() <= i + howMuch) {
                this.listCanvas.setSelection(-1);
            } else if (this.listCanvas.getSelectionIndex() > i) {
                this.listCanvas.setSelection(this.listCanvas.getSelectionIndex() - howMuch);
            }
            this.listCanvas.repaint();
        } else {
            int clearPix = 0;
            if (i + 1 < this.listSize()) {
                clearPix = (this.at(i + 1).getDepth() - 1) * this.listCanvas.indent;
            }
            int howMuch = this.listCanvas.expandNodeAt(i);
            int numAnim = 10;
            if (howMuch < 3) {
                numAnim = 5;
            }
            int y = this.listCanvas.dy * i + this.listCanvas.dy;
            int step = howMuch * this.listCanvas.dy / numAnim;
            int stepItems = Math.max(1 + step / this.listCanvas.dy, 1);
            if (stepItems > 1) {
                int n = 2;
                while (n <= stepItems) {
                    int newClear = clearPix;
                    try {
                        newClear = this.at(i + howMuch + n).getDepth() - 1 * this.listCanvas.indent;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    clearPix = Math.min(clearPix, newClear);
                    ++n;
                }
            }
            if (AnimateTree && step > 0 && i < this.listSize() - 1 && y > this.listCanvas.offY && y < this.listCanvas.getHeight() + this.listCanvas.offY) {
                try {
                    clearPix -= this.listCanvas.offY;
                    Graphics g = this.listCanvas().getGraphics();
                    g.setColor(this.listCanvas.getBackground());
                    int n = 0;
                    while (n < numAnim) {
                        Thread.sleep(15L);
                        g.copyArea(0, y - this.listCanvas.offY, 4000, this.getHeight(), 0, step);
                        g.fillRect(clearPix, y - this.listCanvas.offY, 4000, step);
                        if (Platforms.IsLinux()) {
                            Toolkit.getDefaultToolkit().sync();
                        }
                        ++n;
                    }
                    g.dispose();
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
            try {
                this.setUseBlit(false);
                this.scrollToVisibleY(i * this.listCanvas.dy, (i + howMuch + 1) * this.listCanvas.dy);
                if (this.listCanvas.getSelectionIndex() > i) {
                    this.listCanvas.setSelection(this.listCanvas.getSelectionIndex() + howMuch);
                }
                this.listCanvas.repaint();
                Object var12_21 = null;
                this.setUseBlit(true);
            }
            catch (Throwable throwable) {
                Object var12_22 = null;
                this.setUseBlit(true);
                throw throwable;
            }
        }
    }

    public void setUseBlit(boolean useBlit) {
        this.useBlit = false;
    }

    public boolean getUseBlit() {
        return this.useBlit;
    }

    public Object actionEnterNode(Object arg, Object sender) {
        if (this.getSelectionIndex() >= 0) {
            this.binderDoubleClick().notifyTargets(this.listCanvas.getSelectionIndex());
        }
        return null;
    }

    public Object actionRightNode(Object arg, Object sender) {
        int i = 0;
        i = this.getSelectionIndex();
        if (i >= 0 && this.tree) {
            IListItem item = this.at(i);
            if (item.hasContent() && !this.isContentVisible(i)) {
                this.switchNodeAt(i);
                if (i < this.listSize() - 1 && this.at(i + 1).getDepth() <= this.at(i).getDepth()) {
                    this.actionDown(arg, sender);
                }
            } else {
                this.actionDown(arg, sender);
            }
        }
        return null;
    }

    public Object actionLeftNode(Object arg, Object sender) {
        this.binderCornerClick().notifyTargets(this.getSelectionIndex());
        int i = 0;
        i = this.getSelectionIndex();
        if (i >= 0 && this.tree) {
            IListItem item = this.at(i);
            if (this.isContentVisible(i)) {
                this.switchNodeAt(i);
            } else if (item.getDepth() > 0) {
                while (i >= 0 && this.at(i).getDepth() >= item.getDepth()) {
                    --i;
                }
                if (i >= 0) {
                    this.setSelectionIndex(i);
                    this.binder().notifyTargets(this.listCanvas);
                }
            } else {
                this.actionUp(arg, sender);
            }
        }
        return null;
    }

    public Object actionSwitchNode(Object arg, Object sender) {
        if (this.getSelectionIndex() >= 0 && this.tree) {
            this.switchNodeAt(this.listCanvas.getSelectionIndex());
        }
        return null;
    }

    public Object actionList(Object arg, Object sender) {
        String sel = ((IValue)arg).stringValue();
        if (sel.equals("selection")) {
            this.binder().notifyTargets(this.listCanvas);
        } else if (sel.equals("iconSelection")) {
            this.binderIconClick().notifyTargets(this);
        } else if (sel.equals("doubleSelection")) {
            this.binderDoubleClick().notifyTargets(this.listCanvas.getSelectionIndex());
            if (this.expandOnDoubleClick) {
                // empty if block
            }
            this.switchNodeAt(this.listCanvas.getSelectionIndex());
        } else if (sel.equals("listSize")) {
            this.checkComponentValues();
        } else if (sel.equals("visibleRange")) {
            this.checkComponentValues();
        } else if (sel.equals("listOffset")) {
            // empty if block
        }
        return null;
    }

    public void setSelectOnIconClick(boolean selectOnIconClick) {
        this.selectOnIconClick = selectOnIconClick;
    }

    public boolean getSelectOnIconClick() {
        return this.selectOnIconClick;
    }

    public void collapseAll() {
        int n = 0;
        while (n < this.listCanvas.listSize()) {
            if (this.isContentVisible(n)) {
                this.listCanvas.collapseNodeAt(n);
            }
            ++n;
        }
    }

    public void collapseAndExpandAll() {
        JSet expanded = new JSet(this.listCanvas.listSize() / 5);
        int n = 0;
        while (n < this.listCanvas.listSize()) {
            if (this.isContentVisible(n)) {
                expanded.add(((BasicListItem)this.at(n)).getDisplayString());
            }
            ++n;
        }
        this.lockUpdate(true);
        int n2 = 0;
        while (n2 < this.listCanvas.listSize()) {
            if (this.isContentVisible(n2)) {
                this.listCanvas.collapseNodeAt(n2);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.listCanvas.listSize()) {
            if (expanded.find(((BasicListItem)this.at(n3)).getDisplayString()) != null) {
                this.listCanvas.expandNodeAt(n3);
            }
            ++n3;
        }
        this.lockUpdate(false);
        this.repaint();
    }

    public void collapseAndExpandAllByIndentity() {
        JSet expanded = new JSet(this.listCanvas.listSize() / 5);
        int n = 0;
        while (n < this.listCanvas.listSize()) {
            if (this.isContentVisible(n)) {
                expanded.add(this.at(n));
            }
            ++n;
        }
        this.lockUpdate(true);
        int n2 = 0;
        while (n2 < this.listCanvas.listSize()) {
            if (this.isContentVisible(n2)) {
                this.listCanvas.collapseNodeAt(n2);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.listCanvas.listSize()) {
            if (expanded.find(this.at(n3)) != null) {
                this.listCanvas.expandNodeAt(n3);
            }
            ++n3;
        }
        this.lockUpdate(false);
        this.repaint();
    }

    public Vector getExpandedNodes(boolean collapsed) {
        Vector<String> expanded = new Vector<String>(20);
        int n = 0;
        while (n < this.listCanvas.listSize()) {
            if (this.isContentVisible(n) ^ collapsed) {
                expanded.add(((BasicListItem)this.at(n)).getDisplayString());
            }
            ++n;
        }
        return expanded;
    }

    public Object actionUp(Object arg, Object sender) {
        if (this.getSelectionIndex() > 0) {
            this.setSelectionIndex(this.getSelectionIndex() - 1);
            this.binder().notifyTargets(this.listCanvas);
        }
        return null;
    }

    public Object actionDown(Object arg, Object sender) {
        if (this.getSelectionIndex() < this.listSize() - 1) {
            this.setSelectionIndex(this.getSelectionIndex() + 1);
            this.binder().notifyTargets(this.listCanvas);
        }
        return null;
    }

    public Object actionPageUp(Object arg, Object sender) {
        int visibleLines = this.getSize().height / this.listCanvas.dy;
        if (this.getSelectionIndex() > 0) {
            this.setSelectionIndex(Math.max(0, this.getSelectionIndex() - visibleLines));
            this.binder().notifyTargets(this.listCanvas);
        }
        return null;
    }

    public Object actionHome(Object arg, Object sender) {
        if (this.listSize() > 0) {
            this.setSelectionIndex(0);
            this.binder().notifyTargets(this.listCanvas);
        }
        return null;
    }

    public Object actionEnd(Object arg, Object sender) {
        if (this.listSize() > 0) {
            this.setSelectionIndex(this.listSize() - 1);
            this.binder().notifyTargets(this.listCanvas);
        }
        return null;
    }

    public Object actionPageDown(Object arg, Object sender) {
        int visibleLines = this.getSize().height / this.listCanvas.dy;
        if (this.getSelectionIndex() < this.listSize() - 1) {
            this.setSelectionIndex(Math.min(this.listSize() - 1, this.getSelectionIndex() + visibleLines));
            this.binder().notifyTargets(this.listCanvas);
        }
        return null;
    }

    public void repaintStartingAt(int idx, int length) {
        this.listCanvas.repaintStartingAt(idx, length);
    }

    public void notifyTargets() {
        this.binder().notifyTargets(this.listCanvas);
    }

    public void selectNearestString(String s) {
        int n = 0;
        while (n < this.listSize()) {
            if (((BasicListItem)this.at(n)).getDisplayString().startsWith(s)) {
                this.setSelectionIndex(n);
                this.notifyTargets();
                return;
            }
            ++n;
        }
    }

    public void moveSelUp() {
        int i = this.getSelectionIndex();
        if (i > 0) {
            IListItem item = this.at(i);
            this.removeAt(i);
            this.insertItemAt(i - 1, item);
            this.setSelectionIndex(i - 1);
            this.binder().notifyTargets(i - 1);
            this.repaintStartingAt(i - 1, this.listSize());
        }
    }

    public int computeChildren(int index) {
        int pdepth = this.at(index).getDepth();
        int n = 0;
        n = index + 1;
        while (n < this.listSize() && this.at(n).getDepth() > pdepth) {
            ++n;
        }
        return n - index;
    }

    public IListItem findParentObject(IListItem item, int depth) {
        int i = this.getList().indexOf(item);
        if (i >= 0) {
            return this.findParentObject(i, depth + 1);
        }
        return null;
    }

    public IListItem findParentObject(int index, int depth) {
        if (index <= 0 || index >= this.listSize()) {
            return null;
        }
        int n = index;
        while (n >= 0 && this.at(n).getDepth() >= depth) {
            --n;
        }
        if (n >= 0 && this.at(n).getDepth() == depth - 1) {
            return this.at(n);
        }
        return null;
    }

    public void moveSelDown() {
        int i = this.getSelectionIndex();
        if (i >= 0 && i < this.listSize() - 1) {
            IListItem item = this.at(i);
            this.removeAt(i);
            this.insertItemAt(i + 1, item);
            this.setSelectionIndex(i + 1);
            this.binder().notifyTargets(i + 1);
            this.repaintStartingAt(i, this.listSize());
        }
    }

    public void jwPaint(Graphics g) {
        super.jwPaint(g);
    }

    public void pastFirstPaint() {
        this.setUseBlit(true);
        super.pastFirstPaint();
    }

    protected void repaintComponent() {
        if (this.useBlit) {
            super.repaintComponent();
            return;
        }
        this.comp.repaint();
    }

    public Point getSelectionLocOnScreenBot() {
        Point res = this.getSelectionLocOnScreenTop();
        res.y += this.listCanvas().dy;
        return res;
    }

    public Point getSelectionLocOnScreenTop() {
        int i = this.getSelectionIndex();
        if (i < 0) {
            return null;
        }
        Point loc = this.listCanvas().getLocationOnScreen();
        int offY = this.listCanvas().dy * i - this.yOff();
        int offX = this.listCanvas().indent * this.getSelectedItem().getDepth() - this.xOff();
        loc.x += offX;
        loc.y += offY;
        return loc;
    }

    public class SortController
    extends KeyAdapter {
        StringBuffer toSearch = new StringBuffer(20);
        long lastAccess = 0L;
        NCTableView view = this.view;
        String prefix = "";

        public void keyTyped(KeyEvent ke) {
            if (ke.isAltDown() || ke.isMetaDown() || ke.isControlDown()) {
                return;
            }
            if (System.currentTimeMillis() - this.lastAccess > 1000L) {
                this.toSearch.setLength(0);
                this.toSearch.append(this.prefix);
            }
            if (ke.getKeyCode() == 16 || ke.getKeyCode() == 18 || ke.getKeyCode() == 17) {
                return;
            }
            char c = ke.getKeyChar();
            if (c >= ' ') {
                if (this.toSearch.length() > 0 && c == this.toSearch.charAt(this.toSearch.length() - 1)) {
                    int index = JListPanel.this.getSelectionIndex();
                    this.selectNextEntry(this.toSearch.toString() + c);
                    if (index == JListPanel.this.getSelectionIndex()) {
                        this.toSearch = new StringBuffer("" + c);
                    } else {
                        this.toSearch.append(c);
                    }
                } else {
                    this.toSearch.append(c);
                }
            } else {
                this.toSearch.setLength(0);
                this.toSearch.append(this.prefix);
                return;
            }
            this.lastAccess = System.currentTimeMillis();
            this.selectNextEntry(this.toSearch.toString());
        }

        protected void selectNextEntry(String s) {
            int siz;
            s = s.toUpperCase();
            int selIdx = JListPanel.this.getSelectionIndex();
            if (selIdx >= (siz = JListPanel.this.listSize()) - 1 || selIdx < 0) {
                selIdx = 0;
            }
            int startIdx = this.toSearch.length() > 1 ? 0 : 1;
            int n = 0;
            n = startIdx;
            while (n < siz + startIdx) {
                IListItem item = JListPanel.this.at((n + selIdx) % siz);
                String ts = null;
                ts = item instanceof BasicListItem ? ((BasicListItem)item).getDisplayString().toUpperCase() : item.toString().toUpperCase();
                if (ts.startsWith(s)) {
                    JListPanel.this.setSelectionIndex((n + selIdx) % siz);
                    JListPanel.this.binder().notifyTargets(JListPanel.this.listCanvas);
                    break;
                }
                ++n;
            }
            if (n == siz + startIdx - 1) {
                this.toSearch.setLength(0);
                this.toSearch.append(this.prefix);
            }
        }
    }
}

