/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import JCollections.JSet;
import JCollections.JUnsafeTable;
import de.netcomputing.anyj.jwidgets.JMenuAdaptor;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.Tracer;
import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.util.Enumeration;

public class JMenuBuilder {
    public static void validateItemMap(JUnsafeTable items) {
        Enumeration e = items.keys();
        while (e.hasMoreElements()) {
            String msg = (String)e.nextElement();
            Object[] o = (Object[])items.get(msg);
            Object result = null;
            if (!NCApplication.RespondsToAction(o[1], msg)) {
                result = Boolean.FALSE;
                items.remove(o[1]);
            } else {
                String s = "isValid_" + msg;
                if (NCApplication.RespondsToAction(o[1], s)) {
                    result = NCApplication.PerformAction(o[1], s, null, null);
                } else {
                    items.remove(o[1]);
                }
            }
            ((MenuItem)o[0]).setEnabled(result == null);
        }
    }

    public static MenuBar buildMenuBarFrom(Object[][] ms, JUnsafeTable itemMap) {
        return JMenuBuilder.buildMenuBarFrom(ms, itemMap, null);
    }

    public static MenuBar buildMenuBarFrom(Object[][] ms, JUnsafeTable itemMap, Font f) {
        MenuBar mb = new MenuBar();
        if (f != null) {
            mb.setFont(f);
        }
        JSet definedShortcuts = new JSet();
        int n = 0;
        while (n < ms.length) {
            mb.add(JMenuBuilder.buildMenuFrom(ms[n], definedShortcuts, itemMap, f));
            ++n;
        }
        return mb;
    }

    public static Menu buildMenuFrom(Object[] ms, JSet definedShortcuts, JUnsafeTable itemMap) {
        return JMenuBuilder.buildMenuFrom(ms, definedShortcuts, itemMap, null);
    }

    public static Menu buildMenuFrom(Object[] ms, JSet definedShortcuts, JUnsafeTable itemMap, Font f) {
        Menu newMenu = new Menu(ms[0].toString());
        if (f != null) {
            newMenu.setFont(f);
        }
        try {
            String prefix = ms[1].toString();
            Object target = ms[2];
            if (target != null) {
                JMenuAdaptor jma = new JMenuAdaptor(target, prefix);
                newMenu.addActionListener(jma);
            }
            int n = 3;
            while (n < ms.length) {
                if (ms[n] instanceof Object[]) {
                    newMenu.add(JMenuBuilder.buildMenuFrom((Object[])ms[n++], definedShortcuts, itemMap, f));
                    continue;
                }
                String item = ms[n].toString();
                ++n;
                MenuItem mi = new MenuItem(item);
                if (f != null) {
                    mi.setFont(f);
                }
                if (definedShortcuts != null) {
                    int i = 0;
                    while (i < item.length() && i != 99 && i != 118 && i != 67 && i != 86 && definedShortcuts.find(new Character(item.charAt(i))) != null) {
                        ++i;
                    }
                    if (i < item.length()) {
                        // empty if block
                    }
                }
                mi.setActionCommand(ms[n].toString());
                if (itemMap != null) {
                    Object[] tmp = new Object[]{mi, target};
                    itemMap.put(prefix + "_" + ms[n], tmp);
                }
                ++n;
                newMenu.add(mi);
            }
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
            return null;
        }
        return newMenu;
    }

    public static PopupMenu buildPopUpFrom(Object[] ms, JUnsafeTable itemMap) {
        return JMenuBuilder.buildPopUpFrom(ms, null, null);
    }

    public static PopupMenu buildPopUpFrom(Object[] ms, JUnsafeTable itemMap, Font f) {
        PopupMenu newMenu = new PopupMenu(ms[0].toString());
        try {
            String prefix = ms[1].toString();
            Object target = ms[2];
            if (target != null) {
                JMenuAdaptor jma = new JMenuAdaptor(target, prefix);
                newMenu.addActionListener(jma);
            }
            int n = 3;
            while (n < ms.length) {
                if (ms[n] instanceof Object[]) {
                    Menu mc = JMenuBuilder.buildMenuFrom((Object[])ms[n++], null, itemMap, f);
                    if (f != null) {
                        mc.setFont(f);
                    }
                    newMenu.add(mc);
                    continue;
                }
                MenuItem mi = new MenuItem(ms[n++].toString());
                if (f != null) {
                    mi.setFont(f);
                }
                if (itemMap != null) {
                    Object[] tmp = new Object[]{mi, target};
                    itemMap.put(prefix + "_" + ms[n], tmp);
                }
                mi.setActionCommand(ms[n].toString());
                ++n;
                newMenu.add(mi);
            }
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
            return null;
        }
        return newMenu;
    }
}

