/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import JCollections.JArray;
import JCollections.JIterationFunc;
import JCollections.JSet;
import de.netcomputing.anyj.jwidgets.Binder;
import de.netcomputing.anyj.jwidgets.IValue;
import de.netcomputing.anyj.jwidgets.JTableHeader;
import de.netcomputing.anyj.jwidgets.JTableModel;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWMenuBar;
import de.netcomputing.anyj.jwidgets.JWScrollPane;
import de.netcomputing.anyj.jwidgets.JWScrollable;
import de.netcomputing.anyj.jwidgets.JWValueEditor;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.NCTableView;
import de.netcomputing.util.Tracer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.RepaintManager;
import netcomputing.tools.Platforms;

public class JTableCanvas
extends NCPanel
implements JWScrollable {
    public JTableModel model;
    JTableHeader header;
    int ch = 0;
    int offX = 0;
    int offY = 0;
    JSet selections;
    static int CLIPMAX = 10000000;
    public boolean isMulti;
    public boolean isSelectable;
    public boolean isCellEditable = true;
    Binder binderRowSelection = new Binder(this);
    Binder binderDoubleRowSelection = new Binder(this);
    Binder binderDoubleCellSelection = new Binder(this);
    int sel;
    public int smin;
    public int smax;
    JWValueEditor valEd;
    Component valRep;
    int edX;
    int edY;

    public JTableCanvas(JTableModel _model, JTableHeader _header) {
        this.setModel(_model);
        this.header = _header;
        this.header.binderDragOccured().addTarget(this, "actionDrag");
        this.header.binderColSelection().addTarget(this, "actionRowSelect");
        this.header.binderDesel().addTarget(this, "actionRepaint");
        this.clearSelectionsQuiet();
        MouseEvents me2 = new MouseEvents();
        this.addMouseListener(me2);
        this.addMouseMotionListener(me2);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JTableCanvas.this.stopEditing();
            }
        });
        this.init();
        this.setBackground(JWColor.For("listpanel.background"));
    }

    public void setModel(JTableModel _model) {
        this.model = _model;
    }

    public Object actionDrag(Object arg, Object sender) {
        this.stopEditing();
        this.repaint();
        return null;
    }

    public Object actionRepaint(Object arg, Object sender) {
        this.stopEditing();
        this.repaintCols(((IValue)arg).intValue(), ((IValue)arg).intValue() + 1);
        return null;
    }

    public Object actionRowSelect(Object arg, Object sender) {
        this.stopEditing();
        this.repaintCols(((IValue)arg).intValue(), ((IValue)arg).intValue() + 1);
        return null;
    }

    public Binder binderShouldScrollY() {
        return this.binder();
    }

    public Binder binderRowSelection() {
        return this.binderRowSelection;
    }

    public Binder binderDoubleRowSelection() {
        return this.binderDoubleRowSelection;
    }

    public Binder binderDoubleCellSelection() {
        return this.binderDoubleCellSelection;
    }

    public boolean isSelected(int y) {
        return this.selections.find(new Integer(y)) != null;
    }

    public void clearSelections() {
        this.clearSelectionsQuiet();
        this.repaint();
    }

    public JSet getRowSelections() {
        return this.selections;
    }

    public JArray getColSelections() {
        return this.header.getSelections();
    }

    public void deselectHeaderQuietNoNotify() {
        this.header.deselectQuietNoNotify();
    }

    public void clearSelectionsQuiet() {
        this.selections = new JSet();
    }

    public void addSelectionQuiet(int index) {
        if (index < this.model.dimY() && index >= 0) {
            this.selections.add(new Integer(index));
        }
    }

    public void addSelection(int index) {
        this.addSelectionQuiet(index);
        this.repaintLines(index, index + 1);
    }

    public void remSelectionQuiet(int index) {
        if (index < this.model.dimY() && index >= 0) {
            this.selections.rem(new Integer(index));
        }
    }

    public void remSelection(int index) {
        this.remSelectionQuiet(index);
        this.repaintLines(index, index + 1);
    }

    public synchronized int getSelection() {
        this.sel = 9999999;
        this.selections.forAll(new JIterationFunc(){

            public boolean func(Object o) {
                int actsel = (Integer)o;
                if (actsel < JTableCanvas.this.sel) {
                    JTableCanvas.this.sel = actsel;
                }
                return false;
            }
        });
        return this.sel == 9999999 ? -1 : this.sel;
    }

    public synchronized int[] computeMinMaxSelection() {
        this.smin = this.model.dimY();
        this.smax = -1;
        this.selections.forAll(new JIterationFunc(){

            public boolean func(Object o) {
                int sel = (Integer)o;
                JTableCanvas.this.smin = Math.min(sel, JTableCanvas.this.smin);
                JTableCanvas.this.smax = Math.max(sel, JTableCanvas.this.smax);
                return false;
            }
        });
        int[] res = new int[]{this.smin, this.smax};
        return res;
    }

    public void stopEditing() {
        if (this.valEd != null) {
            this.valEd.stopEditing();
        }
        if (this.valRep != null) {
            this.remove(this.valRep);
            this.repaint(100L);
        }
        this.edY = -1;
        this.edX = -1;
        this.valRep = null;
        this.valEd = null;
    }

    public void cancelEditing() {
        if (this.valRep != null) {
            this.remove(this.valRep);
            this.repaint(100L);
        }
        this.valRep = null;
        this.valEd = null;
    }

    boolean doEdit(int viewX, int viewY) {
        this.stopEditing();
        this.edX = viewX;
        this.edY = viewY;
        int x = this.header.orgPosAt(viewX);
        this.valEd = this.model.requestEditAt(x, viewY, (NCTableView)this.getParent().getParent());
        if (this.valEd == null) {
            return false;
        }
        this.valRep = this.valEd.getRepresentation();
        this.add(this.valRep, 0);
        int prefDiff = this.ch < this.valRep.getMinimumSize().height ? (this.valRep.getMinimumSize().height - this.ch) / 2 : 0;
        this.valRep.setBounds(this.header.xPosAt(viewX) - this.offX, viewY * this.ch - this.offY - prefDiff, this.header.widthAt(viewX), this.ch + 2 * prefDiff);
        this.valEd.initAfterShowing();
        return true;
    }

    public void requestFocus() {
        this.getParent().getParent().requestFocus();
    }

    public void repaintCols(int startCol, int endCol) {
        this.repaint();
    }

    public void repaintLines(int start, int end) {
        if (!this.getFrame().isShowing()) {
            return;
        }
        Dimension d = this.getSize();
        this.repaintImmediate(0, this.ch * start - this.offY, d.width, Math.min(d.height, this.ch * (end - start)));
    }

    public void repaintCell(int viewX, int viewY) {
        if (!this.getParent().isShowing()) {
            return;
        }
        this.paintImmediately(this.header.xPosAt(viewX) - this.offX, this.ch * viewY - this.offY, this.header.widthAt(viewX), this.ch);
    }

    public Dimension preferredSize() {
        return new Dimension(this.header.preferredSize().width, this.model.dimY() * this.ch);
    }

    public void jwPaint(Graphics g) {
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        if (!Platforms.IsJDK12()) {
            repaintManager.setDoubleBufferingEnabled(false);
        }
        if (((NCTableView)this.getParent().getParent()).autoFit) {
            ((NCTableView)this.getParent().getParent()).fitColumnsToView(1024);
        }
        int[] sizes = this.header.getSizes();
        if (this.ch == 0) {
            this.ch = this.model.getHeight();
            if (this.ch <= 0) {
                this.ch = this.getFontMetrics(this.getFont()).getHeight() + 1;
            }
            ((JWScrollPane)this.getParent()).scrollbarHorz().setLineIncrement(8);
            ((JWScrollPane)this.getParent()).scrollbarVert().setLineIncrement(this.ch);
        }
        g.translate(-this.offX, -this.offY);
        Rectangle r = this.getBounds();
        Rectangle rc = g.getClipBounds();
        r.x = 0;
        r.y = 0;
        r.move(this.offX, this.offY);
        Color fg = null;
        Color bg = null;
        int xx = 0;
        while (xx < this.model.dimX()) {
            int x = this.header.orgPosAt(xx);
            Graphics gg = g.create();
            gg.clipRect(sizes[x] - 1, 0, sizes[this.header.orgPosAt(xx + 1)] - sizes[x] + 1, CLIPMAX);
            int y = r.y / this.ch;
            while (y < Math.min((r.y + r.height) / this.ch + 2, this.model.dimY())) {
                String s = this.model.stringAt(x, y);
                if (s != null && y < this.model.dimY()) {
                    int sel = (this.header.isSelected(xx) ? 1 : 0) + (this.isSelected(y) ? 1 : 0);
                    switch (sel) {
                        case 0: {
                            bg = JWColor.For("table.bg");
                            fg = JWColor.For("table.txt");
                            break;
                        }
                        case 1: {
                            bg = JWColor.For("table.bg.sel");
                            fg = JWColor.For("table.txt.sel");
                            break;
                        }
                        case 2: {
                            bg = JWColor.For("table.bg.selsel");
                            fg = JWColor.For("table.txt.selsel");
                        }
                    }
                    gg.setColor(bg);
                    gg.fillRect(sizes[x], y * this.ch, sizes[this.header.orgPosAt(xx + 1)] - sizes[x], this.ch);
                    gg.setColor(fg);
                    gg.drawString(s, sizes[x] + 4, y * this.ch + this.ch - this.getFontMetrics(this.getFont()).getMaxDescent());
                } else {
                    this.model.paintAt(gg, x, y, sizes[x], y * this.ch, sizes[x + 1] - sizes[x], this.ch, this.isSelected(y), this);
                }
                ++y;
            }
            gg.dispose();
            ++xx;
        }
        int tmp = this.header.xPosAt(this.model.dimX() - 1) + this.header.widthAt(this.model.dimX() - 1);
        if (tmp < this.offX + this.size().width) {
            Tracer.This.println("Clear to LEFT:" + tmp);
            g.setColor(this.getBackground());
            g.fillRect(tmp, r.y, 1600, r.height);
        }
        if (this.model.dimY() * this.ch < r.y + r.height) {
            Tracer.This.println("Clear to Bottom:" + tmp);
            g.setColor(this.getBackground());
            g.fillRect(0, this.model.dimY() * this.ch, 1600, r.height);
        }
        g.translate(this.offX, this.offY);
        if (!Platforms.IsJDK12()) {
            repaintManager.setDoubleBufferingEnabled(true);
        }
    }

    public void setOffsetX(int x) {
        this.stopEditing();
        this.offX = x;
    }

    public void setOffsetY(int y) {
        this.stopEditing();
        this.offY = y;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    class MouseEvents
    extends MouseAdapter
    implements MouseMotionListener {
        int start;
        int mode;
        boolean down = false;
        int prevEnd;

        MouseEvents() {
        }

        public void mousePressed(MouseEvent e) {
            JWMenuBar.ResetMenu();
            JTableCanvas.this.requestFocus();
            if (e.getClickCount() > 1) {
                JTableCanvas.this.stopEditing();
                JTableCanvas.this.binderDoubleRowSelection().notifyTargets(e.getClickCount());
                return;
            }
            this.down = true;
            e.translatePoint(JTableCanvas.this.offX, JTableCanvas.this.offY);
            this.start = e.getY() / JTableCanvas.this.ch;
            int[] i = new int[]{0};
            JTableCanvas.this.header.findTarget(e, i);
            if (JTableCanvas.this.edX == i[0] && JTableCanvas.this.edY == this.start) {
                return;
            }
            JTableCanvas.this.stopEditing();
            if (!JTableCanvas.this.isSelectable) {
                return;
            }
            if (!JTableCanvas.this.isMulti) {
                int sel;
                this.mode = 3;
                if (JTableCanvas.this.selections.size() > 1) {
                    JTableCanvas.this.clearSelections();
                }
                if ((sel = JTableCanvas.this.getSelection()) != this.start) {
                    JTableCanvas.this.remSelection(sel);
                    JTableCanvas.this.addSelection(this.start);
                }
            } else if (e.isControlDown()) {
                this.mode = 2;
                if (JTableCanvas.this.isSelected(this.start)) {
                    JTableCanvas.this.remSelection(this.start);
                } else {
                    JTableCanvas.this.addSelection(this.start);
                }
            } else if (e.isShiftDown()) {
                this.mode = 1;
                JTableCanvas.this.addSelection(this.start);
            } else {
                this.mode = 0;
                if (JTableCanvas.this.selections.size() != 1 || !JTableCanvas.this.isSelected(this.start)) {
                    JTableCanvas.this.clearSelections();
                    JTableCanvas.this.addSelection(this.start);
                    JTableCanvas.this.repaintLines(this.start, this.start + 1);
                }
            }
            this.prevEnd = this.start;
        }

        public void mouseReleased(MouseEvent e) {
            int start;
            int[] i;
            this.down = false;
            if (e.getClickCount() > 1) {
                i = new int[]{0};
                e.translatePoint(JTableCanvas.this.offX, JTableCanvas.this.offY);
                start = e.getY() / JTableCanvas.this.ch;
                JTableCanvas.this.header.findTarget(e, i);
                JTableCanvas.this.binderDoubleCellSelection().notifyTargets(new Point(i[0], start));
            }
            if (JTableCanvas.this.isCellEditable && (e.getClickCount() > 1 || !JTableCanvas.this.isSelectable && e.getClickCount() == 1)) {
                i = new int[]{0};
                e.translatePoint(JTableCanvas.this.offX, JTableCanvas.this.offY);
                start = e.getY() / JTableCanvas.this.ch;
                JTableCanvas.this.header.findTarget(e, i);
                if (JTableCanvas.this.doEdit(i[0], start)) {
                    return;
                }
            }
            JTableCanvas.this.binderRowSelection.notifyTargets("release");
        }

        public void mouseMoved(MouseEvent e) {
            this.down = false;
        }

        public void mouseDragged(MouseEvent e) {
            e.translatePoint(0, JTableCanvas.this.offY);
            int end = e.getY() / JTableCanvas.this.ch;
            if (JTableCanvas.this.isSelectable && this.mode < 3) {
                if (end == this.prevEnd) {
                    return;
                }
                if (this.mode == 0) {
                    JTableCanvas.this.clearSelectionsQuiet();
                    int n = Math.min(this.start, end);
                    while (n <= Math.max(this.start, end)) {
                        JTableCanvas.this.addSelectionQuiet(n);
                        ++n;
                    }
                } else if (this.mode >= 1) {
                    int n = Math.min(this.prevEnd, end);
                    while (n <= Math.max(this.prevEnd, end)) {
                        if (JTableCanvas.this.isSelected(n) && this.mode == 2) {
                            JTableCanvas.this.remSelectionQuiet(n);
                        } else {
                            JTableCanvas.this.addSelectionQuiet(n);
                        }
                        ++n;
                    }
                }
                JTableCanvas.this.repaintLines(Math.min(this.prevEnd, end), Math.max(end, this.prevEnd) + 1);
                this.prevEnd = end;
            }
            if (end <= JTableCanvas.this.offY / JTableCanvas.this.ch) {
                JTableCanvas.this.binderShouldScrollY().notifyTargets(JTableCanvas.this.offY - JTableCanvas.this.ch);
            }
            if (end >= (JTableCanvas.this.offY + JTableCanvas.this.size().height) / JTableCanvas.this.ch - 1) {
                JTableCanvas.this.binderShouldScrollY().notifyTargets(JTableCanvas.this.offY + JTableCanvas.this.ch);
            }
        }
    }
}

