/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.IVisual;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;

public class JWArrowVisual
implements IVisual,
Serializable {
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    protected Color fgcolor;
    protected Color bgcolor;
    protected int direction;
    Dimension dim = new Dimension(0, 0);
    int hackXOff;
    int hackYOff;
    boolean border = false;

    public JWArrowVisual(int direction, Color fgcolor, Color bgcolor) {
        this.bgcolor = bgcolor;
        this.fgcolor = fgcolor;
        this.direction = direction;
    }

    public JWArrowVisual(int direction, Color fgcolor, Color bgcolor, int w, int h) {
        this(direction, fgcolor, bgcolor);
        this.dim.width = w;
        this.dim.height = h;
    }

    public JWArrowVisual(int direction, Color fgcolor, Color bgcolor, int w, int h, int hx, int hy) {
        this(direction, fgcolor, bgcolor);
        this.dim.width = w;
        this.dim.height = h;
        this.hackXOff = hx;
        this.hackYOff = hy;
    }

    public void paint(Graphics g, int width0, int height0) {
        int width = width0;
        int height = height0;
        if (this.border) {
            g.translate(2, 2);
        }
        int brgb = this.fgcolor.getRGB();
        int crgb = this.bgcolor.getRGB();
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, width -= this.hackXOff, height -= this.hackYOff);
        --width;
        --height;
        if (this.direction == 2 || this.direction == 3) {
            width -= 3;
        }
        if (this.direction == 0 || this.direction == 1) {
            height -= 3;
        }
        g.translate(this.direction == 2 ? 2 : 0, this.direction == 0 ? 2 : 0);
        g.translate(this.direction == 3 ? 1 : 0, this.direction == 1 ? 1 : 0);
        if ((this.direction & 2) == 0) {
            int dist = height / 2;
            int foot = Math.min((width + 2) / 4, dist);
            int len = foot + foot;
            int offs = width / 2 - foot;
            int run = 0;
            int pos = (this.direction & 1) != 0 ? 1 + dist / 2 : height - 2 - dist / 2;
            while (len > 0) {
                g.setColor(new Color(JWidgetsUtil.FakeAlphaColor(crgb, brgb, run, dist)));
                g.drawLine(offs, pos, offs + len, pos);
                g.setColor(this.fgcolor);
                g.drawLine(offs + 1, pos, offs + len - 1, pos);
                pos += (this.direction & 1) != 0 ? 1 : -1;
                if ((run += foot) < dist) continue;
                run %= dist;
                ++offs;
                len -= 2;
            }
            g.drawLine(offs, pos, offs + len, pos);
        } else {
            int dist = width / 2;
            int foot = Math.min((height + 2) / 4, dist);
            int len = foot + foot;
            int offs = height / 2 - foot;
            int run = 0;
            int pos = (this.direction & 1) != 0 ? 1 + dist / 2 : width - 2 - dist / 2;
            while (len > 0) {
                g.setColor(new Color(JWidgetsUtil.FakeAlphaColor(crgb, brgb, run, dist)));
                g.drawLine(pos, offs, pos, offs + len);
                g.setColor(this.fgcolor);
                g.drawLine(pos, offs + 1, pos, offs + len - 1);
                pos += (this.direction & 1) != 0 ? 1 : -1;
                if ((run += foot) < dist) continue;
                run %= dist;
                ++offs;
                len -= 2;
            }
            g.drawLine(pos, offs, pos, offs + len);
        }
        g.setColor(this.bgcolor);
        g.translate(this.direction == 2 ? -2 : 0, this.direction == 0 ? -2 : 0);
        g.translate(this.direction == 3 ? -1 : 0, this.direction == 1 ? -1 : 0);
        if (this.border) {
            g.translate(-2, -2);
            g.setColor(JWColor.For("background.+"));
            g.drawLine(2, 1, width0, 1);
            g.drawLine(2, 1, 2, height0);
            g.setColor(Color.black);
            g.drawLine(2, height0 - 1, width0, height0 - 1);
            g.drawLine(width0 - 1, height0, width0 - 1, 1);
        }
    }

    public void setHackYOff(int hackYOff) {
        this.hackYOff = hackYOff;
    }

    public void setHackXOff(int hackXOff) {
        this.hackXOff = hackXOff;
    }

    public Dimension preferredSize() {
        return this.dim;
    }

    public IVisual clone(String kind) {
        return this;
    }
}

