/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWColorWheelVisual;
import de.netcomputing.anyj.jwidgets.NCPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

public class JWColorWheelPanel
extends NCPanel {
    JWColorWheelVisual cwheel;
    Point hotspot = new Point();

    public void init() {
        super.init();
        this.cwheel = new JWColorWheelVisual();
        this.cwheel.setBackground(JWColor.For("background"));
        this.cwheel.init();
        Dimension d = this.getSize();
        this.hotspot.x = d.width / 2;
        this.hotspot.y = d.height / 2;
    }

    public void jwPaint(Graphics g) {
        Dimension d = this.getSize();
        this.cwheel.paint(g, d.width, d.height);
        g.setColor(Color.black);
        g.drawRect(this.hotspot.x - 2, this.hotspot.y - 2, 4, 4);
    }

    public Color getSelection() {
        return this.getColor(this.hotspot.x, this.hotspot.y);
    }

    public Color getColor(int x, int y) {
        return this.cwheel.getColorConstrained(x, y);
    }

    public float getBrightness() {
        return this.cwheel.getBrightness();
    }

    public void setBrightness(float brightness) {
        this.cwheel.setBrightness(brightness);
        this.repaint();
    }

    public void setSelection(int x, int y) {
        this.hotspot.x = x;
        this.hotspot.y = y;
        this.repaint();
    }

    public void setSelection(Color color) {
        this.cwheel.setColor(color);
        this.hotspot = this.cwheel.getHotspot(color);
        this.repaint();
    }

    public Color getSelectedColor() {
        return this.getColor(this.hotspot.x, this.hotspot.y);
    }
}

