/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.application.NCFrame;
import de.netcomputing.anyj.jwidgets.IJComponent;
import de.netcomputing.anyj.jwidgets.IToolTipable;
import de.netcomputing.util.Tracer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;

public class JWToolTipManager
implements MouseMotionListener,
Runnable {
    public static boolean Disabled = false;
    Component act = null;
    Font font = new Font("SansSerif", 0, 11);
    int tipCount;
    Thread tipThread;
    Window win;
    int lastX;
    int lastY;
    String text;
    Hashtable tips = new Hashtable();
    boolean dontStartUntilMouseEntered = false;
    MouseListener ml = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            JWToolTipManager.this.stopTip();
            JWToolTipManager.this.dontStartUntilMouseEntered = true;
        }

        public void mouseEntered(MouseEvent e) {
            JWToolTipManager.this.dontStartUntilMouseEntered = false;
        }

        public void mouseExited(MouseEvent e) {
            JWToolTipManager.this.stopTip();
            JWToolTipManager.this.dontStartUntilMouseEntered = false;
        }
    };
    String prevAct;

    public Window newWindow(Component parent) {
        if (this.win != null) {
            this.win.hide();
            this.win.setLocation(-1000, 1000);
            this.win.dispose();
        }
        while (!(parent instanceof Window)) {
            parent = parent.getParent();
        }
        return new Window((Frame)parent){

            public void update(Graphics g) {
                this.paint(g);
            }

            public void paint(Graphics g) {
                Dimension d = this.getSize();
                g.setColor(Color.white);
                g.fillRect(0, 0, d.width, d.height);
                g.setColor(Color.black);
                g.drawRect(0, 0, d.width - 1, d.height - 1);
                g.setFont(JWToolTipManager.this.font);
                g.drawString(JWToolTipManager.this.text, 3, g.getFontMetrics(JWToolTipManager.this.font).getMaxAscent() + 1);
            }
        };
    }

    public JWToolTipManager() {
        this.tipThread = new Thread(this);
        this.tipThread.setPriority(1);
        this.tipThread.setDaemon(true);
        this.tipThread.start();
    }

    public void remTool(Component obj) {
        obj.removeMouseMotionListener(this);
        obj.removeMouseListener(this.ml);
        this.tips.remove(obj);
    }

    public void addTool(Component obj, String text) {
        if (Disabled) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (this.tips.get(obj) != null) {
            obj.removeMouseMotionListener(this);
            obj.removeMouseListener(this.ml);
        }
        obj.addMouseMotionListener(this);
        obj.addMouseListener(this.ml);
        this.tips.put(obj, text);
    }

    public void mouseDragged(MouseEvent e) {
        this.stopTip();
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getSource() instanceof Component) {
            this.act = (Component)e.getSource();
            this.lastX = e.getX() + this.act.getLocationOnScreen().x;
            this.lastY = e.getY() + this.act.getLocationOnScreen().y;
            this.startTip();
        }
    }

    void startTip() {
        this.tipCount = 0;
        if (this.win != null) {
            this.win.hide();
            this.win.setLocation(-1000, 1000);
            this.win.dispose();
            this.win = null;
        }
        try {
            if (!((NCFrame)((IJComponent)((Object)this.act)).getFrame()).isActive()) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tipThread.resume();
    }

    void stopTip() {
        this.tipThread.suspend();
        if (this.win != null) {
            this.win.hide();
            this.win.setLocation(-1000, 1000);
            this.win.dispose();
            this.win = null;
        }
        this.act = null;
    }

    public void run() {
        while (true) {
            ++this.tipCount;
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace(Tracer.This);
            }
            if (this.tipCount <= 0 || this.act == null) continue;
            if (this.win != null) {
                this.win.hide();
                this.win.setLocation(-1000, 1000);
                this.win.dispose();
                this.win = null;
            }
            if (this.tips.get(this.act) == null) continue;
            this.text = this.act instanceof IToolTipable ? ((IToolTipable)((Object)this.act)).getToolTipText() : (String)this.tips.get(this.act);
            if (this.text == null || this.prevAct == this.text) continue;
            this.win = this.newWindow(this.act);
            int w = this.win.getFontMetrics(this.font).stringWidth(this.text);
            int h = this.win.getFontMetrics(this.font).getHeight();
            int x = this.lastX + 20;
            int y = this.lastY + 20;
            if (x + w + 6 > Toolkit.getDefaultToolkit().getScreenSize().width) {
                x -= x + w + 6 - Toolkit.getDefaultToolkit().getScreenSize().width;
            }
            this.win.setBounds(x, y, w + 6, h + 2);
            this.win.show();
            this.dontStartUntilMouseEntered = true;
            this.tipCount = Math.min(-2, -this.text.length() / 7);
            this.prevAct = this.text;
        }
    }
}

