/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import de.netcomputing.anyj.jwidgets.BasicListItem;
import de.netcomputing.anyj.jwidgets.Binder;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.IListPanelDragDelegate;
import de.netcomputing.anyj.jwidgets.IValue;
import de.netcomputing.anyj.jwidgets.JCanvas;
import de.netcomputing.anyj.jwidgets.JListPanel;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWMenuBar;
import de.netcomputing.anyj.jwidgets.JWScrollable;
import de.netcomputing.util.NCGraphicUtilities;
import editapp.EditApp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import netcomputing.tools.Platforms;

public class ListCanvas
extends JCanvas
implements IValue,
JWScrollable {
    public int indent = 18;
    public int maxWidth = 0;
    public int maxIndent = 0;
    boolean fitOnFirstPaint = false;
    boolean dragEnabled;
    IListPanelDragDelegate dragDelegate;
    int sel = -1;
    int dy = 0;
    int oldSize = 0;
    Vector theList = new Vector();
    boolean updateLock;
    int offX;
    int offY;
    public boolean doDrawLines = true;
    public boolean allowSelection = true;
    Binder binderLowLevel = new Binder(this);
    Binder binderMouseSel = new Binder(this);
    boolean tree = true;
    boolean drawIndent = false;
    int oldListSize = 0;
    int hiIndex = -1;
    boolean mouseDown;
    IListItem dragItem;
    int downX;
    int downY;
    boolean isDragging = false;

    public Binder binderLowLevel() {
        return this.binderLowLevel;
    }

    public Binder binderMouseSel() {
        return this.binderMouseSel;
    }

    public void init() {
        super.init();
        this.dy = 10;
        this.sel = -1;
        this.offY = 0;
        this.offX = 0;
        this.setLayout(null);
        this.addMouseListener(new ML());
        this.addMouseMotionListener(new ML());
        this.setToolTipText("");
    }

    public void setDragDelegate(IListPanelDragDelegate dragDelegate) {
        this.dragDelegate = dragDelegate;
    }

    public IListPanelDragDelegate getDragDelegate() {
        return this.dragDelegate;
    }

    public String getToolTipText(MouseEvent ev) {
        int y;
        int x = ev.getX() + this.offX;
        IListItem item = this.getItemFrom(x, y = ev.getY());
        if (item instanceof BasicListItem) {
            String s = ((BasicListItem)item).getDisplayString();
            int w = item.widthIn(this);
            if (w + item.getDepth() * this.indent >= this.offX + this.getWidth() || item.getDepth() * this.indent < this.offX) {
                return s;
            }
        }
        return null;
    }

    public void setTree(boolean b) {
        this.tree = b;
    }

    public Object actionOpenMenu(Object a, Object s) {
        int selIdx = this.getSelectionIndex();
        int y = 0;
        if (selIdx >= 0) {
            y = selIdx * this.dy - this.offY;
            this.openMenu(this, 10, y + this.dy);
        }
        return null;
    }

    public boolean isOpaque() {
        return true;
    }

    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        EditApp.SetLastSelectionProvider((JListPanel)this.getParent());
        if (this.getSelectionIndex() >= 0) {
            this.repaintAsyncStartingAt(this.getSelectionIndex(), 1);
        }
    }

    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (this.getSelectionIndex() >= 0) {
            this.repaintAsyncStartingAt(this.getSelectionIndex(), 1);
        }
    }

    public Object value() {
        return this.sel >= 0 && this.sel < this.listSize() ? this.at(this.sel) : null;
    }

    public int intValue() {
        return this.sel;
    }

    public double doubleValue() {
        return this.sel;
    }

    public String stringValue() {
        return new Integer(this.sel).toString();
    }

    public void lockUpdate(boolean b) {
        this.updateLock = b;
    }

    public int getSelectionIndex() {
        return this.intValue();
    }

    public int getOffset() {
        return this.offY / this.dy;
    }

    public int getVisibleRange() {
        return this.size().height / this.dy + 1;
    }

    public IListItem getSelectedItem() {
        return (IListItem)this.value();
    }

    public void setSelectionIndex(int i) {
        this.setSelection(i);
    }

    public void addItem(IListItem t) {
        this.theList.addElement(t);
    }

    public void addItemAt(int i, IListItem t) {
        this.theList.insertElementAt(t, i);
    }

    public void removeItem(IListItem t) {
        this.theList.removeElement(t);
    }

    public void removeAt(int idx) {
        this.theList.removeElementAt(idx);
    }

    public IListItem at(int idx) {
        return (IListItem)this.theList.elementAt(idx);
    }

    public int lastIndexOf(IListItem itn) {
        return this.theList.lastIndexOf(itn);
    }

    public int indexOf(IListItem itn) {
        return this.theList.indexOf(itn);
    }

    public void setList(Vector list, double newOffset, int newSelection) {
        this.theList = list;
        this.setYOffset(Math.min(newOffset, (double)this.listSize()));
        this.setSelection(Math.min(newSelection, this.listSize()));
        this.repaint();
    }

    public Vector getList() {
        return this.theList;
    }

    public int listSize() {
        return this.theList.size();
    }

    public Enumeration elements() {
        return this.theList.elements();
    }

    public void setLineHeight(int height) {
        this.dy = height;
    }

    public int getLineHeight() {
        return this.dy;
    }

    public IListItem getItemFrom(int x, int y) {
        int i = this.getIndexFrom(x, y);
        if (i < 0 || i >= this.listSize()) {
            return null;
        }
        return this.at(i);
    }

    public int getIndexFrom(int x, int y) {
        return (y + this.offY) / this.dy;
    }

    public boolean checkForNewSize() {
        if (this.oldListSize != this.listSize()) {
            this.binderLowLevel().notifyTargets("listSize");
            this.oldListSize = this.listSize();
            return true;
        }
        return false;
    }

    public void repaintStartingAt(int idx) {
        this.repaintStartingAt(idx, this.listSize());
    }

    public void repaintStartingAt(int idx, int length) {
        Dimension d = this.size();
        this.repaint(0, Math.max(0, idx * this.dy - this.offY), d.width, Math.min(length * this.dy, d.height));
    }

    public void repaintAsyncStartingAt(int idx, int length) {
        Dimension d = this.size();
        this.repaint(0, Math.max(0, idx * this.dy - this.offY), d.width, Math.min(length * this.dy, d.height));
    }

    public Color getBackground() {
        if (this.isEnabled()) {
            return super.getBackground();
        }
        return JWColor.For("background");
    }

    void calcMaxSize() {
        int n = 0;
        while (n < this.listSize()) {
            this.dy = Math.max(this.at(n).heightIn(this), this.dy);
            ++n;
        }
    }

    public void preFirstPaint() {
        super.preFirstPaint();
        this.calcMaxSize();
    }

    protected void paint(Graphics g, int startIndex, int length) {
        if (this.checkForNewSize()) {
            // empty if block
        }
        if (this.updateLock) {
            return;
        }
        Dimension d = this.size();
        int maxIndex = Math.min(startIndex + length, d.height / this.dy + this.offY / this.dy + 2);
        startIndex = Math.max(this.offY / this.dy - 1, startIndex);
        g.translate(-this.offX, -this.offY);
        int maxDy = this.dy;
        int oldMaxWidth = this.maxWidth;
        if (startIndex >= this.listSize()) {
            g.setColor(this.getBackground());
            g.fillRect(this.offX, startIndex * this.dy, d.width, this.listSize() * this.dy);
        } else {
            g.setFont(this.getFont());
            int n = startIndex;
            while (n < maxIndex) {
                g.setColor(this.getBackground());
                g.fillRect(this.offX, n * this.dy, d.width, this.dy);
                if (n >= 0 && n < this.listSize()) {
                    int depth = this.tree || this.drawIndent ? this.at(n).getDepth() : 0;
                    this.maxIndent = Math.max(depth, this.maxIndent);
                    this.maxWidth = Math.max(this.maxWidth, this.at(n).widthIn(this));
                    maxDy = Math.max(this.at(n).heightIn(this), maxDy);
                    g.translate(4 + this.indent * depth, n * this.dy);
                    this.at(n).paint(g, this, n == this.sel, this.isContentVisible(n), n);
                    g.translate(-4 - this.indent * depth, -n * this.dy);
                }
                ++n;
            }
        }
        g.setColor(this.getBackground());
        g.fillRect(0, this.listSize() * this.dy, d.width, d.height);
        if (maxDy > this.dy) {
            this.dy = maxDy;
            this.binderLowLevel().notifyTargets("listSize");
            this.paint(g, 0, this.listSize());
            this.repaint();
            return;
        }
        if (this.maxWidth > oldMaxWidth) {
            this.binderLowLevel().notifyTargets("listSize");
        }
        if (this.doDrawLines) {
            this.drawLines(g, startIndex, 0, maxIndex);
        }
        if (this.fitOnFirstPaint) {
            int n = 0;
            while (n < this.listSize()) {
                int depth = this.tree || this.drawIndent ? this.at(n).getDepth() : 0;
                this.maxIndent = Math.max(depth, this.maxIndent);
                this.maxWidth = Math.max(this.maxWidth, this.at(n).widthIn(this));
                maxDy = Math.max(this.at(n).heightIn(this), maxDy);
                ++n;
            }
            this.dy = maxDy;
            Dimension dim = this.preferredSize();
            Point loc = this.getFrame().getLocation();
            Rectangle bounds = new Rectangle(loc.x, loc.y, dim.width + 24, Math.max(100, Math.min(220, dim.height + 8)));
            Dimension screendim = Toolkit.getDefaultToolkit().getScreenSize();
            if (!Platforms.IsLinux()) {
                screendim.height -= 24;
            }
            bounds.height = Math.min(screendim.height - bounds.y - 2, bounds.height);
            bounds.width = Math.min(screendim.width / 3, bounds.width);
            this.getFrame().setBounds(bounds);
            if (Platforms.IsLinux() || Platforms.IsSunVM()) {
                this.getFrame().invalidate();
                this.getParent().setSize(bounds.width, bounds.height);
                this.getParent().invalidate();
                this.getFrame().validate();
                this.repaint();
            }
            this.fitOnFirstPaint = false;
        }
        g.translate(this.offX, this.offY);
    }

    public void jwPaint(Graphics g) {
        if (KunststoffLookAndFeel.ANTIALIASELISTBOX) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        ((JListPanel)this.getParent()).checkComponentValues();
        Rectangle rect = g.getClipRect();
        if (rect == null) {
            Dimension d = this.size();
            rect = new Rectangle(0, 0, d.width, d.height);
            g.setClip(this.offX, 0, d.width, d.height);
        }
        this.paint(g, (this.offY + rect.y) / this.dy, rect.height / this.dy + 2);
    }

    public int drawLines(Graphics g, int startIndex, int actDepth, int maxIndex) {
        int N;
        if (startIndex < 0) {
            startIndex = 1;
        }
        if (startIndex >= (N = this.listSize())) {
            return N;
        }
        int lastDrawn = startIndex * this.dy;
        IListItem cell = this.at(startIndex);
        int itemDepth = cell.getDepth();
        int n = startIndex;
        do {
            if (itemDepth == actDepth + 1) {
                g.setColor(Color.gray);
                int off = cell.hasContent() ? this.dy / 4 : 0;
                int width = (this.dy - 1) / 2;
                int height = (this.dy - 1) / 2;
                if (width / 2 != (width + 1) / 2) {
                    --width;
                    --height;
                }
                width = 8;
                height = 8;
                if (Platforms.IsOSX() || Platforms.IsReallyLinux()) {
                    width = 6;
                    height = 6;
                } else {
                    int n2 = lastDrawn;
                    lastDrawn = n * this.dy + width - off;
                    g.drawLine(actDepth * this.indent + 12, n2, actDepth * this.indent + 12, lastDrawn);
                    lastDrawn += 2 * off;
                    g.drawLine(off + actDepth * this.indent + 12, n * this.dy + width, actDepth * this.indent + 12 + this.indent - 10, n * this.dy + width);
                }
                if (off > 0) {
                    int x = actDepth * this.indent + 12 - this.dy / 4;
                    int y = n * this.dy + this.dy / 4;
                    if (Platforms.IsOSX() || Platforms.IsReallyLinux()) {
                        width += 2;
                        height += 2;
                        if (!this.isContentVisible(n)) {
                            g.setColor(Color.black);
                            g.drawLine(x, y + height / 2, x + width, y + height / 2);
                            g.drawLine(x + width / 2, y, x + width / 2, y + height);
                            g.setColor(Color.gray);
                            g.drawRect(x, y, width, height);
                            g.setColor(this.getBackground());
                            g.drawRect(x + 1, y + 1, width - 2, height - 2);
                        } else {
                            g.setColor(Color.black);
                            g.drawLine(x, y + height / 2, x + width, y + height / 2);
                            g.setColor(Color.gray);
                            g.drawRect(x, y, width, height);
                            g.setColor(this.getBackground());
                            g.drawRect(x + 1, y + 1, width - 2, height - 2);
                        }
                    } else if (!this.isContentVisible(n)) {
                        g.setColor(Color.black);
                        g.drawLine(x, y + height / 2, x + width, y + height / 2);
                        g.drawLine(x + width / 2, y, x + width / 2, y + height);
                        g.setColor(Color.gray);
                        g.drawRect(x, y, width, height);
                        g.setColor(this.getBackground());
                        g.drawRect(x + 1, y + 1, width - 2, height - 2);
                    } else {
                        g.setColor(Color.black);
                        g.drawLine(x, y + height / 2, x + width, y + height / 2);
                        g.setColor(Color.gray);
                        g.drawRect(x, y, width, height);
                        g.setColor(this.getBackground());
                        g.drawRect(x + 1, y + 1, width - 2, height - 2);
                    }
                }
            } else if (itemDepth > actDepth + 1) {
                n = this.drawLines(g, n, actDepth + 1, maxIndex) - 1;
            }
            if (++n < N && (itemDepth > 1 || n <= maxIndex)) continue;
            return N;
        } while ((itemDepth = (cell = this.at(n)).getDepth()) > actDepth);
        return n;
    }

    void openMenu(Component comp, int x, int y) {
        JListPanel par = (JListPanel)this.getParent();
        if (par.getPopUpGetter() != null) {
            this.add(par.getPopUpGetter().getMenu(par, par.getSelectedObject()));
        }
        if (this.menu != null) {
            if (this.menu.getParent() == null) {
                this.add(this.menu);
            }
            ((Window)this.getFrame()).toFront();
            Rectangle pos = new Rectangle(x, y, this.menu.getPreferredSize().width, this.menu.getPreferredSize().height);
            NCGraphicUtilities.adjustScreenPos(pos, comp);
            this.menu.show(comp, pos.x, pos.y);
        }
    }

    public int getHiIndex() {
        return this.hiIndex;
    }

    public void setDragEnabled(boolean dragEnabled) {
        this.dragEnabled = dragEnabled;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public boolean isDragging() {
        return this.dragEnabled && this.mouseDown && this.dragItem != null && this.isDragging;
    }

    public IListItem getDragItem() {
        return this.dragItem;
    }

    public boolean canDrop(IListItem target, IListItem dragItem) {
        if (this.dragDelegate == null) {
            return false;
        }
        return this.dragDelegate.canDrop(target, dragItem);
    }

    void setSelection(int idx) {
        if (idx == this.sel) {
            return;
        }
        int oldSel = this.sel;
        this.sel = idx;
        if (idx < 0 || idx >= this.listSize()) {
            idx = -1;
        }
        this.repaintStartingAt(oldSel, 1);
        this.repaintStartingAt(idx, 1);
        if (Platforms.IsLinux()) {
            this.repaintAsyncStartingAt(oldSel, 1);
            this.repaintAsyncStartingAt(idx, 1);
        }
    }

    void setSelectionRepaintAsync(int idx) {
        if (idx == this.sel) {
            return;
        }
        int oldSel = this.sel;
        this.sel = idx;
        if (idx < 0 || idx >= this.listSize()) {
            idx = -1;
        }
        this.repaintAsyncStartingAt(oldSel, 1);
        this.repaintAsyncStartingAt(idx, 1);
    }

    void setYOffset(double idxOffset) {
    }

    public void expandNode(IListItem t) {
        this.expandNodeAt(this.lastIndexOf(t));
    }

    public void collapseNode(IListItem t) {
        this.collapseNodeAt(this.lastIndexOf(t));
    }

    public boolean isContentVisible(int i) {
        if (i >= this.listSize()) {
            return false;
        }
        IListItem tn = this.at(i);
        return i != this.listSize() - 1 && tn.getDepth() < this.at(i + 1).getDepth();
    }

    public boolean hasContentAt(int i) {
        return this.at(i).contents().length != 0;
    }

    public int expandNodeAt(int i) {
        if (!this.tree || i < 0) {
            return 0;
        }
        IListItem tn = this.at(i);
        if (this.isContentVisible(i)) {
            return 0;
        }
        IListItem[] v = this.at(i).contents();
        int n = 0;
        while (n < v.length) {
            v[n].setDepth(tn.getDepth() + 1);
            this.theList.insertElementAt(v[n], i + n + 1);
            ++n;
        }
        return v.length;
    }

    public int collapseNodeAt(int i) {
        if (!this.tree || i < 0) {
            return 0;
        }
        int res = 0;
        if (this.isContentVisible(i)) {
            int d = this.at(i).getDepth();
            IListItem tn = this.at(i + 1);
            while (i + 1 < this.listSize() && tn.getDepth() > d) {
                this.removeAt(i + 1);
                ++res;
                if (i + 1 >= this.listSize()) continue;
                tn = this.at(i + 1);
            }
            if (this.at(i) instanceof BasicListItem) {
                ((BasicListItem)this.at(i)).itemHasCollapsed();
            }
        }
        return res;
    }

    public void setOffsetX(int x) {
        this.offX = x;
    }

    public void setOffsetY(int y) {
        this.offY = y;
    }

    public Dimension preferredSize() {
        return new Dimension(this.maxWidth + this.maxIndent * this.indent + 8, this.listSize() * this.dy);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public class ML
    extends MouseAdapter
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent e) {
            if (!ListCanvas.this.isDragging && (Math.abs(e.getX() - ListCanvas.this.downX) > 4 || Math.abs(e.getY() - ListCanvas.this.downY) > 4) && ListCanvas.this.dragDelegate != null && ListCanvas.this.dragDelegate.canDrag(ListCanvas.this.dragItem)) {
                ListCanvas.this.isDragging = true;
            }
            if (ListCanvas.this.dragEnabled) {
                int y;
                int x = e.getX() + ListCanvas.this.offX;
                int i = ListCanvas.this.getIndexFrom(x, y = e.getY());
                if (i >= ListCanvas.this.getOffset() + ListCanvas.this.getVisibleRange() || i < ListCanvas.this.getOffset() + 1) {
                    ((JListPanel)ListCanvas.this.getParent()).scrollToVisibleY(i * ListCanvas.this.dy - 3, i * ListCanvas.this.dy + 1);
                }
                if (i >= 0 && i < ListCanvas.this.listSize()) {
                    int oldHi = ListCanvas.this.hiIndex;
                    ListCanvas.this.hiIndex = i;
                    if (oldHi >= 0) {
                        ListCanvas.this.repaintStartingAt(oldHi - 1, 2);
                    }
                    ListCanvas.this.repaintStartingAt(ListCanvas.this.hiIndex - 1, 3);
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            if (ListCanvas.this.hiIndex >= 0) {
                int tmp = ListCanvas.this.hiIndex;
                ListCanvas.this.hiIndex = -1;
                ListCanvas.this.repaintStartingAt(tmp, 1);
            }
        }

        public void mouseMoved(MouseEvent e) {
            int y;
            int x = e.getX() + ListCanvas.this.offX;
            int i = ListCanvas.this.getIndexFrom(x, y = e.getY());
            if (i >= 0 && i < ListCanvas.this.listSize()) {
                int oldHi = ListCanvas.this.hiIndex;
                ListCanvas.this.hiIndex = i;
                if (oldHi >= 0) {
                    ListCanvas.this.repaintStartingAt(oldHi, 1);
                }
                ListCanvas.this.repaintStartingAt(ListCanvas.this.hiIndex, 1);
            }
        }

        public void mousePressed(MouseEvent e) {
            ListCanvas.this.downX = e.getX();
            ListCanvas.this.downY = e.getY();
            EditApp.SetLastSelectionProvider((JListPanel)ListCanvas.this.getParent());
            if (e.isAltDown() || (e.getModifiers() & 0xC) != 0) {
                int x = e.getX() + ListCanvas.this.offX;
                int y = e.getY();
                IListItem item = ListCanvas.this.getItemFrom(x, y);
                Dimension d = ListCanvas.this.getSize();
                if (x > 0 && x < d.width + ListCanvas.this.offX && y >= 0 && y <= d.height) {
                    int i = ListCanvas.this.getIndexFrom(x, y);
                    if (Platforms.IsLinux()) {
                        ListCanvas.this.setSelectionRepaintAsync(i);
                    } else {
                        ListCanvas.this.setSelection(i);
                    }
                    ListCanvas.this.binderLowLevel().notifyTargets("selection");
                    ListCanvas.this.binderMouseSel().notifyTargets(i);
                }
            } else {
                ListCanvas.this.mouseDown = true;
                if (ListCanvas.this.dragEnabled) {
                    int x = e.getX() + ListCanvas.this.offX;
                    int y = e.getY();
                    ListCanvas.this.dragItem = ListCanvas.this.getItemFrom(x, y);
                }
                ListCanvas.this.requestFocus();
                JWMenuBar.ResetMenu();
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            int y;
            if (e.isAltDown() || (e.getModifiers() & 0xC) != 0) {
                int x = e.getX() + ListCanvas.this.offX;
                int y2 = e.getY();
                IListItem item = ListCanvas.this.getItemFrom(x, y2);
                Dimension d = ListCanvas.this.getSize();
                if (x > 0 && x < d.width + ListCanvas.this.offX && y2 >= 0 && y2 <= d.height) {
                    int i = ListCanvas.this.getIndexFrom(x, y2);
                    if (Platforms.IsLinux()) {
                        ListCanvas.this.setSelectionRepaintAsync(i);
                    } else {
                        ListCanvas.this.setSelection(i);
                    }
                    ListCanvas.this.binderLowLevel().notifyTargets("selection");
                    ListCanvas.this.binderMouseSel().notifyTargets(i);
                }
                ListCanvas.this.openMenu(e.getComponent(), e.getX() - 20, e.getY());
                e.consume();
                ListCanvas.this.dragItem = null;
                ListCanvas.this.dragItem = null;
                ListCanvas.this.downX = 0;
                ListCanvas.this.downY = 0;
                ListCanvas.this.isDragging = false;
                ListCanvas.this.mouseDown = false;
                return;
            }
            if (!ListCanvas.this.mouseDown || e.isPopupTrigger() || !ListCanvas.this.allowSelection || ListCanvas.this.dragItem != null && ListCanvas.this.isDragging()) {
                ListCanvas.this.mouseDown = false;
                if (ListCanvas.this.dragItem != null) {
                    ListCanvas.this.repaintStartingAt(ListCanvas.this.getHiIndex() - 1, 3);
                    if (ListCanvas.this.dragDelegate != null && ListCanvas.this.getHiIndex() < ListCanvas.this.listSize() && ListCanvas.this.getHiIndex() >= 0 && ListCanvas.this.dragDelegate.canDrop(ListCanvas.this.at(ListCanvas.this.getHiIndex()), ListCanvas.this.dragItem)) {
                        ListCanvas.this.dragDelegate.move(ListCanvas.this.at(ListCanvas.this.getHiIndex()), ListCanvas.this.dragItem);
                    }
                }
                ListCanvas.this.dragItem = null;
                ListCanvas.this.downX = 0;
                ListCanvas.this.downY = 0;
                ListCanvas.this.isDragging = false;
                return;
            }
            ListCanvas.this.downX = 0;
            ListCanvas.this.downY = 0;
            ListCanvas.this.isDragging = false;
            ListCanvas.this.mouseDown = false;
            ListCanvas.this.dragItem = null;
            int x = e.getX() + ListCanvas.this.offX;
            IListItem item = ListCanvas.this.getItemFrom(x, y = e.getY());
            if (item != null && x > ListCanvas.this.indent * item.getDepth() - 12 && x < ListCanvas.this.indent * item.getDepth() + item.hotZoneX(ListCanvas.this)) {
                int i = ListCanvas.this.getIndexFrom(x, y);
                if (i >= 0 && i < ListCanvas.this.listSize() && e.getClickCount() < 2) {
                    if (x > ListCanvas.this.indent * item.getDepth()) {
                        if (((JListPanel)ListCanvas.this.getParent()).getSelectOnIconClick()) {
                            ListCanvas.this.setSelection(i);
                        }
                        ListCanvas.this.binderLowLevel().notifyTargets("selection");
                        ((JListPanel)ListCanvas.this.getParent()).binderIconClick().notifyTargets(i);
                        if (!ListCanvas.this.doDrawLines && ListCanvas.this.tree) {
                            ((JListPanel)ListCanvas.this.getParent()).binderCornerClick().notifyTargets(i);
                            ((JListPanel)ListCanvas.this.getParent()).switchNodeAt(i);
                        }
                    } else if (ListCanvas.this.doDrawLines) {
                        ((JListPanel)ListCanvas.this.getParent()).binderCornerClick().notifyTargets(i);
                        ((JListPanel)ListCanvas.this.getParent()).switchNodeAt(i);
                    }
                }
            } else {
                Dimension d = ListCanvas.this.getSize();
                if (x > 0 && x < d.width + ListCanvas.this.offX && y >= 0 && y <= d.height) {
                    int i = ListCanvas.this.getIndexFrom(x, y);
                    ListCanvas.this.setSelection(i);
                    ListCanvas.this.binderLowLevel().notifyTargets("selection");
                    if (e.getClickCount() == 2) {
                        ListCanvas.this.binderLowLevel().notifyTargets("doubleSelection");
                    }
                    ListCanvas.this.binderMouseSel().notifyTargets(i);
                }
            }
        }
    }
}

