/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import java.io.Serializable;
import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class NCBoundedRangeModel
implements BoundedRangeModel,
Serializable {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private int value = 0;
    private int extent = 0;
    private int min = 0;
    private int max = 100;
    private boolean isAdjusting = false;
    public boolean isEditor = false;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public NCBoundedRangeModel() {
    }

    public NCBoundedRangeModel(int value, int extent, int min, int max) {
        if (max < min || value < min || value + extent < value || value + extent > max) {
            throw new IllegalArgumentException("invalid range properties");
        }
        this.value = value;
        this.extent = extent;
        this.min = min;
        this.max = max;
    }

    public int getValue() {
        return this.value;
    }

    public int getExtent() {
        return this.extent;
    }

    public int getMinimum() {
        return this.min;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setValue(int n) {
        int newValue = Math.max(0, n);
        this.setRangeProperties(newValue, this.extent, this.min, this.max, this.isAdjusting);
    }

    public void setExtent(int n) {
        int newExtent = n;
        this.setRangeProperties(this.value, newExtent, this.min, this.max, this.isAdjusting);
    }

    public void setMinimum(int n) {
        n = Math.max(0, n);
        this.setRangeProperties(this.value, this.extent, n, this.max, this.isAdjusting);
    }

    public void setMaximum(int n) {
        int newVal = n;
        this.setRangeProperties(this.value, this.extent, this.min, newVal, this.isAdjusting);
    }

    public void setValueIsAdjusting(boolean b) {
        this.setRangeProperties(this.value, this.extent, this.min, this.max, b);
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void setRangeProperties(int newValue, int newExtent, int newMin, int newMax, boolean adjusting) {
        boolean isChange;
        boolean bl = isChange = newValue != this.value || newExtent != this.extent || newMin != this.min || newMax != this.max || adjusting != this.isAdjusting;
        if (isChange) {
            this.value = newValue;
            this.extent = newExtent;
            this.min = newMin;
            this.max = newMax;
            this.isAdjusting = adjusting;
            this.fireStateChanged();
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = NCBoundedRangeModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = NCBoundedRangeModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$ChangeListener == null ? NCBoundedRangeModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public String toString() {
        String modelString = "value=" + this.getValue() + ", " + "extent=" + this.getExtent() + ", " + "min=" + this.getMinimum() + ", " + "max=" + this.getMaximum() + ", " + "adj=" + this.getValueIsAdjusting();
        return this.getClass().getName() + "[" + modelString + "]";
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

