/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.parsing;

import Jack.InputObject;
import Jxe.DocumentStream;
import Jxe.JXEOptions;
import Jxe.TextDocument;
import Jxe.TextView;
import JxeExtensions.ExtBeautifyCode;
import de.netcomputing.anyj.parsing.Scope;
import de.netcomputing.anyj.parsing.SyntaxAnalyzer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ExtractMethod
extends SyntaxAnalyzer {
    TextDocument doc;
    Vector argList = new Vector();
    String args;
    String methodName;
    String firstDefVar;
    int lastMethodLine = -1;
    int lastMethodEndLine = -1;
    HashMap referencedVars = new HashMap();
    HashMap definedVars = new HashMap();
    ArrayList returnValues = new ArrayList();
    int stopSearchLine = 9999999;

    public ExtractMethod(TextDocument doc) {
        this.doc = doc;
        this.firstDefVar = null;
    }

    public void doInsert(TextDocument toPaste) {
        boolean oldVal = JXEOptions.FORMATONPASTE;
        JXEOptions.FORMATONPASTE = false;
        int off = this.doc.getSelection().size() - 1;
        this.doc.cutSelection();
        String decl = "";
        if (this.firstDefVar != null) {
            decl = this.definedVars.get(this.firstDefVar) + " " + this.firstDefVar + " = ";
        }
        TextView tv = this.doc.getView();
        this.doc.setView(null);
        this.doc.insertAndMove(decl + this.methodName + this.args + ";");
        int x = this.doc.cX();
        int y = this.doc.cY();
        this.doc.insertLine(this.lastMethodEndLine - off, "");
        this.doc.moveCursorAbs(0, this.lastMethodEndLine - off + 1);
        this.doc.pasteDoc(toPaste);
        this.doc.moveCursorAbs(x, y);
        this.doc.setView(tv);
        this.doc.repaint();
        JXEOptions.FORMATONPASTE = oldVal;
    }

    public TextDocument prepareDocument(String methodName, String modifier) {
        this.methodName = methodName;
        TextDocument toPaste = null;
        boolean oldVal = JXEOptions.FORMATONPASTE;
        JXEOptions.FORMATONPASTE = false;
        if (this.lastMethodLine > 0) {
            toPaste = this.doc.getSelection();
            String type = "void ";
            if (this.firstDefVar != null) {
                type = this.definedVars.get(this.firstDefVar).toString() + " ";
            }
            String header = this.doc.constructSpace(JXEOptions.INDENT).toString() + modifier + type + methodName + "(";
            String args = "(";
            Vector v = this.getArgList();
            int i = 0;
            while (i < v.size()) {
                String name = (String)v.get(i);
                header = header + " " + this.referencedVars.get(name) + " " + name + ",";
                args = args + " " + name + ",";
                ++i;
            }
            if (header.endsWith(",")) {
                header = header.substring(0, header.length() - 1);
                args = args.substring(0, args.length() - 1);
            }
            if (v.size() > 0) {
                header = header + " ";
                args = args + " ";
            }
            header = header + ")";
            this.args = args = args + ")";
            toPaste.insertLine(0, "{");
            toPaste.insertLine(0, header);
            if (this.firstDefVar != null) {
                toPaste.addLine("return " + this.firstDefVar + ";");
            }
            toPaste.addLine(this.doc.constructSpace(JXEOptions.INDENT).toString() + "}");
            toPaste.addLine("");
            ExtBeautifyCode.Format(toPaste);
            int i2 = 0;
            while (i2 < toPaste.size()) {
                toPaste.insertTabInternal(i2, JXEOptions.INDENT);
                ++i2;
            }
        }
        JXEOptions.FORMATONPASTE = oldVal;
        return toPaste;
    }

    public void parseAndInit() throws Exception {
        this.doc.trimSelection();
        Vector v = this.parseBuildingScope(new DocumentStream(this.doc, 0, 0), new Scope("root", null));
        if (v.size() != 1) {
            throw new RuntimeException("Parse Failure, file must not contain syntax errors");
        }
        this.findCurrentMethod((InputObject)v.get(0), this.rootScope);
        Iterator defined = this.definedVars.keySet().iterator();
        while (defined.hasNext()) {
            this.referencedVars.remove(defined.next());
        }
        this.referencedVars.remove("this");
        this.referencedVars.remove("super");
        if (this.returnValues.size() > 0) {
            this.firstDefVar = (String)this.returnValues.iterator().next();
        }
        Iterator it = this.getReferencedVars().keySet().iterator();
        while (it.hasNext()) {
            this.argList.add(it.next());
        }
        while (this.lastMethodEndLine >= 0 && this.doc.lineAt(this.lastMethodEndLine).toString().indexOf("}") < 0) {
            --this.lastMethodEndLine;
        }
        ++this.lastMethodEndLine;
    }

    public void setArgList(Vector argList) {
        this.argList = argList;
    }

    public Vector getArgList() {
        return this.argList;
    }

    public void setReferencedVars(HashMap referencedVars) {
        this.referencedVars = referencedVars;
    }

    public HashMap getReferencedVars() {
        return this.referencedVars;
    }

    public void setDefinedVars(HashMap definedVars) {
        this.definedVars = definedVars;
    }

    public HashMap getDefinedVars() {
        return this.definedVars;
    }

    void findCurrentMethod(InputObject obj, Scope currentScope) {
        if (obj.linePosition() > this.stopSearchLine) {
            return;
        }
        switch (obj.getIntVal()) {
            case 65626: 
            case 65627: {
                this.lastMethodLine = obj.linePosition();
                this.lastMethodEndLine = obj.lineEndPosition();
            }
        }
        if (obj.linePosition() >= this.doc.selStartY()) {
            this.stopSearchLine = this.lastMethodEndLine;
            switch (obj.getIntVal()) {
                case 65610: {
                    if (obj.linePosition() > this.doc.selEndY()) break;
                    InputObject[] cont = obj.getContent();
                    String type = "unknowntype";
                    int startIdx = cont[0].getIntVal() == 65604 ? 1 : 0;
                    type = cont[startIdx].toString();
                    int n = startIdx + 1;
                    while (cont != null && n < cont.length && cont[n].getIntVal() != 65592) {
                        if (cont[n].getIntVal() == 65537) {
                            this.definedVars.put(cont[n].toString(), type);
                        } else if (cont[n].getIntVal() == 65612) {
                            InputObject[] contCList = cont[n].getContent();
                            int nn = 0;
                            while (contCList != null && nn < contCList.length && contCList[nn].getIntVal() != 65592) {
                                if (contCList[nn].getIntVal() == 65537) {
                                    this.definedVars.put(contCList[nn].toString(), type);
                                }
                                ++nn;
                            }
                        }
                        ++n;
                    }
                    break;
                }
                case 65537: {
                    String type = currentScope.getVarTypeFromLocals(obj.toString());
                    if (type == null) break;
                    int i = type.lastIndexOf(46);
                    if (i >= 0) {
                        type = type.substring(i + 1);
                    }
                    if (obj.linePosition() <= this.doc.selEndY()) {
                        this.referencedVars.put(obj.toString(), type);
                    }
                    if (obj.linePosition() <= this.doc.selEndY() || this.definedVars.get(obj.toString()) == null) break;
                    this.returnValues.add(obj.toString());
                    break;
                }
                case 65602: {
                    String type = currentScope.getVarTypeFromLocals(obj.getContent()[0].toString());
                    if (type != null) {
                        int i = type.lastIndexOf(46);
                        if (i >= 0) {
                            type = type.substring(i + 1);
                        }
                        if (obj.linePosition() <= this.doc.selEndY()) {
                            this.referencedVars.put(obj.getContent()[0].toString(), type);
                        }
                        if (obj.linePosition() > this.doc.selEndY() && this.definedVars.get(obj.getContent()[0].toString()) != null) {
                            this.returnValues.add(obj.getContent()[0].toString());
                        }
                    }
                    return;
                }
            }
        }
        Scope scop = currentScope;
        InputObject[] cnt = obj.getContent();
        int n = 0;
        while (cnt != null && n < cnt.length) {
            if (cnt[n].getIntVal() == 65597) {
                scop = (Scope)this.scopeMap.get(cnt[n]);
            } else if (cnt[n].getIntVal() == 65598) {
                scop = currentScope;
            }
            this.findCurrentMethod(cnt[n], scop);
            ++n;
        }
    }
}

