/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.scripting;

import JCollections.DirIterator;
import JWVFile.VFile;
import Jxe.TextDocument;
import de.netcomputing.anyj.AJChooseMulti;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.DirDiffResult;
import de.netcomputing.anyj.jwidgets.ISelectedContext;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.scripting.AJExternalService;
import de.netcomputing.anyj.scripting.AJSDirDiffResult;
import de.netcomputing.anyj.scripting.AJSOutput;
import de.netcomputing.anyj.scripting.AJSTextDocument;
import de.netcomputing.application.services.INCService;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.NCStringUtilities;
import editapp.EditApp;
import editapp.IndexEntry;
import editapp.ServiceRegistry;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jxeplugins.JEBatchHostFrame;
import jxeplugins.ScriptService;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import netcomputing.tools.Executor;
import netcomputing.tools.INCExtendedPrintout;
import plugins.InterpreterPlugin;

public class AnyJAPI {
    static AnyJAPI This = new AnyJAPI();

    public static AnyJAPI This() {
        return This;
    }

    public AJSDirDiffResult compareDirs(File a, File b, FilenameFilter filter, boolean ignoreComments, boolean ignoreWhiteSpace) throws Exception {
        DirDiffResult res = NCFileUtilities.compare(a, b, filter, ignoreComments, ignoreWhiteSpace);
        if (res != null) {
            AJSDirDiffResult returnValue = new AJSDirDiffResult(Collections.list(res.getAdded().enumerate()), Collections.list(res.getRemoved().enumerate()), Collections.list(res.getDiffs().enumerate()));
            return returnValue;
        }
        return null;
    }

    public AJSOutput getOrCreateOutputPanel(String name) {
        final INCExtendedPrintout tmp = JEBatchHostFrame.This().createOutput(name);
        return new AJSOutput(){

            public void printLine(String line) {
                tmp.printLine(line);
            }

            public void printErrorLine(String line) {
                tmp.printLine(NCApplication.GetImage("/de/netcomputing/anyj/stop.gif"), line);
            }

            public void clear() {
                tmp.clear();
            }
        };
    }

    public boolean invokeService(String service, Object argument0) {
        INCService serv = ((ServiceRegistry)EditApp.App.getServReg()).getServiceNamed(service);
        if (serv == null) {
            throw new RuntimeException("No such service:" + service);
        }
        Object argument = this.unConvertSelection(argument0);
        if (serv.canProcess(argument, this)) {
            serv.doProcess(argument, this);
            ServiceRegistry.AddServiceCall(serv);
            return true;
        }
        if (argument0 instanceof AJSTextDocument && ((AJSTextDocument)argument0).getFile() != null) {
            EditFrame ef = EditApp.App.findOpenFrameNamed(((AJSTextDocument)argument0).getFile().getAbsolutePath());
            if (ef != null) {
                if (serv.canProcess(ef, this)) {
                    serv.doProcess(ef, this);
                    ServiceRegistry.AddServiceCall(serv);
                    return true;
                }
                if (serv.canProcess(ef.editPanel, this)) {
                    serv.doProcess(ef, this);
                    ServiceRegistry.AddServiceCall(serv);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void runScript(String fileName) {
        VFile f = new VFile("#userdata/scripts/" + fileName);
        JEBatchHostFrame.This().createOutput("Interpret").printLine("Running script:" + f.getAbsolutePath());
        InterpreterPlugin.This.interpret(new TextDocument(f).toString());
    }

    public Frame getMainWindow() {
        return EditApp.App.getMainWindow();
    }

    public String ressolveSymbolicVariables(String s) {
        return this.ressolveSymbolicVariables(s, this.getEnvironment());
    }

    public String ressolveSymbolicVariables(String s, Hashtable environment) {
        return EditApp.App.insertEnvVars(s, this.getEnvironment());
    }

    public Hashtable getEnvironment() {
        ISelectedContext cnt = new ISelectedContext(){

            public int size() {
                return 0;
            }

            public Object at(int n) {
                return null;
            }
        };
        if (EditApp.GetLastSelectionProvider() != null) {
            Object[] sel = EditApp.GetLastSelectionProvider().getDataSelection();
            if (sel == null) {
                sel = new Object[]{};
            }
            final Object[] sel0 = sel;
            cnt = new ISelectedContext(){

                public int size() {
                    return sel0.length;
                }

                public Object at(int n) {
                    return sel0[n];
                }
            };
        }
        return EditApp.App.buildEnvironment(cnt);
    }

    Object unConvertSelection(Object selection) {
        if (selection instanceof AJSTextDocument) {
            selection = ((AJSTextDocument)selection).doc;
        }
        return selection;
    }

    Object convertSelection(Object selection) {
        if (selection instanceof TextDocument) {
            selection = new AJSTextDocument((TextDocument)selection);
        } else if (!(selection instanceof File) && !(selection instanceof String)) {
            selection = selection instanceof IndexEntry ? new File(((IndexEntry)selection).fileString()) : null;
        }
        return selection;
    }

    public void registerMenuHandler(final AJExternalService serv) {
        EditApp.App.addService(new ScriptService(serv.getCategory(), serv.getMenuName(), 1){

            public boolean canProcess(Object selection, Object selector) {
                if ((selection = AnyJAPI.this.convertSelection(selection)) == null) {
                    return false;
                }
                try {
                    return serv.canProcessSelection(selection);
                }
                catch (CatchedExceptionError ex) {
                    ex.getException().printStackTrace(InterpreterPlugin.This.getInterpreterOutput());
                }
                catch (Throwable e) {
                    e.printStackTrace(InterpreterPlugin.This.getInterpreterOutput());
                }
                return false;
            }

            public void doProcess(Object selection, Object selector) {
                PrintStream p = InterpreterPlugin.This.getInterpreterOutput();
                selection = AnyJAPI.this.convertSelection(selection);
                try {
                    serv.doProcess(selection);
                    ServiceRegistry.AddServiceCall(this);
                }
                catch (CatchedExceptionError ex) {
                    ex.getException().printStackTrace(InterpreterPlugin.This.getInterpreterOutput());
                }
                catch (Throwable e) {
                    e.printStackTrace(p);
                }
            }
        });
    }

    public AJSTextDocument getDocumentIfOpen(String absPath) {
        TextDocument doc = EditApp.App.findOpenFileNamed(absPath);
        if (doc != null) {
            return new AJSTextDocument(doc);
        }
        return null;
    }

    public int executeExternalProcess(String outputLabel, String workingDirectory, String commandline) {
        Process p = Executor.Exec(commandline, workingDirectory, JEBatchHostFrame.This().createOutput(outputLabel), false);
        try {
            p.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return p.exitValue();
    }

    public void waitForLongRunningJobEnd() {
        try {
            do {
                Thread.sleep(500L);
            } while (!JWidgetsUtil.IsLongTermQueueEmpty());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getInterpreterClasspath() {
        return InterpreterPlugin.This.getInterpreterClasspath();
    }

    public Vector dirContent(File dir, String ending, boolean recursive) {
        return DirIterator.DirContent(dir, ending, recursive);
    }

    public void openEditor(String path) {
        EditApp.App.openEditorOrShow(path);
    }

    public void openFileDiff(String title, String leftTitle, String rightTitle, File pathA, File pathB) {
        EditApp.App.openSimpleFileDiff(title, leftTitle, rightTitle, new TextDocument(pathA), new TextDocument(pathB));
    }

    public void openDirDiff(File pathA, File pathB) {
        EditApp.App.openNewDirDiff(pathA.getAbsolutePath(), pathB.getAbsolutePath());
    }

    public void closeEditor(String path, boolean askIfModified) {
        EditFrame f = EditApp.App.getEditFrameIfPresent(new File(path));
        if (f != null) {
            f.close(askIfModified);
        }
    }

    public Vector getOpenedFiles() {
        return EditApp.App.getOpenedFiles();
    }

    public void updateFileTree() {
        EditApp.App.updateDirTree();
    }

    public void setMenuStructure(String[] newMenu) {
        EditApp.App.jol.setMainMenuStructure(newMenu);
    }

    public void addMenuStructure(String[] newMenu) {
        EditApp.App.jol.addMainMenuStructure(newMenu);
    }

    public void setPopupMenuStructure(String[] newMenu) {
        ServiceRegistry.popMenu = newMenu;
    }

    public List splitSeparatedString(String stringToSplit, String separator) {
        return NCStringUtilities.SplitSeparatedString(separator, stringToSplit);
    }

    public List chooseFromList(String dlgTitle, String title, List items, List initialSel, int width, int height) {
        return AJChooseMulti.ChooseFromList(EditApp.App.getMainWindow(), dlgTitle, title, items, initialSel, width, height);
    }

    public void updateMenus() {
        EditApp.App.binderApplication().notifyTargets("servicesChanged");
    }
}

