/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.services;

import JCollections.DirIterator;
import JWVFile.VFile;
import Jxe.DocumentStream;
import Jxe.TextDocument;
import de.netcomputing.anyj.AJCompileAndBuild;
import de.netcomputing.anyj.AJDeploymentMultiplexer;
import de.netcomputing.anyj.AJDeploymentPanel;
import de.netcomputing.anyj.application.AJUserMsgException;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.templates.ejb.EJBContext;
import de.netcomputing.templates.engine.TemplateExecutor;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jxeplugins.JEBasicService;
import jxeplugins.JEBatchHostFrame;
import netcomputing.tools.Executor;
import netcomputing.tools.INCExtendedPrintout;

public class AJEJBServices {
    static AJEJBServices This = new AJEJBServices();

    public static void RegisterServices() {
        JEBasicService ser = new JEBasicService("EJB", "Generate EJB interfaces", 1){

            public boolean canProcess(Object selection, Object selector) {
                if (!(selection instanceof File)) {
                    return false;
                }
                File f = (File)selection;
                if (!f.getName().endsWith(".java")) {
                    return false;
                }
                IndexEntry ie = SourceBase.This().getPossibleClassDefinitionOf(VFile.NameWithoutExtension(f.getName()), f);
                if (ie == null || !ie.isClass() || ie.isInterface()) {
                    return false;
                }
                String[] ifs = ie.getInterfaces();
                HashSet<String> set = new HashSet<String>(Arrays.asList(ifs));
                return set.contains("SessionBean") || set.contains("EntityBean");
            }

            public void doProcess(Object selection, Object selector) {
                File f = (File)selection;
                IndexEntry ie = SourceBase.This().getPossibleClassDefinitionOf(VFile.NameWithoutExtension(f.getName()), f);
                String[] ifs = ie.getInterfaces();
                HashSet<String> set = new HashSet<String>(Arrays.asList(ifs));
                if (set.contains("SessionBean")) {
                    This.generateSessionEJB(ie, set);
                } else if (set.contains("EntityBean")) {
                    This.generateEntityEJB(ie, set);
                }
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("EJB", "Deploy EJB Module", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof File && ((File)selection).isDirectory() && This.findEJBModulePrps((File)selection) != null;
            }

            public void doProcess(Object selection, Object selector) {
                try {
                    This.deployEJBModule((File)selection, true);
                }
                catch (Exception ex) {
                    Confirm.MsgException(ex);
                    ex.printStackTrace(Tracer.This);
                }
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("EJB", "Deploy Web Module", 1){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof File && ((File)selection).isDirectory() && This.findWebModulePrps((File)selection) != null;
            }

            public void doProcess(Object selection, Object selector) {
                try {
                    This.deployWebModule((File)selection, true);
                }
                catch (Exception ex) {
                    Confirm.MsgException(ex);
                    ex.printStackTrace(Tracer.This);
                }
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("EJB", "Deploy All Modules", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                try {
                    This.deployAllModules();
                }
                catch (Exception ex) {
                    Confirm.MsgException(ex);
                    ex.printStackTrace(Tracer.This);
                }
            }
        };
        EditApp.ServReg.addService(ser);
    }

    public void deployAllModules() {
        String sp = AJCompileAndBuild.This.getSourcePathAndCompute();
        Vector v = NCFileUtilities.GetPathAsVector(sp);
        HashSet<File> dirs = new HashSet<File>();
        int i = 0;
        while (i < v.size()) {
            File f = this.findEJBModulePrps(new File((String)v.get(i)));
            if (f != null) {
                dirs.add(f);
            } else {
                f = this.findWebModulePrps(new File((String)v.get(i)));
                if (f != null) {
                    dirs.add(f);
                }
            }
            ++i;
        }
        if (dirs.size() == 0) {
            Confirm.ModalMsg("No Modules found !", "There are no modules in your project");
        }
        Iterator it = dirs.iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            if ("ejb_module.prp".equals(f.getName())) {
                this.deployEJBModule(f.getParentFile(), true);
                continue;
            }
            if (!"web_module.prp".equals(f.getName())) continue;
            this.deployWebModule(f.getParentFile(), true);
        }
    }

    public Properties getEJBModulePrps(File dir) {
        return NCFileUtilities.AsProps(this.findEJBModulePrps(dir));
    }

    public Properties getWebModulePrps(File dir) {
        return NCFileUtilities.AsProps(this.findWebModulePrps(dir));
    }

    File findEJBModulePrps(File dir) {
        String fiName = "ejb_module.prp";
        return this.findCFGFile(fiName, dir);
    }

    File findWebModulePrps(File dir) {
        String fiName = "web_module.prp";
        return this.findCFGFile(fiName, dir);
    }

    File findCFGFile(String fiName, File dir) {
        return NCFileUtilities.FindCFGFile(fiName, dir);
    }

    public ArrayList findEJBSources(File dir) {
        Vector v = DirIterator.DirContent(dir, ".java");
        ArrayList<TextDocument> res = new ArrayList<TextDocument>();
        int i = 0;
        while (i < v.size()) {
            File jf = (File)v.get(i);
            TextDocument doc = new TextDocument(jf);
            doc.findAndSelectForward("//@EJB", 0, 0);
            if (doc.hasSelection()) {
                res.add(doc);
            }
            ++i;
        }
        return res;
    }

    public ArrayList findAnySources(File dir) {
        Vector v = DirIterator.DirContent(dir, ".java");
        ArrayList<File> res = new ArrayList<File>();
        HashSet<String> added = new HashSet<String>(10);
        int i = 0;
        while (i < v.size()) {
            File f = (File)v.get(i);
            String tmpFi = (f = f.getParentFile()).getAbsolutePath();
            if (!added.contains(tmpFi)) {
                res.add(f);
                added.add(tmpFi);
            }
            ++i;
        }
        return res;
    }

    public String getBeaDeployDir(String target, Properties props) {
        if (target.equals("jboss3.0")) {
            return "($jbosshome)" + File.separator + "server" + File.separator + props.getProperty("deploy", "default") + File.separator + "deploy";
        }
        if (target.endsWith("6.1")) {
            return "($beahome)" + File.separator + "config" + File.separator + "($beadomain)" + File.separator + "applications";
        }
        if (target.endsWith("7.0")) {
            return "($beahome)" + File.separator + ".." + File.separator + "user_projects" + File.separator + "($beadomain)" + File.separator + "applications";
        }
        return "";
    }

    protected String getWLEJBCString(String target, File deploy) {
        if (target.endsWith("6.1")) {
            return "($jdkhome)\\bin\\java -cp ($beahome)" + File.separator + "lib" + File.separator + "weblogic_sp.jar" + File.pathSeparator + "($beahome)" + File.separator + "lib" + File.separator + "weblogic.jar weblogic.ejbc -d " + deploy.getAbsolutePath() + " -g -classpath ($classpath) -keepgenerated ";
        }
        if (target.endsWith("7.0")) {
            return "($jdkhome)\\bin\\java -cp ($beahome)" + File.separator + "server" + File.separator + "lib" + File.separator + "weblogic_sp.jar" + File.pathSeparator + "($beahome)" + File.separator + "server" + File.separator + "lib" + File.separator + "weblogic.jar weblogic.ejbc -d " + deploy.getAbsolutePath() + " -g -classpath ($classpath) ";
        }
        return "";
    }

    public void deployWebModule(File dir, boolean clean) {
        final Properties props = this.getWebModulePrps(dir);
        if (props == null) {
            throw new AJUserMsgException("Deploy", "Directory not an AnyJ-Web module");
        }
        final File deploy = new File(this.findWebModulePrps(dir).getParent(), "deploy");
        dir = this.findWebModulePrps(dir).getParentFile();
        String out = EditApp.App.insertEnvVars(AJCompileAndBuild.This.getOutputDir(), null);
        final String target = props.getProperty("target");
        final String moduleName = props.getProperty("name");
        if (clean) {
            this.cleanDir(moduleName, deploy);
        }
        try {
            AJDeploymentPanel deployPanel = AJDeploymentMultiplexer.This.getDeploymentPanel(moduleName);
            if (deployPanel == null) {
                AJDeploymentMultiplexer.This.addNewConfig(moduleName);
                Vector v = AJDeploymentMultiplexer.This.getDeploymentConfigs();
                deployPanel = (AJDeploymentPanel)v.elementAt(v.size() - 1);
                deployPanel.setOptions(dir.getAbsolutePath(), moduleName + ".war", dir.getAbsolutePath() + File.separator + "deploy" + File.separator + "WEB-INF" + File.separator + "classes", "", false, false);
                File srcBase = new File(dir, "source");
                ArrayList javaSrc = this.findAnySources(srcBase);
                int i = 0;
                while (i < javaSrc.size()) {
                    File doc = (File)javaSrc.get(i);
                    String pack = doc.getAbsolutePath().substring(srcBase.getAbsolutePath().length());
                    while (pack.startsWith(File.separator) && pack.length() > 0) {
                        pack = pack.substring(1);
                    }
                    File clzFile = new File(out, pack);
                    deployPanel.addDeploymentEntry(clzFile, ".class", "", false, true);
                    ++i;
                }
                EditApp.App.openOptions("Workspace.Deployment Helper");
            }
            final AJDeploymentPanel fideployPanel = deployPanel;
            JWidgetsUtil.AddLongRunningJob(new Runnable(){

                public void run() {
                    try {
                        String res = fideployPanel.runDeployment();
                        INCExtendedPrintout ncout = JEBatchHostFrame.This().createOutput("Deploying " + moduleName);
                        File ejbjar = new File(deploy.getParentFile(), moduleName + ".war");
                        String jar = "($jdkhome)" + File.separator + "bin" + File.separator + "jar -cf .." + File.separator + moduleName + ".war *";
                        jar = EditApp.App.insertEnvVars(jar, null);
                        ncout.printLine("running jar ...");
                        ncout.printLine(jar);
                        Process p = Executor.Exec(jar, deploy.getAbsolutePath(), ncout);
                        p.waitFor();
                        if (p.exitValue() != 0) {
                            ncout.printLine(NCApplication.GetImage("/de/netcomputing/anyj/stop.gif"), "jar.exe returned" + p.exitValue());
                            ncout.printLine(NCApplication.GetImage("/de/netcomputing/anyj/stop.gif"), "Canceled deployment");
                        } else if ("weblogic6.1".equals(target) || "weblogic7.0".equals(target) || "jboss3.0".equals(target)) {
                            String beadeploy = AJEJBServices.this.getBeaDeployDir(target, props);
                            File beaTarget = new File(beadeploy = EditApp.App.insertEnvVars(beadeploy, null), moduleName + ".war");
                            if (!beaTarget.getParentFile().exists()) {
                                Confirm.ModalConfirm("Setup Error", new String[]{"The directory " + beaTarget.getParent() + " does", "not exist.", "Please verify your setup in Preferences|User Environment"});
                            } else {
                                ncout.printLine("copying " + ejbjar.getAbsolutePath() + " to " + beaTarget.getAbsolutePath());
                                VFile.Copy(ejbjar, beaTarget);
                            }
                            ncout.printLine("- DONE -");
                            EditApp.App.updateDirTree();
                        }
                    }
                    catch (Exception ex) {
                        INCExtendedPrintout ncout = JEBatchHostFrame.This().createOutput("Deploying " + moduleName);
                        ncout.printLine("Fatal: failed to start process " + ex.getMessage());
                        ex.printStackTrace();
                    }
                }
            });
        }
        catch (Exception ex) {
            Confirm.MsgException(ex);
            ex.printStackTrace();
        }
    }

    public void deployEJBModule(File dir, boolean clean) {
        String target;
        final Properties props = this.getEJBModulePrps(dir);
        if (props == null) {
            throw new AJUserMsgException("Deploy", "Directory not an AnyJ-EJB module");
        }
        final File deploy = new File(this.findEJBModulePrps(dir).getParent(), "deploy");
        dir = this.findEJBModulePrps(dir).getParentFile();
        String out = EditApp.App.insertEnvVars(AJCompileAndBuild.This.getOutputDir(), null);
        final String finalTarget = target = props.getProperty("target");
        final String moduleName = props.getProperty("name");
        if (clean) {
            this.cleanDir(moduleName, deploy);
        }
        if (target.equals("weblogic6.1") || target.equals("weblogic7.0") || target.equals("jboss3.0")) {
            try {
                AJDeploymentPanel deployPanel = AJDeploymentMultiplexer.This.getDeploymentPanel(moduleName);
                if (deployPanel == null) {
                    AJDeploymentMultiplexer.This.addNewConfig(moduleName);
                    Vector v = AJDeploymentMultiplexer.This.getDeploymentConfigs();
                    deployPanel = (AJDeploymentPanel)v.elementAt(v.size() - 1);
                    deployPanel.setOptions(dir.getAbsolutePath(), moduleName, dir.getAbsolutePath() + File.separator + "deploy", "", true, false);
                    File srcBase = new File(dir, "source");
                    ArrayList javaSrc = this.findEJBSources(srcBase);
                    int i = 0;
                    while (i < javaSrc.size()) {
                        TextDocument doc = (TextDocument)javaSrc.get(i);
                        String pack = DocumentStream.ScanPackage(doc);
                        pack = pack.replace('.', File.separatorChar);
                        File clzFile = new File(out, pack + File.separator + VFile.NameWithoutExtension(doc.getFile().getAbsolutePath()) + ".class");
                        deployPanel.addDeploymentEntry(clzFile, ".class", "", false, true);
                        ++i;
                    }
                    EditApp.App.openOptions("Workspace.Deployment Helper");
                }
                final AJDeploymentPanel fideployPanel = deployPanel;
                JWidgetsUtil.AddLongRunningJob(new Runnable(){

                    public void run() {
                        try {
                            boolean error = false;
                            try {
                                File wlGen;
                                if (finalTarget.equals("weblogic7.0") && (wlGen = new File(deploy, "_WL_GENERATED")).exists() && !wlGen.delete()) {
                                    error = true;
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace(Tracer.This);
                            }
                            String res = fideployPanel.runDeployment();
                            INCExtendedPrintout ncout = JEBatchHostFrame.This().createOutput("Deploying " + moduleName);
                            if (error) {
                                File wlGen = new File(deploy, "_WL_GENERATED");
                                ncout.printLine(NCApplication.GetImage("/de/netcomputing/anyj/stop.gif"), "Unable to delete:" + wlGen + " may lead to errors at runtime");
                            }
                            Process p = null;
                            if (finalTarget.startsWith("weblogic")) {
                                String ejbc = AJEJBServices.this.getWLEJBCString(finalTarget, deploy) + res;
                                ejbc = EditApp.App.insertEnvVars(ejbc, null);
                                ncout.printLine("");
                                ncout.printLine("running ejbc ...");
                                ncout.printLine(ejbc);
                                p = Executor.Exec(ejbc, File.separator, ncout);
                                p.waitFor();
                            }
                            File ejbjar = new File(deploy.getParentFile(), moduleName + ".jar");
                            ejbjar.delete();
                            if ((p == null || p.exitValue() != 0) && finalTarget.startsWith("weblogic")) {
                                ncout.printLine(NCApplication.GetImage("/de/netcomputing/anyj/stop.gif"), "EJBC returned:" + p.exitValue());
                                ncout.printLine(NCApplication.GetImage("/de/netcomputing/anyj/stop.gif"), "Canceled build");
                            } else {
                                String jar = "($jdkhome)" + File.separator + "bin" + File.separator + "jar -cf .." + File.separator + moduleName + ".jar *";
                                jar = EditApp.App.insertEnvVars(jar, null);
                                ncout.printLine("");
                                ncout.printLine("running jar ...");
                                ncout.printLine(jar);
                                p = Executor.Exec(jar, deploy.getAbsolutePath(), ncout);
                                p.waitFor();
                                if (p.exitValue() != 0) {
                                    ncout.printLine(NCApplication.GetImage("/de/netcomputing/anyj/stop.gif"), "jar.exe returned" + p.exitValue());
                                    ncout.printLine(NCApplication.GetImage("/de/netcomputing/anyj/stop.gif"), "Canceled deployment");
                                } else {
                                    String beadeploy = AJEJBServices.this.getBeaDeployDir(finalTarget, props);
                                    File beaTarget = new File(beadeploy = EditApp.App.insertEnvVars(beadeploy, null), moduleName + ".jar");
                                    if (!beaTarget.getParentFile().exists()) {
                                        Confirm.ModalConfirm("Setup Error", new String[]{"The directory " + beaTarget.getParent() + " does", "not exist.", "Please verify your setup in Preferences|User Environment"});
                                    } else {
                                        ncout.printLine("copying " + ejbjar.getAbsolutePath() + " to " + beaTarget.getAbsolutePath());
                                        VFile.Copy(ejbjar, beaTarget);
                                    }
                                }
                            }
                            ncout.printLine("- DONE -");
                            EditApp.App.updateDirTree();
                        }
                        catch (Exception ex) {
                            INCExtendedPrintout ncout = JEBatchHostFrame.This().createOutput("Deploying " + moduleName);
                            ncout.printLine("Fatal: failed to start process " + ex.getMessage());
                            ex.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception ex) {
                Confirm.MsgException(ex);
                ex.printStackTrace();
            }
        } else {
            throw new AJUserMsgException("Deploy", "Unknown Server target");
        }
    }

    void cleanDir(String moduleName, File deploy) {
        Vector v = DirIterator.DirContent(deploy, ".java");
        int i = 0;
        while (i < v.size()) {
            ((File)v.get(i)).delete();
            ++i;
        }
        v = DirIterator.DirContent(deploy, ".class");
        int i2 = 0;
        while (i2 < v.size()) {
            ((File)v.get(i2)).delete();
            ++i2;
        }
        new File(deploy.getParentFile(), moduleName + ".jar").delete();
    }

    public void generateSessionEJB(IndexEntry ie, HashSet ifaces) {
        try {
            TemplateExecutor exec;
            File target;
            EditFrame ef = EditApp.App.findOpenFrameNamed(ie.decl().getFile());
            if (ef != null) {
                ef.save();
            }
            EditApp.App.updateSourceBase(new File(ie.decl().getFile()));
            INCExtendedPrintout out = JEBatchHostFrame.This().createOutput("TExec");
            out.clear();
            out.printLine("Generating EJB interfaces");
            EJBContext ctx = new EJBContext(ie, ifaces);
            ctx.dump();
            File fi = new File(ctx.getClz().fileString());
            String tmp = VFile.ResolveName("#process");
            if (ctx.getIsRemote()) {
                target = new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "Remote.java");
                out.printLine("Generating " + target.getAbsolutePath());
                exec = new TemplateExecutor(tmp);
                exec.setFiles(new VFile("#templates/engine/EjbSessionRemote.jpl"), target, ctx);
                exec.execute();
                target = new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "Home.java");
                out.printLine("Generating " + target.getAbsolutePath());
                exec = new TemplateExecutor(tmp);
                exec.setFiles(new VFile("#templates/engine/EjbSessionHome.jpl"), target, ctx);
                exec.execute();
            } else {
                out.printLine("Deleting remote interfaces");
                new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "Remote.java").delete();
                new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "Home.java").delete();
            }
            if (ctx.getIsLocal()) {
                target = new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "LocalHome.java");
                out.printLine("Generating " + target.getAbsolutePath());
                exec = new TemplateExecutor(tmp);
                exec.setFiles(new VFile("#templates/engine/EjbSessionLocalHome.jpl"), target, ctx);
                exec.execute();
                target = new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "Local.java");
                out.printLine("Generating " + target.getAbsolutePath());
                exec = new TemplateExecutor(tmp);
                exec.setFiles(new VFile("#templates/engine/EjbSessionLocal.jpl"), target, ctx);
                exec.execute();
            } else {
                out.printLine("Deleting local interfaces");
                new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "Local.java").delete();
                new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "LocalHome.java").delete();
            }
            EditApp.App.updateDirTree();
        }
        catch (Exception ex) {
            Confirm.MsgException(ex);
            ex.printStackTrace();
        }
    }

    public void generateEntityEJB(IndexEntry ie, HashSet ifaces) {
        try {
            TemplateExecutor exec;
            File target;
            EditFrame ef = EditApp.App.findOpenFrameNamed(ie.decl().getFile());
            if (ef != null) {
                ef.save();
            }
            EditApp.App.updateSourceBase(new File(ie.decl().getFile()));
            INCExtendedPrintout out = JEBatchHostFrame.This().createOutput("TExec");
            out.clear();
            out.printLine("Generating EJB interfaces");
            EJBContext ctx = new EJBContext(ie, ifaces);
            ctx.dump();
            File fi = new File(ctx.getClz().fileString());
            String tmp = VFile.ResolveName("#process");
            if (ctx.getIsRemote()) {
                target = new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "Remote.java");
                out.printLine("Generating " + target.getAbsolutePath());
                exec = new TemplateExecutor(tmp);
                exec.setFiles(new VFile("#templates/engine/EjbEntityRemote.jpl"), target, ctx);
                exec.execute();
                target = new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "Home.java");
                out.printLine("Generating " + target.getAbsolutePath());
                exec = new TemplateExecutor(tmp);
                exec.setFiles(new VFile("#templates/engine/EjbEntityHome.jpl"), target, ctx);
                exec.execute();
            } else {
                out.printLine("Deleting remote interfaces");
                new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "Remote.java").delete();
                new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "Home.java").delete();
            }
            if (ctx.getIsLocal()) {
                target = new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "LocalHome.java");
                out.printLine("Generating " + target.getAbsolutePath());
                exec = new TemplateExecutor(tmp);
                exec.setFiles(new VFile("#templates/engine/EjbEntityLocalHome.jpl"), target, ctx);
                exec.execute();
                target = new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "Local.java");
                out.printLine("Generating " + target.getAbsolutePath());
                exec = new TemplateExecutor(tmp);
                exec.setFiles(new VFile("#templates/engine/EjbEntityLocal.jpl"), target, ctx);
                exec.execute();
            } else {
                out.printLine("Deleting local interfaces");
                new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "Local.java").delete();
                new File(fi.getParent(), fi.getName().substring(0, fi.getName().length() - "Bean.java".length()) + "LocalHome.java").delete();
            }
            EditApp.App.updateDirTree();
        }
        catch (Exception ex) {
            Confirm.MsgException(ex);
            ex.printStackTrace();
        }
    }
}

