/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.services;

import JWVFile.VFile;
import de.netcomputing.anyj.scripting.AnyJAPI;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.NCStringUtilities;
import editapp.EditApp;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import plugins.JavacPlugin;

public class WorkspaceContext {
    File base;
    Hashtable env;

    public WorkspaceContext(File base) {
        this.base = base;
    }

    public String getWorkspaceName() {
        return VFile.NameWithoutExtension(VFile.ResolveName("#actproject"));
    }

    public String getOutputDir() {
        return this.adjustVariables(JavacPlugin.This().getOutputDir());
    }

    public String getClassPath() {
        return this.adjustVariables(JavacPlugin.This().getClasspath());
    }

    public Hashtable getEnvironment() {
        if (this.env == null) {
            this.env = AnyJAPI.This().getEnvironment();
        }
        return this.env;
    }

    public String getEnvEntry(String s) {
        String res = (String)this.getEnvironment().get(s);
        if (res == null) {
            return null;
        }
        res = NCStringUtilities.Replace(res, "$(", "${");
        res = NCStringUtilities.Replace(res, ")", "}");
        res = NCStringUtilities.Replace(res, File.pathSeparator, ":");
        return res;
    }

    public String adjustVariables(String in) {
        in = EditApp.App.insertEnvVars(in, null);
        String res = in = NCFileUtilities.RelativePath(null, this.base.getAbsolutePath(), in);
        res = NCStringUtilities.Replace(res, "($", "${");
        res = NCStringUtilities.Replace(res, ")", "}");
        res = NCStringUtilities.Replace(res, File.pathSeparator, ":");
        res = NCStringUtilities.Replace(res, File.separator, "/");
        return res;
    }

    public String getCompilerArgs() {
        Vector vopt = JavacPlugin.getOptions(0);
        String compiler = JavacPlugin.options.getCompilerString(0).trim();
        int i = 0;
        while (i < vopt.size()) {
            compiler = compiler + " " + vopt.get(i);
            ++i;
        }
        int i2 = compiler.indexOf(" ");
        if ((i2 = (compiler = compiler.substring(i2)).indexOf(" -d ")) >= 0) {
            compiler = compiler.substring(0, i2);
        }
        compiler = NCStringUtilities.Replace(compiler, " -verbose ", " ");
        return compiler;
    }

    public String getSourcePath() {
        String res = "";
        Vector v = EditApp.App.getDirsToCompile();
        int i = 0;
        while (i < v.size()) {
            res = res + this.adjustVariables((String)v.get(i)) + ":";
            ++i;
        }
        return res;
    }

    public Iterator getSourcePathIterator() {
        Vector v = EditApp.App.getDirsToCompile();
        int i = 0;
        while (i < v.size()) {
            v.set(i, this.adjustVariables((String)v.get(i)));
            ++i;
        }
        return v.iterator();
    }

    public Iterator getClassPathIterator() {
        Vector v = NCFileUtilities.GetPathAsVector(JavacPlugin.This().getClasspath());
        int i = 0;
        while (i < v.size()) {
            v.set(i, this.adjustVariables((String)v.get(i)));
            ++i;
        }
        return v.iterator();
    }

    public String getSourceDirs() {
        String res = "";
        Vector v = EditApp.App.getDirsToCompile();
        int i = 0;
        while (i < v.size()) {
            res = res + this.adjustVariables((String)v.get(i)) + ":";
            ++i;
        }
        return res;
    }
}

