/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.beans.numberpanel;

import de.netcomputing.beans.numberpanel.NumberPanelGUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public class NumberPanel
extends JPanel {
    public JTextField textField;
    public JScrollBar scrollBar;
    int step;
    boolean eventFiringEnabled = true;
    Vector listeners;

    public NumberPanel() {
        this.initGui();
    }

    public void initGui() {
        new NumberPanelGUI().createGui(this);
        this.textField.setText("" + this.scrollBar.getValue());
    }

    Vector getListeners() {
        if (this.listeners == null) {
            this.listeners = new Vector(5);
        }
        return this.listeners;
    }

    public void setEventFiringEnabled(boolean eventFiringEnabled) {
        this.eventFiringEnabled = eventFiringEnabled;
    }

    public boolean getEventFiringEnabled() {
        return this.eventFiringEnabled;
    }

    public void addActionListener(ActionListener a) {
        this.getListeners().addElement(a);
    }

    public void removeActionListener(ActionListener a) {
        this.getListeners().removeElement(a);
    }

    public void fireActionEvent() {
        if (this.getEventFiringEnabled()) {
            int n = 0;
            while (n < this.getListeners().size()) {
                ((ActionListener)this.listeners.elementAt(n)).actionPerformed(new ActionEvent(this, 0, "valueChanged"));
                ++n;
            }
        }
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getStep() {
        return this.step;
    }

    public void setRange(int min, int max, int step) {
        this.setMinValue(min);
        this.setMaxValue(max);
        this.setStep(step);
    }

    public void setValue(int value) {
        value = Math.max(this.getMinValue(), value);
        value = Math.min(this.getMaxValue(), value);
        this.scrollBar.setValue(this.getMaxValue() - value);
        this.fireActionEvent();
    }

    public int getMinValue() {
        return this.scrollBar.getMinimum();
    }

    public int getMaxValue() {
        return this.scrollBar.getMaximum();
    }

    public void setMinValue(int min) {
        this.scrollBar.setMinimum(min - 1);
        this.getValueFromSB();
    }

    public void setEnabled(boolean b) {
        this.textField.setEnabled(b);
        this.scrollBar.setEnabled(b);
        super.setEnabled(b);
    }

    public void setMaxValue(int max) {
        this.scrollBar.setMaximum(max);
        this.getValueFromSB();
    }

    public int getValue() {
        try {
            int i = Integer.parseInt(this.textField.getText());
            return i;
        }
        catch (Exception ex) {
            return this.getMinValue();
        }
    }

    void getValueFromSB() {
        this.textField.setText("" + (this.getMaxValue() - this.scrollBar.getValue()));
    }

    public void textField_keyPressed(KeyEvent var0) {
        this.fireActionEvent();
        try {
            int i = Integer.parseInt(this.textField.getText());
            this.scrollBar.setValue(this.getMaxValue() - this.scrollBar.getValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void scrollBar_adjustmentValueChanged(AdjustmentEvent var0) {
        if (this.textField != null) {
            this.getValueFromSB();
            this.fireActionEvent();
        }
    }
}

