/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.commands;

import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import jxeplugins.JEBatchHostFrame;
import netcomputing.tools.Executor;
import netcomputing.tools.INCPrintOut;

public class CVSCommand
implements INCPrintOut {
    public static String CVS = "cvs ";
    public static String ADD = "add ";
    public static String UPDATE = "update ";
    public static String REMOVE = "remove ";
    public static String COMMIT = "commit ";
    public static String CHECKOUT = "checkout ";
    public static String HISTORY = "history ";
    public static String IMPORT = "import ";
    public static String DIFF = "diff ";
    public static String STATUS = "status ";
    public static String LOG = "log ";
    public static String TAG = "rtag ";
    String repositoryDir;
    Vector output = null;
    String tmpFile;
    boolean term = false;
    int lastExitValue = 0;
    static INCPrintOut log;

    public CVSCommand(String repository) {
        this.repositoryDir = repository;
    }

    public static File getTmpFile() {
        return NCFileUtilities.GetTmpFile();
    }

    public void processTerminated(int exitValue) {
        this.term = true;
    }

    void cvsLog(String line) {
        if (log == null && EditApp.App != null) {
            log = JEBatchHostFrame.This().createOutput("CVS-Log");
        }
        if (log != null) {
            log.printLine(line);
        }
    }

    public void printLine(String s) {
        this.cvsLog(s);
        this.output.addElement(s);
    }

    public int execute(String wdir, String command, String tmpFile) {
        try {
            this.tmpFile = tmpFile;
            this.output = new Vector(500);
            this.term = false;
            Process p = Executor.Exec(command, wdir, this);
            this.cvsLog("==================================================");
            this.cvsLog("working dir:" + wdir);
            this.cvsLog(command);
            this.cvsLog("==================================================");
            if (p != null) {
                p.waitFor();
                Tracer.This.println("proc ended ");
                if (!this.term || this.output.size() == 0) {
                    Thread.sleep(100L);
                }
                if (!this.term || this.output.size() == 0) {
                    Thread.sleep(200L);
                }
                int count = 0;
                while (!this.term || this.output.size() == 0 && count < 5) {
                    Tracer.This.println("wait cvs proc");
                    Thread.sleep(500L);
                    ++count;
                }
                Thread.sleep(500L);
                Tracer.This.println("WRITE " + tmpFile + " " + this.output.size());
                PrintStream out = new PrintStream(new FileOutputStream(tmpFile));
                int n = 0;
                while (n < this.output.size()) {
                    out.println(this.output.elementAt(n));
                    ++n;
                }
                out.close();
                this.lastExitValue = p.exitValue();
                return this.lastExitValue;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.lastExitValue = 99;
        return 99;
    }

    public void setRepositoryDir(String repositoryDir) {
        this.repositoryDir = repositoryDir;
    }

    public String getRepositoryDir() {
        return this.repositoryDir;
    }

    public void setOutput(Vector output) {
        this.output = output;
    }

    public Vector getOutput() {
        return this.output;
    }
}

