/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.gui;

import JWVFile.VFile;
import de.netcomputing.anyj.application.ICloseable;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.IPopupGetter;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.cvswrap.commands.AddWrapper;
import de.netcomputing.cvswrap.commands.CommitWrapper;
import de.netcomputing.cvswrap.commands.UpdateWrapper;
import de.netcomputing.cvswrap.gui.CVSCommentDiag;
import de.netcomputing.cvswrap.gui.CVSCommitGUI;
import de.netcomputing.cvswrap.gui.CVSNode;
import de.netcomputing.propertystore.beans.PropertyFileSel;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.Date;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import netcomputing.tools.PropWriter;
import plugins.CVSPlugin;

public class CVSCommit
extends NCPanel
implements ICloseable {
    PropertyFileSel pathTxt;
    JTabbedPane tabbedPane;
    NCTreeBean tree;
    JList updateLogList;
    JLabel statusLabel;
    JButton syncBtn;
    JButton addBtn;
    JButton commitBtn;
    JButton updateBtn;
    String baseDir;
    JPopupMenu pop;
    JMenuItem commitItem;
    JMenuItem updateItem;
    JMenuItem overWriteItem;
    JMenuItem addItem;
    JMenuItem diffItem;
    JMenuItem checkItem;

    public CVSCommit() {
        this.initGui();
        this.tree.binder().addTarget(this, "actionTreeSel");
        this.tree.binderDoubleClick().addTarget(this, "actionDTreeSel");
        this.tree.binderIconClick().addTarget(this, "actionIconTreeSel");
        this.pop = new JPopupMenu();
        this.commitItem = new JMenuItem("Commit");
        this.updateItem = new JMenuItem("Update");
        this.addItem = new JMenuItem("Add");
        this.diffItem = new JMenuItem("Diff");
        this.overWriteItem = new JMenuItem("Overwrite with Repository Version");
        this.overWriteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CVSCommit.this.overWrite();
            }
        });
        this.commitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CVSCommit.this.commitBtn_actionPerformed(e);
            }
        });
        this.updateItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CVSCommit.this.updateBtn_actionPerformed(e);
            }
        });
        this.addItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CVSCommit.this.addBtn_actionPerformed(e);
            }
        });
        this.diffItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CVSNode n = (CVSNode)CVSCommit.this.tree.getSelectedItem();
                if (n != null && !n.isDir()) {
                    CVSPlugin.This.getDiffGUI().show();
                    JWidgetsUtil.AddJob(new Runnable(this, n){
                        private final /* synthetic */ CVSNode val$n;
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$n = val$n;
                        }

                        public void run() {
                            CVSPlugin.This.getCvsDiff().setFile(new File(this.val$n.getUpdateEntry()));
                        }
                    });
                }
            }
        });
        this.pop.add(this.addItem);
        this.pop.add(this.commitItem);
        this.pop.add(this.updateItem);
        this.pop.add(this.overWriteItem);
        this.pop.add(this.diffItem);
        this.tree.setPopUpGetter(new IPopupGetter(){

            public JPopupMenu getMenu(Object requestor, Object selection) {
                if (CVSPlugin.CVSLocked) {
                    return null;
                }
                return CVSCommit.this.pop;
            }

            public JPopupMenu getMenu(Object requestor, Object something, String[] menuCat) {
                return null;
            }
        });
    }

    public void overWrite() {
        CVSNode node = (CVSNode)this.tree.getSelectedItem();
        if (node != null) {
            String selstring = node.getUpdateEntry();
            File f = NCFileUtilities.GetRenamedFile(new File(selstring));
            if (new File(selstring).exists() && !new File(selstring).renameTo(f)) {
                Confirm.ModalMsg("Failed to rename", new String[]{"Can't rename ", selstring, "to", f.getAbsolutePath()});
                return;
            }
            this.updateBtn_actionPerformed(null);
        }
    }

    public Object actionTreeSel(Object arg, Object sen) {
        this.validateBtnState();
        return null;
    }

    public Object actionDTreeSel(Object arg, Object sen) {
        CVSNode sel = (CVSNode)this.tree.getSelectedItem();
        if (sel == null) {
            return null;
        }
        String selstring = sel.getUpdateEntry();
        File f = new File(selstring);
        if (!f.isDirectory()) {
            EditApp.App.openEditorOrShow(selstring);
        }
        return null;
    }

    public Object actionIconTreeSel(Object arg, Object sen) {
        CVSNode sel = (CVSNode)this.tree.getSelectedItem();
        if (sel == null) {
            return null;
        }
        String selstring = sel.getUpdateEntry();
        File f = new File(selstring);
        if (!f.isDirectory()) {
            EditApp.App.browse(f);
        }
        return null;
    }

    public void initGui() {
        new CVSCommitGUI().createGui(this);
        this.updateLogList.setModel(new DefaultListModel());
    }

    public void addLogEntry(String s) {
        ((DefaultListModel)this.updateLogList.getModel()).addElement(s);
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
        this.normalizeBaseDir();
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    private String runUpdate(UpdateWrapper upw, boolean noOp) {
        String err = upw.runUpdate(this.baseDir, noOp, null);
        this.statusLabel.setText("Synchronizing " + this.baseDir);
        this.setEnabled(true);
        this.addBtn.setEnabled(false);
        this.commitBtn.setEnabled(false);
        if (err == null) {
            this.initializeTree(upw);
        } else {
            Confirm.ModalMsg("Unexpected Error:", err);
        }
        this.validateBtnState();
        return err;
    }

    void initializeTree(UpdateWrapper upw) {
        CVSNode root = new CVSNode(0, this.getBaseDir());
        root.displayString = this.getBaseDir();
        Vector modif = upw.getModified();
        Vector conflict = upw.getConflicts();
        Vector unknown = upw.getUnknown();
        Vector update = upw.getUpdated();
        int n = 0;
        while (n < modif.size()) {
            this.addToRoot(root, (String)modif.get(n), 2);
            ++n;
        }
        int n2 = 0;
        while (n2 < conflict.size()) {
            this.addToRoot(root, (String)conflict.get(n2), 6);
            ++n2;
        }
        int n3 = 0;
        while (n3 < update.size()) {
            this.addToRoot(root, (String)update.get(n3), 1);
            ++n3;
        }
        int n4 = 0;
        while (n4 < unknown.size()) {
            this.addToRoot(root, (String)unknown.get(n4), 3);
            ++n4;
        }
        this.tree.clear();
        this.tree.addItem(root);
        this.tree.expandAll();
        this.tree.repaint();
    }

    public void storeProperty(PropWriter pw) throws Exception {
        try {
            DataOutputStream dout = pw.createStream("CVSCommitGUI");
            dout.writeUTF(this.pathTxt.getText());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadProperty(PropWriter pw) throws Exception {
        try {
            DataInputStream din = pw.getStream("CVSCommitGUI");
            this.pathTxt.setText(din.readUTF());
            this.baseDir = this.pathTxt.getText();
            this.normalizeBaseDir();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    void addToRoot(CVSNode root, String path, int type) {
        if (path.startsWith("(scheduled for add) ")) {
            type = 7;
            path = path.substring("(scheduled for add) ".length());
        }
        if (path.startsWith("(scheduled for rem) ")) {
            type = 8;
            path = path.substring("(scheduled for rem) ".length());
        }
        if (path.startsWith("[new folder in repository] ")) {
            type = 4;
            path = path.substring("[new folder in repository] ".length());
        }
        if (path.startsWith("[removed in repository] ")) {
            type = 5;
            path = path.substring("[removed in repository] ".length());
        }
        CVSNode act = root;
        String repPath = path.substring(this.getBaseDir().length());
        if (repPath.startsWith("/") || repPath.startsWith("\\")) {
            repPath = repPath.substring(1);
        }
        repPath = repPath.replace(File.separatorChar, '/');
        Vector v = NCStringUtilities.SplitSeparatedString("/", repPath);
        String growPath = this.getBaseDir();
        int i = 0;
        while (i < v.size()) {
            String s = (String)v.get(i);
            growPath = growPath + File.separator + s;
            CVSNode node = (CVSNode)act.findItemNamed(s);
            if (node == null) {
                node = new CVSNode(type, growPath);
                if (i != v.size() - 1) {
                    node.type = 0;
                }
                act.addItem(node);
            }
            act = node;
            ++i;
        }
    }

    void remFromRoot(CVSNode root, String path) {
        CVSNode act = root;
        String repPath = path.substring(this.getBaseDir().length());
        if (repPath.startsWith("/") || repPath.startsWith("\\")) {
            repPath = repPath.substring(1);
        }
        repPath = repPath.replace(File.separatorChar, '/');
        Vector v = NCStringUtilities.SplitSeparatedString("/", repPath);
        String growPath = this.getBaseDir();
        int i = 0;
        while (i < v.size()) {
            String s = (String)v.get(i);
            growPath = growPath + File.separator + s;
            CVSNode node = (CVSNode)act.findItemNamed(s);
            if (node == null) {
                return;
            }
            if (i == v.size() - 1) {
                act.remItem(node);
            }
            act = node;
            ++i;
        }
    }

    void normalizeBaseDir() {
        while (this.baseDir != null && this.baseDir.length() > 0 && this.baseDir.endsWith(File.separator)) {
            this.baseDir = this.baseDir.substring(0, this.baseDir.length() - 1);
        }
    }

    CVSNode[] locateNode(CVSNode root, String path) {
        CVSNode act = root;
        String repPath = path.substring(this.getBaseDir().length());
        if (repPath.startsWith("/") || repPath.startsWith("\\")) {
            repPath = repPath.substring(1);
        }
        repPath = repPath.replace(File.separatorChar, '/');
        Vector v = NCStringUtilities.SplitSeparatedString("/", repPath);
        String growPath = this.getBaseDir();
        int i = 0;
        while (i < v.size()) {
            String s = (String)v.get(i);
            growPath = growPath + File.separator + s;
            CVSNode node = (CVSNode)act.findItemNamed(s);
            if (node == null) {
                return null;
            }
            if (i == v.size() - 1) {
                return new CVSNode[]{act, node};
            }
            act = node;
            ++i;
        }
        return null;
    }

    public void initFromUpdate(final String baseDir) {
        this.baseDir = baseDir;
        this.normalizeBaseDir();
        this.pathTxt.setText(baseDir);
        new Thread("CVS CHECKFORUPDATE"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    CVSPlugin.CVSLocked = true;
                    CVSCommit.this.setEnabled(false);
                    CVSCommit.this.statusLabel.setText("checking status of " + baseDir + " ...");
                    UpdateWrapper upw = new UpdateWrapper(null);
                    String err = CVSCommit.this.runUpdate(upw, true);
                    CVSCommit.this.statusLabel.setText("Commit/Update " + baseDir);
                    Object var4_3 = null;
                    CVSPlugin.CVSLocked = false;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    CVSPlugin.CVSLocked = false;
                    throw throwable;
                }
            }
        }.start();
    }

    public void doUpdate(String baseDir, Object[] files) {
        int type = 1;
        try {
            type = ((CVSNode)this.tree.getSelectedItem()).getType();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        if (!((CVSNode)this.tree.getSelectedItem()).isDir() && type == 2) {
            String res = Confirm.DoModal((Window)this.getTopLevelAncestor(), null, "Overwrite local version ?", new String[]{"The current version is backed up locally."}, new String[]{"Overwrite", "Cancel"});
            if (!"Overwrite".equals(res)) {
                return;
            }
            int n = 0;
            while (n < files.length) {
                File tmp = new File(files[n].toString() + "~");
                while ((tmp = new File(tmp.getParent(), ".#" + tmp.getName() + "~")).exists()) {
                }
                if (!VFile.RenameFile(files[n].toString(), tmp.getAbsolutePath())) {
                    Confirm.ModalMsg((Window)this.getTopLevelAncestor(), "Renaming failed", new String[]{"File " + files[n], "could not be renamed (OS-Lock).", "Please close all programs", "possibly locking this file.", "Action aborted."});
                    return;
                }
                ++n;
            }
        }
        this.doMerge(baseDir, files);
    }

    public void doMerge(final String baseDir, final Object[] files) {
        new Thread("MERGE"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    CVSPlugin.CVSLocked = true;
                    CVSCommit.this.setEnabled(false);
                    CVSCommit.this.normalizeBaseDir();
                    CVSCommit.this.baseDir = baseDir;
                    CVSCommit.this.statusLabel.setText("updating selected files");
                    UpdateWrapper upw = new UpdateWrapper(null);
                    CVSCommit.this.addLogEntry("Update selected files - " + new Date());
                    String err = upw.runUpdate(baseDir, files);
                    CVSCommit.this.setEnabled(true);
                    CVSCommit.this.addBtn.setEnabled(false);
                    CVSCommit.this.commitBtn.setEnabled(false);
                    CVSCommit.this.processUpdateResults(err, upw);
                    CVSCommit.this.validateBtnState();
                    CVSCommit.this.statusLabel.setText("Updated selected files");
                    CVSCommit.this.addLogEntry(" ");
                    Object var4_3 = null;
                    CVSPlugin.CVSLocked = false;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    CVSPlugin.CVSLocked = false;
                    throw throwable;
                }
            }
        }.start();
    }

    public void checkStatus(final String baseDir, final Object[] files) {
        new Thread("CHECK STATUS"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    CVSPlugin.CVSLocked = true;
                    CVSCommit.this.setEnabled(false);
                    CVSCommit.this.normalizeBaseDir();
                    CVSCommit.this.baseDir = baseDir;
                    CVSCommit.this.statusLabel.setText("updating selected files");
                    UpdateWrapper upw = new UpdateWrapper(null);
                    CVSCommit.this.addLogEntry("Update selected files - " + new Date());
                    String err = upw.runUpdate(baseDir, files, true);
                    CVSCommit.this.setEnabled(true);
                    CVSCommit.this.addBtn.setEnabled(false);
                    CVSCommit.this.commitBtn.setEnabled(false);
                    CVSCommit.this.processUpdateResults(err, upw);
                    CVSCommit.this.validateBtnState();
                    CVSCommit.this.statusLabel.setText("Updated selected files");
                    CVSCommit.this.addLogEntry(" ");
                    Object var4_3 = null;
                    CVSPlugin.CVSLocked = false;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    CVSPlugin.CVSLocked = false;
                    throw throwable;
                }
            }
        }.start();
    }

    public CVSNode getTreeRoot() {
        return (CVSNode)this.tree.at(0);
    }

    public void processUpdateResults(String err, UpdateWrapper upw) {
        if (err == null) {
            Vector modif = upw.getModified();
            Vector conflict = upw.getConflicts();
            Vector unknown = upw.getUnknown();
            Vector update = upw.getUpdated();
            int n = 0;
            while (n < modif.size()) {
                this.addLogEntry("(merged)   " + modif.elementAt(n));
                ++n;
            }
            int n2 = 0;
            while (n2 < conflict.size()) {
                this.addLogEntry("(CONFLICT) " + conflict.elementAt(n2));
                ++n2;
            }
            int n3 = 0;
            while (n3 < unknown.size()) {
                this.addLogEntry("(unknown)  " + unknown.elementAt(n3));
                ++n3;
            }
            int n4 = 0;
            while (n4 < update.size()) {
                this.addLogEntry("(updated)  " + update.elementAt(n4));
                this.remFromRoot(this.getTreeRoot(), (String)update.elementAt(n4));
                ++n4;
            }
        } else {
            Confirm.ModalMsg("Unexpected Result:", err);
        }
        this.tree.collapseAndExpandAllByIndentity();
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    void validateBtnState() {
        CVSNode sel = (CVSNode)this.tree.getSelectedItem();
        if (sel == null || CVSPlugin.CVSLocked) {
            this.commitBtn.setEnabled(false);
            this.updateBtn.setEnabled(false);
            this.addBtn.setEnabled(false);
            this.diffItem.setEnabled(false);
        } else if (sel.isDir()) {
            this.commitBtn.setEnabled(sel.getType() != 5 && sel.getType() != 4 && sel.getType() != 3);
            this.updateBtn.setEnabled(sel.getType() == 0);
            this.addBtn.setEnabled(sel.getType() == 3 || sel.getType() == 8);
            this.diffItem.setEnabled(false);
            this.overWriteItem.setEnabled(false);
        } else {
            this.commitBtn.setEnabled(sel.getType() != 5 && sel.getType() != 4 && sel.getType() != 3);
            this.updateBtn.setEnabled(sel.getType() != 5 && sel.getType() != 3);
            this.overWriteItem.setEnabled(sel.getType() == 6 || sel.getType() == 2);
            this.addBtn.setEnabled(sel.getType() == 3 || sel.getType() == 8);
            this.diffItem.setEnabled(this.commitBtn.isEnabled());
        }
        this.commitItem.setEnabled(this.commitBtn.isEnabled());
        this.updateItem.setEnabled(this.updateBtn.isEnabled());
        this.addItem.setEnabled(this.addBtn.isEnabled());
    }

    public void updateLogList_mouseClicked(MouseEvent var0) {
        Object selFile;
        if (var0.getClickCount() == 2 && (selFile = this.updateLogList.getSelectedValue()) != null) {
            String sel = "" + selFile;
            int i = sel.indexOf(") ");
            if (i >= 0) {
                sel = sel.substring(i + 2);
            }
            if (new File(sel).exists() && !new File(sel).isDirectory()) {
                EditApp.App.openEditorOrShow(sel);
            }
        }
    }

    public void updateBtn_actionPerformed(ActionEvent var0) {
        this.doUpdate(this.baseDir, this.getUpdateSelection());
    }

    public Object[] getUpdateSelection() {
        CVSNode sel = (CVSNode)this.tree.getSelectedItem();
        if (sel == null) {
            return null;
        }
        return new Object[]{sel.getUpdateEntry()};
    }

    public Object[] getAddSelection() {
        CVSNode sel = (CVSNode)this.tree.getSelectedItem();
        if (sel == null) {
            return null;
        }
        return new Object[]{sel.getUpdateEntry()};
    }

    public Object[] getCommitSelection() {
        CVSNode sel = (CVSNode)this.tree.getSelectedItem();
        if (sel == null) {
            return null;
        }
        return new Object[]{sel.getUpdateEntry()};
    }

    public String getComment() {
        return CVSCommentDiag.GetComment();
    }

    void processCommitResult(CommitWrapper cw) {
        Vector modif = cw.getCommited();
        Vector update = cw.getUpdated();
        int n = 0;
        while (n < modif.size()) {
            this.remFromRoot(this.getTreeRoot(), (String)modif.elementAt(n));
            this.addLogEntry("(succeed) " + modif.elementAt(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < update.size()) {
            this.addLogEntry("(failed)  " + update.elementAt(n2));
            ++n2;
        }
        this.tree.collapseAndExpandAll();
    }

    void runCommit(final boolean force) {
        new Thread("COMMIT"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block11: {
                    block10: {
                        try {
                            CVSPlugin.CVSLocked = true;
                            String comment = CVSCommit.this.getComment();
                            if (comment == null) {
                                Object var8_2 = null;
                                CVSPlugin.CVSLocked = false;
                                break block10;
                            }
                            CVSCommit.this.statusLabel.setText("Committing selected File(s) ...");
                            CVSCommit.this.setEnabled(false);
                            CommitWrapper cw = new CommitWrapper(null);
                            Object[] o = CVSCommit.this.getCommitSelection();
                            if (o == null || o.length <= 0) break block11;
                            CVSCommit.this.addLogEntry("Commit selected files - " + new Date());
                            String res = cw.runCommit(CVSCommit.this.baseDir, comment, o, force);
                            if (res != null) {
                                Confirm.ModalMsg("Error During Commit", res);
                                CVSCommit.this.statusLabel.setText("Error during Commit, please check cvs output");
                                break block11;
                            } else {
                                if (!cw.getCommitSuccessful()) {
                                    Confirm.ModalMsg("Commit aborted", new String[]{"Commit aborted !", "Please ensure your working copy is ", "up to date [use 'update' to merge], ressolve the conflicts, ", "after that commit again. "});
                                    CVSCommit.this.statusLabel.setText("Commit ABORTED, ressolve conflicts");
                                    CVSCommit.this.addLogEntry("** ABORTED **");
                                } else {
                                    String[] oo = new String[cw.getMsg().size()];
                                    int n = 0;
                                    while (true) {
                                        if (n >= oo.length) {
                                            if (oo.length > 0) {
                                                Confirm.ModalMsg("Commit succesful", oo);
                                            }
                                            CVSCommit.this.statusLabel.setText("Commit successful");
                                            break;
                                        }
                                        oo[n] = cw.getMsg().elementAt(n).toString();
                                        ++n;
                                    }
                                }
                                CVSCommit.this.processCommitResult(cw);
                            }
                            break block11;
                        }
                        catch (Throwable throwable) {
                            Object var8_4 = null;
                            CVSPlugin.CVSLocked = false;
                            CVSCommit.this.setEnabled(true);
                            CVSCommit.this.validateBtnState();
                            CVSCommit.this.addLogEntry(" ");
                            throw throwable;
                        }
                    }
                    CVSCommit.this.setEnabled(true);
                    CVSCommit.this.validateBtnState();
                    CVSCommit.this.addLogEntry(" ");
                    return;
                }
                Object var8_3 = null;
                CVSPlugin.CVSLocked = false;
                CVSCommit.this.setEnabled(true);
                CVSCommit.this.validateBtnState();
                CVSCommit.this.addLogEntry(" ");
            }
        }.start();
    }

    public void commitBtn_actionPerformed(ActionEvent var0) {
        this.runCommit(false);
    }

    public void tabbedPane_stateChanged(ChangeEvent var0) {
        this.validateBtnState();
    }

    public void syncBtn_actionPerformed(ActionEvent var0) {
        this.baseDir = this.pathTxt.getText();
        this.normalizeBaseDir();
        this.initFromUpdate(this.baseDir);
    }

    public void addBtn_actionPerformed(ActionEvent var0) {
        JWidgetsUtil.AddJob(new Runnable(){

            public void run() {
                CVSCommit.this.statusLabel.setText("Adding selected File(s) to repository");
                CVSCommit.this.addLogEntry("Adding selected files - " + new Date());
                Object[] sel = CVSCommit.this.getAddSelection();
                boolean allAreDirs = true;
                boolean runCheckStatus = false;
                Vector toUpdateList = new Vector();
                int n = 0;
                while (n < sel.length) {
                    AddWrapper addw = new AddWrapper(null);
                    String msg = null;
                    msg = addw.runAdd("" + sel[n]);
                    if (msg != null) {
                        Confirm.ModalMsg("Add failed", msg);
                    } else if (new File("" + sel[n]).isDirectory()) {
                        CVSCommit.this.addLogEntry("(added)     " + sel[n]);
                        runCheckStatus = true;
                    } else {
                        allAreDirs = false;
                        CVSCommit.this.addLogEntry("(scheduled for add) " + sel[n] + " - commit to persist operation");
                        CVSNode[] res = CVSCommit.this.locateNode(CVSCommit.this.getTreeRoot(), "" + sel[n]);
                        if (res != null) {
                            res[1].type = 7;
                            CVSCommit.this.tree.collapseNode(res[0]);
                            CVSCommit.this.tree.expandNode(res[0]);
                            CVSCommit.this.tree.repaint();
                        }
                    }
                    ++n;
                }
                CVSCommit.this.addLogEntry(" ");
                CVSCommit.this.statusLabel.setText("Files scheduled for add");
                if (runCheckStatus) {
                    CVSCommit.this.initFromUpdate(CVSCommit.this.baseDir);
                }
            }
        });
    }
}

