/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.gui;

import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTextField;
import de.netcomputing.cvswrap.commands.CreateWrapper;
import de.netcomputing.cvswrap.gui.CVSConfig;
import de.netcomputing.cvswrap.gui.CVSCreateGUI;
import de.netcomputing.propertystore.beans.PropertyFileSel;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.EditApp;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JEditorPane;
import javax.swing.JFrame;

public class CVSCreate
extends NCPanel {
    JEditorPane commentTxt;
    NCButton createBtn;
    NCTextField nameTxt;
    PropertyFileSel baseDir;

    public CVSCreate() {
        this.initGui();
    }

    public void initGui() {
        new CVSCreateGUI().createGui(this);
    }

    public void setBaseDir(String dir) {
        this.baseDir.setText(dir);
    }

    public String getCVSRoot() {
        return CVSConfig.This().getCVSRoot();
    }

    public String getBaseDir() {
        return this.baseDir.getText().trim();
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    boolean validateInput() {
        String name = this.nameTxt.getText().trim();
        this.nameTxt.setText(name);
        if (name.length() == 0) {
            Confirm.ModalMsg("Error", "Invalid Project Name");
            return false;
        }
        int n = 0;
        while (n < name.length()) {
            if (name.charAt(n) <= ' ' || "$,.:;@ ".indexOf(name.charAt(n)) >= 0) {
                Confirm.ModalMsg("Error", "Invalid Project Name");
                return false;
            }
            ++n;
        }
        return true;
    }

    public void createBtn_actionPerformed(ActionEvent var0) {
        JWidgetsUtil.AddLongRunningJob(new Runnable(){

            public void run() {
                CVSCreate.this.setEnabled(false);
                String bdir = CVSCreate.this.baseDir.getText().trim();
                String name = CVSCreate.this.nameTxt.getText().trim();
                try {
                    File f = new File(CVSCreate.this.baseDir.getText().trim());
                    f.mkdirs();
                    if (!f.exists()) {
                        throw new RuntimeException("");
                    }
                }
                catch (Exception ex) {
                    Confirm.ModalMsg("Error", "Could not create/write Base Directory (OS-lock)");
                    ex.printStackTrace();
                    CVSCreate.this.setEnabled(true);
                    return;
                }
                if (CVSCreate.this.validateInput()) {
                    CreateWrapper cw = new CreateWrapper(null);
                    String res = cw.runCreate(CVSCreate.this.getCVSRoot(), bdir, name, CVSCreate.this.commentTxt.getText());
                    if (res != null) {
                        Confirm.ModalMsg("Create Error", res);
                        return;
                    }
                    if (EditApp.App != null) {
                        EditApp.App.updateDirTree();
                    }
                    ((Window)CVSCreate.this.getTopLevelAncestor()).hide();
                }
                CVSCreate.this.setEnabled(true);
            }
        });
    }

    public static void main(String[] args) {
        JFrame f = ApplicationHelper.Singleton().createFrameOn(new CVSCreate());
        f.show();
    }
}

