/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.database.metadata;

import de.netcomputing.database.metadata.DBColumnMetaData;
import de.netcomputing.database.metadata.DBMetaData;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class DBTableMetaData {
    String tableCat;
    String tableSchema;
    String tableName;
    String tableType;
    String remarks;
    String typeCat;
    String typeSchem;
    String typeName;
    String selfRefColumn;
    String selfRefGeneration;
    DBMetaData dbMetaData;
    ArrayList columns = new ArrayList(15);
    HashMap columnMap = new HashMap(15);

    public DBTableMetaData(Connection con, DBMetaData meta, ResultSet tabs) throws SQLException {
        this.dbMetaData = meta;
        this.init(con, tabs);
    }

    public void init(Connection connection, ResultSet tabs) throws SQLException {
        try {
            this.tableCat = tabs.getString("TABLE_CAT");
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            this.tableSchema = tabs.getString("TABLE_SCHEM");
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            this.tableName = tabs.getString("TABLE_NAME");
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            this.tableType = tabs.getString("TABLE_TYPE");
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            this.remarks = tabs.getString("REMARKS");
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            this.typeCat = tabs.getString("TABLE_CAT");
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            this.typeSchem = tabs.getString("TYPE_SCHEM");
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            this.typeName = tabs.getString("TYPE_NAME");
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            this.selfRefColumn = tabs.getString("SELF_REFERENCING_COL_NAME");
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            this.selfRefGeneration = tabs.getString("REF_GENERATION");
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            Statement st = connection.createStatement();
            st.setMaxRows(2);
            if (this.getTableSchema() == null || this.getTableSchema().length() == 0) {
                st.execute("SELECT * FROM " + this.getTableName());
            } else {
                st.execute("SELECT * FROM " + this.getTableSchema() + "." + this.getTableName());
            }
            ResultSet rs = st.getResultSet();
            ResultSetMetaData md = rs.getMetaData();
            int i = 1;
            while (i <= md.getColumnCount()) {
                DBColumnMetaData col = new DBColumnMetaData(this, md, i);
                this.columns.add(col);
                this.columnMap.put(col.getName().toUpperCase(), col);
                ++i;
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DBColumnMetaData getColumn(String name) {
        return (DBColumnMetaData)this.columnMap.get(name.toUpperCase());
    }

    public ArrayList getColumns() {
        return this.columns;
    }

    public DBMetaData getDbMetaData() {
        return this.dbMetaData;
    }

    public String getTableSchema() {
        if (this.tableSchema == null) {
            return "";
        }
        return this.tableSchema;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public String getSelfRefColumn() {
        return this.selfRefColumn;
    }

    public String getSelfRefGeneration() {
        return this.selfRefGeneration;
    }

    public String getTableCat() {
        return this.tableCat;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        if (this.tableType == null) {
            return "";
        }
        return this.tableType;
    }

    public String getTypeCat() {
        return this.typeCat;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeSchem() {
        return this.typeSchem;
    }
}

