/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.ib;

import JCollections.JArray;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.ib.BeanNode;
import de.netcomputing.util.Tracer;
import java.awt.Frame;
import java.awt.Image;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import plugins.IBPlugin;

class JARNode
extends ListItem {
    public JARNode(String o, Image _im) {
        super((Object)o, _im);
    }

    public Image getImage() {
        return NCApplication.GetImage("lbox-arrow");
    }

    public Image getOpenImage() {
        return NCApplication.GetImage("lbox-arrow-open");
    }

    public boolean hasContent() {
        return true;
    }

    public String getJarFile() {
        return this.wrappedObject().toString();
    }

    public Vector analyzeJar(String finame) throws Exception {
        ZipFile zi = new ZipFile(finame);
        ZipEntry manifest = zi.getEntry("META-INF/MANIFEST.MF");
        Vector<String> result = new Vector<String>(13);
        if (manifest != null) {
            DataInputStream in = new DataInputStream(zi.getInputStream(manifest));
            String line = null;
            String actClass = "";
            while ((line = in.readLine()) != null) {
                if (line.startsWith("Name:")) {
                    actClass = line.substring(5).trim();
                    continue;
                }
                if (!line.startsWith("Java-Bean:") || line.toLowerCase().indexOf("true") < 0) continue;
                result.addElement(actClass);
            }
            in.close();
        } else {
            Enumeration<? extends ZipEntry> en = zi.entries();
            while (en.hasMoreElements()) {
                Tracer.This.println(en.nextElement());
            }
        }
        zi.close();
        return result;
    }

    public void itemHasCollapsed() {
        this.cont = null;
    }

    public IListItem[] contents() {
        JArray beans = new JArray(20);
        try {
            if (IBPlugin.options != null) {
                IBPlugin.options.cursorWait();
            }
            Vector v = this.analyzeJar(this.getJarFile());
            int n = 0;
            while (n < v.size()) {
                String bean = "" + v.elementAt(n);
                if (bean.length() > 6) {
                    bean = bean.substring(0, bean.length() - 6);
                }
                beans.add(new BeanNode((Object)bean, null));
                ++n;
            }
        }
        catch (Exception ex) {
            if (IBPlugin.options != null) {
                IBPlugin.options.cursorDefault();
            }
            Confirm.ModalMsg((Frame)IBPlugin.options.getFrame(), "Error during jar analysis", new String[]{"The exception was thrown:", ex.getClass().getName(), ex.getMessage()});
            ex.printStackTrace();
        }
        if (IBPlugin.options != null) {
            IBPlugin.options.cursorDefault();
        }
        IBPlugin.options.addJarToProject(this.getJarFile());
        this.cont = new IListItem[beans.size()];
        int n = 0;
        while (n < this.cont.length) {
            this.cont[n] = (IListItem)beans.at(n);
            ++n;
        }
        return super.contents();
    }
}

