/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.installer;

import JWVFile.VFile;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCStatusImpl;
import de.netcomputing.installer.AJUpdatePanelGUI;
import de.netcomputing.installer.Synchronizer;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.File;
import java.net.URL;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;

public class AJUpdatePanel
extends JPanel {
    JButton updateBtn;
    JButton cancelBtn;
    JButton checlUpdateBtn;
    JTextField portTxt;
    JTextField hostTxt;
    JCheckBox useProxChk;
    JEditorPane msgTxt;
    JProgressBar progress;
    boolean canceled = false;
    public static String proxyHost = "";
    public static String proxyPort = "";
    Set updates = null;
    Set fileUpdates = null;

    public static void Open() {
        JDialog dg = new JDialog(EditApp.App.getMainWindow(), "Update AnyJ", true);
        final AJUpdatePanel ft = new AJUpdatePanel();
        dg.getContentPane().add(ft);
        ft.initGui();
        dg.pack();
        JWidgetsUtil.CenterWindow((Window)dg, new Dimension(400, 330));
        dg.setDefaultCloseOperation(2);
        dg.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                ft.cancelBtn_actionPerformed(null);
            }
        });
        dg.show();
    }

    public void initGui() {
        new AJUpdatePanelGUI().createGui(this);
        this.updateBtn.setEnabled(false);
        ((JComponent)this.msgTxt.getParent().getParent()).setBorder(BorderFactory.createEmptyBorder());
        this.msgTxt.setText("<html><br><b>Press 'Look for Updates' to start</b><br>If you connect to the internet through a proxy, please specify host and port before.</html>");
        this.hostTxt.setEnabled(this.useProxChk.isSelected());
        this.portTxt.setEnabled(this.useProxChk.isSelected());
        this.hostTxt.setText(proxyHost);
        this.portTxt.setText(proxyPort);
        Synchronizer.This.doCancel = false;
    }

    void deleteFiles(String commaSepFileList) {
        Vector files = NCStringUtilities.SplitSeparatedString(";", commaSepFileList);
        int i = 0;
        while (i < files.size()) {
            new VFile("#jxebase/" + files.get(i)).delete();
            ++i;
        }
    }

    public void checkForUpdates() {
        try {
            this.msgTxt.setText("<html><br><b>Checking for updates</b><br>Please wait while AnyJ is checking whether an update is available</html>");
            URL msgUrl = new URL(Synchronizer.This.baseUrl + "update/msg.txt");
            DataInputStream in = new DataInputStream(msgUrl.openStream());
            String control = in.readLine();
            String msg = in.readLine();
            try {
                String delete = in.readLine();
                this.deleteFiles(delete);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            in.close();
            if ("in_update".equals(control)) {
                this.msgTxt.setText("<html><br><b>Server is updated currently</b><br>Try again later, please.</html>");
                return;
            }
            if (new VFile("#jxebase/bin/anyjupd.jar").exists()) {
                String aju = new VFile("#jxebase/bin/anyjupd.jar").getAbsolutePath();
                String aj = new VFile("#jxebase/bin/anyj.jar").getAbsolutePath();
                this.msgTxt.setText("<html><br><b>Last update failed !</b><br>The file " + aju + " should have been copied to " + aj + ". You can do this manually to correct the problem.</html>");
                return;
            }
            if ("final_msg".equals(control)) {
                this.msgTxt.setText(msg);
                return;
            }
            if (!"display_msg".equals(control)) {
                msg = "";
            }
            NCStatusImpl status = new NCStatusImpl(this.progress);
            status.setToDo(4000);
            this.updates = Synchronizer.This.findClassUpdates(VFile.ResolveName("#jxebase") + File.separator, status);
            if (this.canceled) {
                return;
            }
            this.fileUpdates = Synchronizer.This.findFileUpdates(VFile.ResolveName("#jxebase") + File.separator, status);
            status.setDone(4000);
            status.setText("update check finished");
            if (this.updates.size() > 0 || this.fileUpdates.size() > 0) {
                this.msgTxt.setText("<html><br><b>Updates found !</b><br>AnyJ found " + (this.updates.size() + this.fileUpdates.size()) + " modified files. Press 'Update' to upgrade AnyJ.<br>" + msg + "</html>");
                this.updateBtn.setEnabled(true);
            } else {
                this.msgTxt.setText("<html><br><b>No updates available !</b><br>Your version is up to date.<br>" + msg + "</html>");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
            Confirm.MsgException(ex);
            this.msgTxt.setText("Error connecting update server.");
        }
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void useProxChk_stateChanged(ChangeEvent var0) {
        this.hostTxt.setEnabled(this.useProxChk.isSelected());
        this.portTxt.setEnabled(this.useProxChk.isSelected());
        proxyPort = this.portTxt.getText().trim();
        proxyHost = this.hostTxt.getText().trim();
    }

    public void checlUpdateBtn_actionPerformed(ActionEvent var0) {
        new Thread(){

            public void run() {
                AJUpdatePanel.this.checlUpdateBtn.setEnabled(false);
                if (AJUpdatePanel.this.useProxChk.isSelected()) {
                    System.setProperty("proxySet", "true");
                    System.setProperty("proxyPort", AJUpdatePanel.this.portTxt.getText().trim());
                    System.setProperty("proxyHost", AJUpdatePanel.this.hostTxt.getText().trim());
                    proxyPort = AJUpdatePanel.this.portTxt.getText().trim();
                    proxyHost = AJUpdatePanel.this.hostTxt.getText().trim();
                } else {
                    System.setProperty("proxySet", "false");
                }
                AJUpdatePanel.this.checkForUpdates();
            }
        }.start();
    }

    public void updateBtn_actionPerformed(ActionEvent var0) {
        new Thread(){

            public void run() {
                NCStatusImpl ncst = new NCStatusImpl(AJUpdatePanel.this.progress);
                try {
                    if (AJUpdatePanel.this.updates.size() > 0) {
                        AJUpdatePanel.this.updateBtn.setEnabled(false);
                        Synchronizer.This.patchClasses(AJUpdatePanel.this.updates, VFile.ResolveName("#jxebase") + File.separator, ncst);
                    }
                    if (AJUpdatePanel.this.fileUpdates.size() > 0 && !Synchronizer.This.doCancel) {
                        AJUpdatePanel.this.cancelBtn.setEnabled(false);
                        AJUpdatePanel.this.updateBtn.setEnabled(false);
                        Synchronizer.This.patchFiles(AJUpdatePanel.this.fileUpdates, VFile.ResolveName("#jxebase") + File.separator, ncst);
                        AJUpdatePanel.this.cancelBtn.setEnabled(true);
                    }
                    EditApp.App.jol.xmlImport(new URL(Synchronizer.This.baseUrl + "update/anyjproj.ajpr"));
                    AJUpdatePanel.this.msgTxt.setText("<html><br>Update finished successfully. <b>Please restart AnyJ.</b></html>");
                    ncst.setDone(999999);
                    ncst.setText("finished");
                    AJUpdatePanel.this.updateBtn.setVisible(false);
                    AJUpdatePanel.this.cancelBtn.setText("Ok");
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                    ncst.setText("Error");
                    Confirm.MsgException(ex);
                    AJUpdatePanel.this.msgTxt.setText("Error downloading from update server.");
                }
            }
        }.start();
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        Synchronizer.This.doCancel = true;
        ((Window)this.getTopLevelAncestor()).dispose();
    }
}

